/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import dev.architectury.loom.forge.minecraft.ForgeMinecraftProvider;
import java.util.List;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.ConfigContext;
import net.fabricmc.loom.configuration.decompile.DecompileConfiguration;
import net.fabricmc.loom.configuration.decompile.SingleJarDecompileConfiguration;
import net.fabricmc.loom.configuration.decompile.SplitDecompileConfiguration;
import net.fabricmc.loom.configuration.processors.MinecraftJarProcessorManager;
import net.fabricmc.loom.configuration.providers.minecraft.LegacyMergedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MergedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftMetadataProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.SingleJarMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.SplitMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.IntermediaryMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MappedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MojangMappedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.NamedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.ProcessedNamedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.SrgMinecraftProvider;
import org.gradle.api.Project;

public record MinecraftJarConfiguration<M extends MinecraftProvider, N extends NamedMinecraftProvider<M>, Q extends MappedMinecraftProvider>(MinecraftProviderFactory<M> minecraftProviderFactory, IntermediaryMinecraftProviderFactory<M> intermediaryMinecraftProviderFactory, NamedMinecraftProviderFactory<M> namedMinecraftProviderFactory, SrgMinecraftProviderFactory<M> srgMinecraftProviderFactory, MojangMappedMinecraftProviderFactory<M> mojangMappedMinecraftProviderFactory, ProcessedNamedMinecraftProviderFactory<M, N> processedNamedMinecraftProviderFactory, DecompileConfigurationFactory<Q> decompileConfigurationFactory, List<String> supportedEnvironments) {
    public static final MinecraftJarConfiguration<MergedMinecraftProvider, NamedMinecraftProvider.MergedImpl, MappedMinecraftProvider> MERGED = new MinecraftJarConfiguration<MergedMinecraftProvider, NamedMinecraftProvider.MergedImpl, MappedMinecraftProvider>(ForgeMinecraftProvider::createMerged, IntermediaryMinecraftProvider.MergedImpl::new, NamedMinecraftProvider.MergedImpl::new, SrgMinecraftProvider.MergedImpl::new, MojangMappedMinecraftProvider.MergedImpl::new, ProcessedNamedMinecraftProvider.MergedImpl::new, SingleJarDecompileConfiguration::new, List.of("client", "server"));
    public static final MinecraftJarConfiguration<LegacyMergedMinecraftProvider, NamedMinecraftProvider.LegacyMergedImpl, MappedMinecraftProvider> LEGACY_MERGED = new MinecraftJarConfiguration<LegacyMergedMinecraftProvider, NamedMinecraftProvider.LegacyMergedImpl, MappedMinecraftProvider>(LegacyMergedMinecraftProvider::new, IntermediaryMinecraftProvider.LegacyMergedImpl::new, NamedMinecraftProvider.LegacyMergedImpl::new, SrgMinecraftProvider.LegacyMergedImpl::new, MojangMappedMinecraftProvider.LegacyMergedImpl::new, ProcessedNamedMinecraftProvider.LegacyMergedImpl::new, SingleJarDecompileConfiguration::new, List.of("client", "server"));
    public static final MinecraftJarConfiguration<SingleJarMinecraftProvider, NamedMinecraftProvider.SingleJarImpl, MappedMinecraftProvider> SERVER_ONLY = new MinecraftJarConfiguration<SingleJarMinecraftProvider, NamedMinecraftProvider.SingleJarImpl, MappedMinecraftProvider>(ForgeMinecraftProvider::createServerOnly, IntermediaryMinecraftProvider.SingleJarImpl::server, NamedMinecraftProvider.SingleJarImpl::server, SrgMinecraftProvider.SingleJarImpl::server, MojangMappedMinecraftProvider.SingleJarImpl::server, ProcessedNamedMinecraftProvider.SingleJarImpl::server, SingleJarDecompileConfiguration::new, List.of("server"));
    public static final MinecraftJarConfiguration<SingleJarMinecraftProvider, NamedMinecraftProvider.SingleJarImpl, MappedMinecraftProvider> CLIENT_ONLY = new MinecraftJarConfiguration<SingleJarMinecraftProvider, NamedMinecraftProvider.SingleJarImpl, MappedMinecraftProvider>(ForgeMinecraftProvider::createClientOnly, IntermediaryMinecraftProvider.SingleJarImpl::client, NamedMinecraftProvider.SingleJarImpl::client, SrgMinecraftProvider.SingleJarImpl::client, MojangMappedMinecraftProvider.SingleJarImpl::client, ProcessedNamedMinecraftProvider.SingleJarImpl::client, SingleJarDecompileConfiguration::new, List.of("client"));
    public static final MinecraftJarConfiguration<SplitMinecraftProvider, NamedMinecraftProvider.SplitImpl, MappedMinecraftProvider.Split> SPLIT = new MinecraftJarConfiguration<SplitMinecraftProvider, NamedMinecraftProvider.SplitImpl, MappedMinecraftProvider.Split>(SplitMinecraftProvider::new, IntermediaryMinecraftProvider.SplitImpl::new, NamedMinecraftProvider.SplitImpl::new, SrgMinecraftProvider.SplitImpl::new, MojangMappedMinecraftProvider.SplitImpl::new, ProcessedNamedMinecraftProvider.SplitImpl::new, SplitDecompileConfiguration::new, List.of("client", "server"));

    public MinecraftProvider createMinecraftProvider(MinecraftMetadataProvider metadataProvider, ConfigContext context) {
        return this.minecraftProviderFactory.create(metadataProvider, context);
    }

    public IntermediaryMinecraftProvider<M> createIntermediaryMinecraftProvider(Project project) {
        return this.intermediaryMinecraftProviderFactory.create(project, this.getMinecraftProvider(project));
    }

    public NamedMinecraftProvider<M> createNamedMinecraftProvider(Project project) {
        return this.namedMinecraftProviderFactory.create(project, this.getMinecraftProvider(project));
    }

    public SrgMinecraftProvider<M> createSrgMinecraftProvider(Project project) {
        return this.srgMinecraftProviderFactory.create(project, this.getMinecraftProvider(project));
    }

    public MojangMappedMinecraftProvider<M> createMojangMappedMinecraftProvider(Project project) {
        return this.mojangMappedMinecraftProviderFactory.create(project, this.getMinecraftProvider(project));
    }

    public ProcessedNamedMinecraftProvider<M, N> createProcessedNamedMinecraftProvider(NamedMinecraftProvider<?> namedMinecraftProvider, MinecraftJarProcessorManager jarProcessorManager) {
        return this.processedNamedMinecraftProviderFactory.create(namedMinecraftProvider, jarProcessorManager);
    }

    public DecompileConfiguration<Q> createDecompileConfiguration(Project project) {
        return this.decompileConfigurationFactory.create(project, this.getMappedMinecraftProvider(project));
    }

    private M getMinecraftProvider(Project project) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        return (M)extension.getMinecraftProvider();
    }

    private Q getMappedMinecraftProvider(Project project) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        return (Q)extension.getNamedMinecraftProvider();
    }

    public List<String> getSupportedEnvironments() {
        return this.supportedEnvironments;
    }

    private static interface MinecraftProviderFactory<M extends MinecraftProvider> {
        public M create(MinecraftMetadataProvider var1, ConfigContext var2);
    }

    private static interface IntermediaryMinecraftProviderFactory<M extends MinecraftProvider> {
        public IntermediaryMinecraftProvider<M> create(Project var1, M var2);
    }

    private static interface NamedMinecraftProviderFactory<M extends MinecraftProvider> {
        public NamedMinecraftProvider<M> create(Project var1, M var2);
    }

    private static interface SrgMinecraftProviderFactory<M extends MinecraftProvider> {
        public SrgMinecraftProvider<M> create(Project var1, M var2);
    }

    private static interface MojangMappedMinecraftProviderFactory<M extends MinecraftProvider> {
        public MojangMappedMinecraftProvider<M> create(Project var1, M var2);
    }

    private static interface ProcessedNamedMinecraftProviderFactory<M extends MinecraftProvider, N extends NamedMinecraftProvider<M>> {
        public ProcessedNamedMinecraftProvider<M, N> create(N var1, MinecraftJarProcessorManager var2);
    }

    private static interface DecompileConfigurationFactory<M extends MappedMinecraftProvider> {
        public DecompileConfiguration<M> create(Project var1, M var2);
    }
}

