/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.service;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.loom.task.RemapSourcesJarTask;
import net.fabricmc.loom.task.service.MappingsService;
import net.fabricmc.loom.util.DeletingFileVisitor;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.Pair;
import net.fabricmc.loom.util.SourceRemapper;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import net.fabricmc.lorenztiny.TinyMappingsReader;
import net.fabricmc.mappingio.tree.MappingTree;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.mercury.Mercury;
import org.cadixdev.mercury.remapper.MercuryRemapper;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.compile.JavaCompile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SourceRemapperService
extends Service<Options> {
    public static ServiceType<Options, SourceRemapperService> TYPE = new ServiceType<Options, SourceRemapperService>(Options.class, SourceRemapperService.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceRemapperService.class);

    public static Provider<Options> createOptions(RemapSourcesJarTask task) {
        return TYPE.create(task.getProject(), (Action<Options>)((Action)o -> {
            o.getMappings().set(MappingsService.createForRemapTask(task));
            o.getJavaCompileRelease().set((Object)SourceRemapperService.getJavaCompileRelease(task.getProject()));
            o.getClasspath().from(new Object[]{task.getClasspath()});
        }));
    }

    public SourceRemapperService(Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remapSourcesJar(Path source, Path destination) throws IOException {
        if (source.equals(destination)) {
            throw new UnsupportedOperationException("Cannot remap in place");
        }
        Path srcPath = source;
        boolean isSrcTmp = false;
        if (!Files.isDirectory(source, new LinkOption[0])) {
            isSrcTmp = true;
            srcPath = Files.createTempDirectory("fabric-loom-src", new FileAttribute[0]);
            ZipUtils.unpackAll(source, srcPath);
        }
        if (!Files.isDirectory(destination, new LinkOption[0]) && Files.exists(destination, new LinkOption[0])) {
            Files.delete(destination);
        }
        Mercury mercury = this.createMercury();
        try (FileSystemUtil.Delegate dstFs = Files.isDirectory(destination, new LinkOption[0]) ? null : FileSystemUtil.getJarFileSystem(destination, true);){
            Path dstPath = dstFs != null ? dstFs.get().getPath("/", new String[0]) : destination;
            try {
                mercury.rewrite(srcPath, dstPath);
            }
            catch (Exception e) {
                LOGGER.warn("Could not remap " + String.valueOf(source) + " fully!", (Throwable)e);
            }
            SourceRemapper.copyNonJavaFiles(srcPath, dstPath, LOGGER, source);
        }
        finally {
            if (isSrcTmp) {
                Files.walkFileTree(srcPath, new DeletingFileVisitor());
            }
        }
    }

    private Mercury createMercury() throws IOException {
        Mercury mercury = new Mercury();
        mercury.setGracefulClasspathChecks(true);
        mercury.setSourceCompatibilityFromRelease(((Integer)((Options)this.getOptions()).getJavaCompileRelease().get()).intValue());
        MappingsService mappingsService = (MappingsService)this.getServiceFactory().get(((Options)this.getOptions()).getMappings());
        MappingSet tinyMappingsReader = new TinyMappingsReader((MappingTree)mappingsService.getMemoryMappingTree(), mappingsService.getFrom(), mappingsService.getTo()).read();
        for (Pair mapping : (List)((Options)this.getOptions()).getAdditionalClassMappings().getOrElse(List.of())) {
            tinyMappingsReader.getOrCreateClassMapping((String)mapping.left()).setDeobfuscatedName((String)mapping.right());
        }
        mercury.getProcessors().add(MercuryRemapper.create((MappingSet)tinyMappingsReader));
        for (File file : ((Options)this.getOptions()).getClasspath().getFiles()) {
            if (!file.exists()) continue;
            mercury.getClassPath().add(file.toPath());
        }
        return mercury;
    }

    public static int getJavaCompileRelease(Project project) {
        AtomicInteger release = new AtomicInteger(-1);
        project.getTasks().withType(JavaCompile.class, javaCompile -> {
            Property releaseProperty = javaCompile.getOptions().getRelease();
            if (!releaseProperty.isPresent()) {
                return;
            }
            int compileRelease = (Integer)releaseProperty.get();
            release.set(Math.max(release.get(), compileRelease));
        });
        int i = release.get();
        if (i < 0) {
            return Integer.parseInt(JavaVersion.current().getMajorVersion());
        }
        return i;
    }

    public static interface Options
    extends Service.Options {
        @Nested
        public Property<MappingsService.Options> getMappings();

        @Input
        public Property<Integer> getJavaCompileRelease();

        @InputFiles
        public ConfigurableFileCollection getClasspath();

        @Input
        @Optional
        public ListProperty<Pair<String, String>> getAdditionalClassMappings();
    }
}

