/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import dev.architectury.loom.accesstransformer.Aw2At;
import dev.architectury.loom.util.PropertyUtil;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.build.nesting.NestableJarGenerationTask;
import net.fabricmc.loom.task.RemapJarTask;
import net.fabricmc.loom.task.RemapSourcesJarTask;
import net.fabricmc.loom.util.gradle.GradleUtils;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import net.fabricmc.loom.util.gradle.SyncTaskBuildService;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.jvm.tasks.Jar;

public abstract class RemapTaskConfiguration
implements Runnable {
    public static final String REMAP_JAR_TASK_NAME = "remapJar";
    public static final String REMAP_SOURCES_JAR_TASK_NAME = "remapSourcesJar";

    @Inject
    protected abstract Project getProject();

    @Inject
    protected abstract TaskContainer getTasks();

    @Inject
    protected abstract ArtifactHandler getArtifacts();

    @Inject
    protected abstract ConfigurationContainer getConfigurations();

    @Override
    public void run() {
        LoomGradleExtension extension = LoomGradleExtension.get(this.getProject());
        SyncTaskBuildService.register(this.getProject());
        if (extension.dontRemapOutputs()) {
            extension.getUnmappedModCollection().from(new Object[]{this.getTasks().getByName("jar")});
            return;
        }
        Configuration includeConfiguration = this.getProject().getConfigurations().getByName("includeInternal");
        this.getTasks().register("processIncludeJars", NestableJarGenerationTask.class, task -> {
            task.from(includeConfiguration);
            task.getOutputDirectory().set(this.getProject().getLayout().getBuildDirectory().dir(task.getName()));
        });
        Action remapJarTaskAction = task -> {
            TaskProvider jarTask = this.getTasks().named("jar", AbstractArchiveTask.class);
            task.dependsOn(new Object[]{jarTask});
            task.setDescription("Remaps the built project jar to intermediary mappings.");
            task.setGroup("loom");
            this.getArtifacts().add("apiElements", (Object)task);
            this.getArtifacts().add("runtimeElements", (Object)task);
            task.getInputFile().convention(jarTask.flatMap(AbstractArchiveTask::getArchiveFile));
            task.dependsOn(new Object[]{this.getTasks().named("jar")});
            task.getIncludesClientOnlyClasses().set(this.getProject().provider(extension::areEnvironmentSourceSetsSplit));
        };
        this.getTasks().create(REMAP_JAR_TASK_NAME, RemapJarTask.class, remapJarTaskAction);
        this.getTasks().named("jar", AbstractArchiveTask.class).configure(task -> {
            task.getArchiveClassifier().convention((Object)"dev");
            task.getDestinationDirectory().set(this.getProject().getLayout().getBuildDirectory().map(directory -> directory.dir("devlibs")));
        });
        this.getTasks().named("assemble").configure(task -> task.dependsOn(new Object[]{this.getTasks().named(REMAP_JAR_TASK_NAME)}));
        this.trySetupSourceRemapping();
        this.getProject().afterEvaluate(p -> {
            if (extension.isForge()) {
                Set mixinConfigs;
                if (((Boolean)PropertyUtil.getAndFinalize(extension.getForge().getConvertAccessWideners())).booleanValue()) {
                    Aw2At.setup(this.getProject(), (RemapJarTask)this.getTasks().getByName(REMAP_JAR_TASK_NAME));
                }
                if (!(mixinConfigs = (Set)PropertyUtil.getAndFinalize(extension.getForge().getMixinConfigs())).isEmpty()) {
                    this.getTasks().named("jar", Jar.class, task -> task.manifest(manifest -> manifest.attributes(Map.of("MixinConfigs", String.join((CharSequence)",", mixinConfigs)))));
                }
            }
        });
        if (GradleUtils.getBooleanProperty(this.getProject(), "fabric.loom.disableRemappedVariants")) {
            return;
        }
        GradleUtils.afterSuccessfulEvaluation(this.getProject(), () -> {
            for (String configurationName : new String[]{"apiElements", "runtimeElements"}) {
                Configuration configuration = this.getConfigurations().getByName(configurationName);
                Jar jarTask = (Jar)this.getTasks().getByName("jar");
                configuration.getArtifacts().removeIf(artifact -> artifact.getFile().getAbsolutePath().equals(((RegularFile)jarTask.getArchiveFile().get()).getAsFile().getAbsolutePath()) && (extension.isProjectIsolationActive() || artifact.getBuildDependencies().getDependencies(null).contains(jarTask)));
            }
        });
    }

    private void trySetupSourceRemapping() {
        LoomGradleExtension extension = LoomGradleExtension.get(this.getProject());
        TaskProvider remapSourcesTask = this.getTasks().register(REMAP_SOURCES_JAR_TASK_NAME, RemapSourcesJarTask.class, task -> {
            task.setDescription("Remaps the default sources jar to intermediary mappings.");
            task.setGroup("loom");
            task.getIncludesClientOnlyClasses().set(this.getProject().provider(extension::areEnvironmentSourceSetsSplit));
        });
        this.getTasks().named("assemble").configure(task -> task.dependsOn(new Object[]{remapSourcesTask}));
        GradleUtils.afterSuccessfulEvaluation(this.getProject(), () -> {
            String sourcesJarTaskName = SourceSetHelper.getMainSourceSet(this.getProject()).getSourcesJarTaskName();
            Task sourcesTask = (Task)this.getTasks().findByName(sourcesJarTaskName);
            boolean canRemap = true;
            if (sourcesTask == null) {
                this.getProject().getLogger().info("{} task was not found, not remapping sources", (Object)sourcesJarTaskName);
                canRemap = false;
            }
            if (canRemap && !(sourcesTask instanceof Jar)) {
                this.getProject().getLogger().info("{} task is not a Jar task, not remapping sources", (Object)sourcesJarTaskName);
                canRemap = false;
            }
            boolean finalCanRemap = canRemap;
            remapSourcesTask.configure(task -> {
                if (!finalCanRemap) {
                    task.setEnabled(false);
                    return;
                }
                Jar sourcesJarTask = (Jar)sourcesTask;
                sourcesJarTask.getArchiveClassifier().convention((Object)"dev-sources");
                sourcesJarTask.getDestinationDirectory().set(this.getProject().getLayout().getBuildDirectory().map(directory -> directory.dir("devlibs")));
                task.getArchiveClassifier().convention((Object)"sources");
                task.dependsOn(new Object[]{sourcesJarTask});
                task.getInputFile().convention(sourcesJarTask.getArchiveFile());
            });
            if (GradleUtils.getBooleanProperty(this.getProject(), "fabric.loom.disableRemappedVariants")) {
                return;
            }
            if (this.getConfigurations().getNames().contains("sourcesElements")) {
                Configuration configuration = this.getConfigurations().getByName("sourcesElements");
                configuration.getArtifacts().removeIf(a -> "sources".equals(a.getClassifier()));
                this.getArtifacts().add("sourcesElements", (Object)remapSourcesTask.map(AbstractArchiveTask::getArchiveFile), artifact -> artifact.setClassifier("sources"));
            } else if (canRemap) {
                this.getProject().getLogger().warn("Not publishing sources jar as it was not created by the java plugin. Use java.withSourcesJar() to fix.");
            }
        });
    }
}

