/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.extension;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.ForgeExtensionAPI;
import net.fabricmc.loom.api.InterfaceInjectionExtensionAPI;
import net.fabricmc.loom.api.LoomGradleExtensionAPI;
import net.fabricmc.loom.api.MixinExtensionAPI;
import net.fabricmc.loom.api.ModSettings;
import net.fabricmc.loom.api.NeoForgeExtensionAPI;
import net.fabricmc.loom.api.RemapConfigurationSettings;
import net.fabricmc.loom.api.decompilers.DecompilerOptions;
import net.fabricmc.loom.api.mappings.intermediate.IntermediateMappingsProvider;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.api.mappings.layered.spec.LayeredMappingSpecBuilder;
import net.fabricmc.loom.api.processor.MinecraftJarProcessor;
import net.fabricmc.loom.api.remapping.RemapperExtension;
import net.fabricmc.loom.api.remapping.RemapperParameters;
import net.fabricmc.loom.configuration.MavenPublication;
import net.fabricmc.loom.configuration.RemapConfigurations;
import net.fabricmc.loom.configuration.ide.RunConfig;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.configuration.processors.JarProcessor;
import net.fabricmc.loom.configuration.providers.mappings.LayeredMappingSpec;
import net.fabricmc.loom.configuration.providers.mappings.LayeredMappingSpecBuilderImpl;
import net.fabricmc.loom.configuration.providers.mappings.LayeredMappingsFactory;
import net.fabricmc.loom.configuration.providers.minecraft.ManifestLocations;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJarConfiguration;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftMetadataProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftSourceSets;
import net.fabricmc.loom.extension.LoomFiles;
import net.fabricmc.loom.extension.MixinExtension;
import net.fabricmc.loom.extension.RemapperExtensionHolder;
import net.fabricmc.loom.task.GenerateSourcesTask;
import net.fabricmc.loom.util.DeprecationHelper;
import net.fabricmc.loom.util.Lazy;
import net.fabricmc.loom.util.MirrorUtil;
import net.fabricmc.loom.util.ModPlatform;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonHelpers;
import net.fabricmc.loom.util.gradle.GradleUtils;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectList;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.publish.Publication;
import org.gradle.api.tasks.SourceSet;

public abstract class LoomGradleExtensionApiImpl
implements LoomGradleExtensionAPI {
    private static final String FORGE_PROPERTY = "loom.forge";
    private static final String PLATFORM_PROPERTY = "loom.platform";
    protected final DeprecationHelper deprecationHelper;
    @Deprecated
    protected final ListProperty<JarProcessor> jarProcessors;
    protected final ConfigurableFileCollection log4jConfigs;
    protected final RegularFileProperty accessWidener;
    protected final RegularFileProperty fabricModJsonPath;
    protected final ManifestLocations versionsManifests;
    protected final Property<String> customMetadata;
    protected final SetProperty<String> knownIndyBsms;
    protected final Property<Boolean> transitiveAccessWideners;
    protected final Property<Boolean> modProvidedJavadoc;
    protected final Property<String> intermediary;
    protected final Property<IntermediateMappingsProvider> intermediateMappingsProvider;
    private final Property<Boolean> runtimeOnlyLog4j;
    private final Property<Boolean> splitModDependencies;
    private final Property<MinecraftJarConfiguration<?, ?, ?>> minecraftJarConfiguration;
    private final Property<Boolean> splitEnvironmentalSourceSet;
    private final InterfaceInjectionExtensionAPI interfaceInjectionExtension;
    private final NamedDomainObjectContainer<RunConfigSettings> runConfigs;
    private final NamedDomainObjectContainer<DecompilerOptions> decompilers;
    private final NamedDomainObjectContainer<ModSettings> mods;
    private final NamedDomainObjectList<RemapConfigurationSettings> remapConfigurations;
    private final ListProperty<MinecraftJarProcessor<?>> minecraftJarProcessors;
    protected final ListProperty<RemapperExtensionHolder> remapperExtensions;
    protected final ThreadLocal<Boolean> layeredSpecBuilderScope = ThreadLocal.withInitial(() -> false);
    public static final String DEFAULT_INTERMEDIARY_URL = "https://maven.fabricmc.net/net/fabricmc/intermediary/%1$s/intermediary-%1$s-v2.jar";
    protected boolean hasEvaluatedLayeredMappings = false;
    protected final Map<LayeredMappingSpec, LayeredMappingsFactory> layeredMappingsDependencyMap = new HashMap<LayeredMappingSpec, LayeredMappingsFactory>();
    private Provider<ModPlatform> platform;
    private final Property<Boolean> silentMojangMappingsLicense;
    public Boolean generateSrgTiny = null;
    private final List<String> tasksBeforeRun = Collections.synchronizedList(new ArrayList());
    public final List<Consumer<RunConfig>> settingsPostEdit = new ArrayList<Consumer<RunConfig>>();

    protected LoomGradleExtensionApiImpl(Project project, LoomFiles directories) {
        this.jarProcessors = project.getObjects().listProperty(JarProcessor.class).empty();
        this.log4jConfigs = project.files(new Object[]{directories.getDefaultLog4jConfigFile()});
        this.accessWidener = project.getObjects().fileProperty();
        this.fabricModJsonPath = project.getObjects().fileProperty();
        this.versionsManifests = new ManifestLocations();
        this.versionsManifests.add("mojang", MirrorUtil.getVersionManifests((ExtensionAware)project), -2);
        this.versionsManifests.add("fabric_experimental", MirrorUtil.getExperimentalVersions((ExtensionAware)project), -1);
        this.customMetadata = project.getObjects().property(String.class);
        this.knownIndyBsms = project.getObjects().setProperty(String.class).convention(Set.of("java/lang/invoke/StringConcatFactory", "java/lang/runtime/ObjectMethods", "org/codehaus/groovy/vmplugin/v8/IndyInterface"));
        this.knownIndyBsms.finalizeValueOnRead();
        this.transitiveAccessWideners = project.getObjects().property(Boolean.class).convention((Object)true);
        this.transitiveAccessWideners.finalizeValueOnRead();
        this.modProvidedJavadoc = project.getObjects().property(Boolean.class).convention(project.provider(() -> !this.isForgeLike()));
        this.modProvidedJavadoc.finalizeValueOnRead();
        this.intermediary = project.getObjects().property(String.class).convention((Object)DEFAULT_INTERMEDIARY_URL);
        this.intermediateMappingsProvider = project.getObjects().property(IntermediateMappingsProvider.class);
        this.intermediateMappingsProvider.finalizeValueOnRead();
        this.deprecationHelper = new DeprecationHelper.ProjectBased(project);
        this.runConfigs = project.container(RunConfigSettings.class, baseName -> (RunConfigSettings)project.getObjects().newInstance(RunConfigSettings.class, new Object[]{project, baseName}));
        this.decompilers = project.getObjects().domainObjectContainer(DecompilerOptions.class);
        this.mods = project.getObjects().domainObjectContainer(ModSettings.class);
        this.remapConfigurations = project.getObjects().namedDomainObjectList(RemapConfigurationSettings.class);
        this.minecraftJarProcessors = project.getObjects().listProperty(MinecraftJarProcessor.class);
        this.minecraftJarProcessors.finalizeValueOnRead();
        this.minecraftJarConfiguration = project.getObjects().property(MinecraftJarConfiguration.class).convention(project.provider(() -> {
            LoomGradleExtension extension = LoomGradleExtension.get(project);
            MinecraftMetadataProvider metadataProvider = extension.getMetadataProvider();
            if (!metadataProvider.getVersionMeta().hasServer()) {
                return MinecraftJarConfiguration.CLIENT_ONLY;
            }
            if (!metadataProvider.getVersionMeta().hasClient()) {
                return MinecraftJarConfiguration.SERVER_ONLY;
            }
            if (!metadataProvider.getVersionMeta().isLegacyVersion()) {
                return MinecraftJarConfiguration.MERGED;
            }
            return MinecraftJarConfiguration.LEGACY_MERGED;
        }));
        this.minecraftJarConfiguration.finalizeValueOnRead();
        this.accessWidener.finalizeValueOnRead();
        this.getGameJarProcessors().finalizeValueOnRead();
        this.runtimeOnlyLog4j = project.getObjects().property(Boolean.class).convention((Object)false);
        this.runtimeOnlyLog4j.finalizeValueOnRead();
        this.splitModDependencies = project.getObjects().property(Boolean.class).convention((Object)true);
        this.splitModDependencies.finalizeValueOnRead();
        this.interfaceInjectionExtension = (InterfaceInjectionExtensionAPI)project.getObjects().newInstance(InterfaceInjectionExtensionAPI.class, new Object[0]);
        this.interfaceInjectionExtension.getIsEnabled().convention((Object)true);
        this.splitEnvironmentalSourceSet = project.getObjects().property(Boolean.class).convention((Object)false);
        this.splitEnvironmentalSourceSet.finalizeValueOnRead();
        this.remapperExtensions = project.getObjects().listProperty(RemapperExtensionHolder.class);
        this.remapperExtensions.finalizeValueOnRead();
        this.interfaceInjection((Action<InterfaceInjectionExtensionAPI>)((Action)interfaceInjection -> interfaceInjection.getEnableDependencyInterfaceInjection().convention((Object)true).finalizeValueOnRead()));
        this.platform = project.provider(((Supplier<ModPlatform>)Lazy.of(() -> {
            Object platformProperty = GradleUtils.getProperty(project, PLATFORM_PROPERTY);
            if (platformProperty != null) {
                ModPlatform platform = ModPlatform.valueOf(Objects.toString(platformProperty).toUpperCase(Locale.ROOT));
                if (platform.isExperimental()) {
                    project.getLogger().lifecycle("{} support is experimental. Please report any issues!", new Object[]{platform.displayName()});
                }
                return platform;
            }
            Object forgeProperty = GradleUtils.getProperty(project, FORGE_PROPERTY);
            if (forgeProperty != null) {
                project.getLogger().warn("Project " + project.getPath() + " is using property loom.forge to enable forge mode. Please use 'loom.platform = forge' instead!");
                return Boolean.parseBoolean(Objects.toString(forgeProperty)) ? ModPlatform.FORGE : ModPlatform.FABRIC;
            }
            return ModPlatform.FABRIC;
        }))::get);
        this.silentMojangMappingsLicense = project.getObjects().property(Boolean.class).convention((Object)false);
        this.silentMojangMappingsLicense.finalizeValueOnRead();
    }

    @Override
    public DeprecationHelper getDeprecationHelper() {
        return this.deprecationHelper;
    }

    @Override
    public RegularFileProperty getAccessWidenerPath() {
        return this.accessWidener;
    }

    @Override
    public RegularFileProperty getFabricModJsonPath() {
        return this.fabricModJsonPath;
    }

    @Override
    public NamedDomainObjectContainer<DecompilerOptions> getDecompilerOptions() {
        return this.decompilers;
    }

    @Override
    public void decompilers(Action<NamedDomainObjectContainer<DecompilerOptions>> action) {
        action.execute(this.decompilers);
    }

    @Override
    public ListProperty<JarProcessor> getGameJarProcessors() {
        return this.jarProcessors;
    }

    @Override
    public ListProperty<MinecraftJarProcessor<?>> getMinecraftJarProcessors() {
        return this.minecraftJarProcessors;
    }

    @Override
    public void addMinecraftJarProcessor(Class<? extends MinecraftJarProcessor<?>> clazz, Object ... parameters) {
        this.getMinecraftJarProcessors().add((Object)((MinecraftJarProcessor)this.getProject().getObjects().newInstance(clazz, parameters)));
    }

    @Override
    public Dependency officialMojangMappings() {
        if (this.notObfuscated()) {
            throw new UnsupportedOperationException("Cannot use Mojang mappings in a non-obfuscated environment");
        }
        if (this.layeredSpecBuilderScope.get().booleanValue()) {
            throw new IllegalStateException("Use `officialMojangMappings()` when configuring layered mappings, not the extension method `loom.officialMojangMappings()`");
        }
        return this.layered((Action<LayeredMappingSpecBuilder>)((Action)LayeredMappingSpecBuilder::officialMojangMappings));
    }

    @Override
    public Dependency layered(Action<LayeredMappingSpecBuilder> action) {
        if (this.notObfuscated()) {
            throw new UnsupportedOperationException("Cannot configure layered mappings in a non-obfuscated environment");
        }
        if (this.hasEvaluatedLayeredMappings) {
            throw new IllegalStateException("Layered mappings have already been evaluated");
        }
        LayeredMappingSpecBuilderImpl builder = new LayeredMappingSpecBuilderImpl(this);
        this.layeredSpecBuilderScope.set(true);
        action.execute((Object)builder);
        this.layeredSpecBuilderScope.set(false);
        LayeredMappingSpec builtSpec = builder.build();
        LayeredMappingsFactory layeredMappingsFactory = this.layeredMappingsDependencyMap.computeIfAbsent(builtSpec, LayeredMappingsFactory::new);
        return layeredMappingsFactory.createDependency(this.getProject());
    }

    @Override
    public void runs(Action<NamedDomainObjectContainer<RunConfigSettings>> action) {
        action.execute(this.runConfigs);
    }

    @Override
    public NamedDomainObjectContainer<RunConfigSettings> getRunConfigs() {
        return this.runConfigs;
    }

    @Override
    public ConfigurableFileCollection getLog4jConfigs() {
        return this.log4jConfigs;
    }

    @Override
    public void mixin(Action<MixinExtensionAPI> action) {
        action.execute((Object)this.getMixin());
    }

    @Override
    public ManifestLocations getVersionsManifests() {
        return this.versionsManifests;
    }

    @Override
    public Property<String> getCustomMinecraftMetadata() {
        return this.customMetadata;
    }

    @Override
    public SetProperty<String> getKnownIndyBsms() {
        if (this.notObfuscated()) {
            throw new UnsupportedOperationException("Cannot configure known indyBsms in a non-obfuscated environment");
        }
        return this.knownIndyBsms;
    }

    @Override
    public String getModVersion() {
        List<FabricModJson> fabricModJsons = FabricModJsonHelpers.getModsInProject(this.getProject());
        if (fabricModJsons.isEmpty()) {
            throw new RuntimeException("Could not find a fabric.mod.json file in the main sourceset");
        }
        return fabricModJsons.getFirst().getModVersion();
    }

    @Override
    public Property<Boolean> getEnableTransitiveAccessWideners() {
        return this.transitiveAccessWideners;
    }

    @Override
    public Property<Boolean> getEnableModProvidedJavadoc() {
        return this.modProvidedJavadoc;
    }

    protected abstract Project getProject();

    protected abstract LoomFiles getFiles();

    @Override
    public Property<String> getIntermediaryUrl() {
        return this.intermediary;
    }

    @Override
    public IntermediateMappingsProvider getIntermediateMappingsProvider() {
        if (LoomGradleExtension.get(this.getProject()).disableObfuscation()) {
            throw new UnsupportedOperationException("Cannot get intermediate mappings provider in a non-obfuscated environment");
        }
        return (IntermediateMappingsProvider)this.intermediateMappingsProvider.get();
    }

    @Override
    public void setIntermediateMappingsProvider(IntermediateMappingsProvider intermediateMappingsProvider) {
        this.intermediateMappingsProvider.set((Object)intermediateMappingsProvider);
    }

    @Override
    public <T extends IntermediateMappingsProvider> void setIntermediateMappingsProvider(Class<T> clazz, Action<T> action) {
        IntermediateMappingsProvider provider = (IntermediateMappingsProvider)this.getProject().getObjects().newInstance(clazz, new Object[0]);
        this.configureIntermediateMappingsProviderInternal(provider);
        action.execute((Object)provider);
        this.setIntermediateMappingsProvider(provider);
    }

    @Override
    public File getMappingsFile() {
        if (this.notObfuscated()) {
            throw new UnsupportedOperationException("Cannot get mappings file in a non-obfuscated environment");
        }
        return LoomGradleExtension.get((Project)this.getProject()).getMappingConfiguration().tinyMappings.toFile();
    }

    @Override
    public GenerateSourcesTask getDecompileTask(DecompilerOptions options, boolean client) {
        String decompilerName = options.getFormattedName();
        Object taskName = this.areEnvironmentSourceSetsSplit() ? "gen%sSourcesWith%s".formatted(client ? "ClientOnly" : "Common", decompilerName) : "genSourcesWith" + decompilerName;
        return (GenerateSourcesTask)this.getProject().getTasks().getByName((String)taskName);
    }

    protected abstract <T extends IntermediateMappingsProvider> void configureIntermediateMappingsProviderInternal(T var1);

    @Override
    public void disableDeprecatedPomGeneration(org.gradle.api.publish.maven.MavenPublication publication) {
        MavenPublication.excludePublication((Publication)publication);
    }

    @Override
    public Property<MinecraftJarConfiguration<?, ?, ?>> getMinecraftJarConfiguration() {
        return this.minecraftJarConfiguration;
    }

    @Override
    public Property<Boolean> getRuntimeOnlyLog4j() {
        return this.runtimeOnlyLog4j;
    }

    @Override
    public Property<Boolean> getSplitModDependencies() {
        return this.splitModDependencies;
    }

    @Override
    public void splitEnvironmentSourceSets() {
        this.splitMinecraftJar();
        this.splitEnvironmentalSourceSet.set((Object)true);
        this.splitEnvironmentalSourceSet.finalizeValue();
        this.minecraftJarConfiguration.finalizeValue();
        MinecraftSourceSets.get(this.getProject()).evaluateSplit(this.getProject());
    }

    @Override
    public boolean areEnvironmentSourceSetsSplit() {
        return (Boolean)this.splitEnvironmentalSourceSet.get();
    }

    @Override
    public InterfaceInjectionExtensionAPI getInterfaceInjection() {
        return this.interfaceInjectionExtension;
    }

    @Override
    public void mods(Action<NamedDomainObjectContainer<ModSettings>> action) {
        action.execute(this.getMods());
    }

    @Override
    public NamedDomainObjectContainer<ModSettings> getMods() {
        return this.mods;
    }

    @Override
    public NamedDomainObjectList<RemapConfigurationSettings> getRemapConfigurations() {
        if (this.notObfuscated()) {
            throw new UnsupportedOperationException("Cannot get remap configurations in a non-obfuscated environment");
        }
        return this.remapConfigurations;
    }

    @Override
    public RemapConfigurationSettings addRemapConfiguration(String name, Action<RemapConfigurationSettings> action) {
        if (this.notObfuscated()) {
            throw new UnsupportedOperationException("Cannot add remap configuration in a non-obfuscated environment");
        }
        RemapConfigurationSettings configurationSettings = (RemapConfigurationSettings)this.getProject().getObjects().newInstance(RemapConfigurationSettings.class, new Object[]{name});
        configurationSettings.getSourceSet().convention((Object)SourceSetHelper.getMainSourceSet(this.getProject()));
        action.execute((Object)configurationSettings);
        RemapConfigurations.applyToProject(this.getProject(), configurationSettings);
        this.remapConfigurations.add((Object)configurationSettings);
        return configurationSettings;
    }

    @Override
    public void createRemapConfigurations(SourceSet sourceSet) {
        if (this.notObfuscated()) {
            throw new UnsupportedOperationException("Cannot create remap configurations in a non-obfuscated environment");
        }
        RemapConfigurations.setupForSourceSet(this.getProject(), sourceSet);
    }

    @Override
    public <T extends RemapperParameters> void addRemapperExtension(Class<? extends RemapperExtension<T>> remapperExtensionClass, Class<T> parametersClass, Action<T> parameterAction) {
        RemapperExtensionHolder holder;
        if (this.notObfuscated()) {
            throw new UnsupportedOperationException("Cannot add remapper extension in a non-obfuscated environment");
        }
        ObjectFactory objectFactory = this.getProject().getObjects();
        if (parametersClass != RemapperParameters.None.class) {
            RemapperParameters parameters = (RemapperParameters)objectFactory.newInstance(parametersClass, new Object[0]);
            parameterAction.execute((Object)parameters);
            holder = (RemapperExtensionHolder)objectFactory.newInstance(RemapperExtensionHolder.class, new Object[]{parameters});
        } else {
            holder = (RemapperExtensionHolder)objectFactory.newInstance(RemapperExtensionHolder.class, new Object[]{RemapperParameters.None.INSTANCE});
        }
        holder.getRemapperExtensionClass().set((Object)remapperExtensionClass.getName());
        this.remapperExtensions.add((Object)holder);
    }

    @Override
    public Provider<String> getMinecraftVersion() {
        return this.getProject().provider(() -> LoomGradleExtension.get(this.getProject()).getMinecraftProvider().minecraftVersion());
    }

    @Override
    public FileCollection getNamedMinecraftJars() {
        ConfigurableFileCollection jars = this.getProject().getObjects().fileCollection();
        jars.from(new Object[]{this.getProject().provider(() -> LoomGradleExtension.get(this.getProject()).getMinecraftJars(MappingsNamespace.NAMED))});
        return jars;
    }

    private boolean notObfuscated() {
        return LoomGradleExtension.get(this.getProject()).disableObfuscation();
    }

    @Override
    public void silentMojangMappingsLicense() {
        try {
            this.silentMojangMappingsLicense.set((Object)true);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("loom.silentMojangMappingsLicense() must be called before its value is read, usually with loom.layered {}.", e);
        }
    }

    @Override
    public boolean isSilentMojangMappingsLicenseEnabled() {
        return (Boolean)this.silentMojangMappingsLicense.get();
    }

    @Override
    public Provider<ModPlatform> getPlatform() {
        return this.platform;
    }

    @Override
    public void setGenerateSrgTiny(Boolean generateSrgTiny) {
        if (this.isNeoForge()) {
            throw new UnsupportedOperationException("SRG is not supported on NeoForge.");
        }
        this.generateSrgTiny = generateSrgTiny;
    }

    @Override
    public boolean shouldGenerateSrgTiny() {
        if (this.generateSrgTiny != null) {
            return this.generateSrgTiny;
        }
        return this.isForge();
    }

    @Override
    public List<String> getTasksBeforeRun() {
        return this.tasksBeforeRun;
    }

    @Override
    public List<Consumer<RunConfig>> getSettingsPostEdit() {
        return this.settingsPostEdit;
    }

    @Override
    public void forge(Action<ForgeExtensionAPI> action) {
        action.execute((Object)this.getForge());
    }

    @Override
    public void neoForge(Action<NeoForgeExtensionAPI> action) {
        action.execute((Object)this.getNeoForge());
    }

    private final class EnsureCompile
    extends LoomGradleExtensionApiImpl {
        private EnsureCompile(LoomGradleExtensionApiImpl loomGradleExtensionApiImpl) {
            super(null, null);
            throw new RuntimeException();
        }

        @Override
        public DeprecationHelper getDeprecationHelper() {
            throw new RuntimeException("Yeah... something is really wrong");
        }

        @Override
        protected Project getProject() {
            throw new RuntimeException("Yeah... something is really wrong");
        }

        @Override
        protected LoomFiles getFiles() {
            throw new RuntimeException("Yeah... something is really wrong");
        }

        @Override
        protected <T extends IntermediateMappingsProvider> void configureIntermediateMappingsProviderInternal(T provider) {
            throw new RuntimeException("Yeah... something is really wrong");
        }

        @Override
        public MixinExtension getMixin() {
            throw new RuntimeException("Yeah... something is really wrong");
        }

        @Override
        public ForgeExtensionAPI getForge() {
            throw new RuntimeException("Yeah... something is really wrong");
        }

        @Override
        public NeoForgeExtensionAPI getNeoForge() {
            throw new RuntimeException("Yeah... something is really wrong");
        }
    }
}

