/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.tiny;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.jar.Manifest;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.format.MappingFormat;

public record TinyJarInfo(boolean v2, Optional<String> minecraftVersionId) {
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final String MANIFEST_VERSION_ID_ATTRIBUTE = "Minecraft-Version-Id";

    public static TinyJarInfo get(Path jar) {
        TinyJarInfo tinyJarInfo;
        block8: {
            FileSystemUtil.Delegate delegate = FileSystemUtil.getJarFileSystem(jar);
            try {
                tinyJarInfo = new TinyJarInfo(TinyJarInfo.doesJarContainV2Mappings(delegate), TinyJarInfo.getMinecraftVersionId(delegate));
                if (delegate == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (delegate != null) {
                        try {
                            delegate.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to read tiny jar info", e);
                }
            }
            delegate.close();
        }
        return tinyJarInfo;
    }

    private static boolean doesJarContainV2Mappings(FileSystemUtil.Delegate fs) throws IOException {
        boolean bl;
        block8: {
            BufferedReader reader = Files.newBufferedReader(fs.getPath("mappings", "mappings.tiny"));
            try {
                boolean bl2 = bl = MappingReader.detectFormat((Reader)reader) == MappingFormat.TINY_2_FILE;
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    return false;
                }
            }
            reader.close();
        }
        return bl;
    }

    private static Optional<String> getMinecraftVersionId(FileSystemUtil.Delegate fs) throws IOException {
        Path manifestPath = fs.getPath(MANIFEST_PATH, new String[0]);
        if (Files.exists(manifestPath, new LinkOption[0])) {
            Manifest manifest = new Manifest();
            try (InputStream in = Files.newInputStream(manifestPath, new OpenOption[0]);){
                manifest.read(in);
            }
            String minecraftVersionId = manifest.getMainAttributes().getValue(MANIFEST_VERSION_ID_ATTRIBUTE);
            return Optional.ofNullable(minecraftVersionId);
        }
        return Optional.empty();
    }
}

