/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.fabricapi;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.fabricapi.GameTestSettings;
import net.fabricmc.loom.configuration.fabricapi.FabricApiAbstractSourceSet;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.task.AbstractLoomTask;
import net.fabricmc.loom.task.LoomTasks;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public abstract class FabricApiTesting
extends FabricApiAbstractSourceSet {
    @Override
    @Inject
    protected abstract Project getProject();

    @Inject
    public FabricApiTesting() {
    }

    @Override
    protected String getSourceSetName() {
        return "gametest";
    }

    void configureTests(Action<GameTestSettings> action) {
        LoomGradleExtension extension = LoomGradleExtension.get(this.getProject());
        TaskContainer tasks = this.getProject().getTasks();
        GameTestSettings settings = (GameTestSettings)this.getProject().getObjects().newInstance(GameTestSettings.class, new Object[0]);
        settings.getCreateSourceSet().convention((Object)false);
        settings.getEnableGameTests().convention((Object)true);
        settings.getEnableClientGameTests().convention((Object)true);
        settings.getEula().convention((Object)false);
        settings.getClearRunDirectory().convention((Object)true);
        settings.getUsername().convention((Object)"Player0");
        action.execute((Object)settings);
        SourceSet testSourceSet = (Boolean)settings.getCreateSourceSet().get() != false ? this.configureSourceSet(settings.getModId(), true) : SourceSetHelper.getMainSourceSet(this.getProject());
        Consumer<RunConfigSettings> configureBase = run -> {
            if (((Boolean)settings.getCreateSourceSet().get()).booleanValue()) {
                run.source(this.getSourceSetName());
            }
        };
        if (((Boolean)settings.getEnableGameTests().get()).booleanValue()) {
            RunConfigSettings gameTest = (RunConfigSettings)extension.getRunConfigs().create("gameTest", run -> {
                run.inherit((RunConfigSettings)extension.getRunConfigs().getByName("server"));
                run.property("fabric-api.gametest");
                run.runDir("build/run/gameTest");
                configureBase.accept((RunConfigSettings)run);
            });
            tasks.named("test", task -> task.dependsOn(new Object[]{LoomTasks.getRunConfigTaskName(gameTest)}));
        }
        if (((Boolean)settings.getEnableClientGameTests().get()).booleanValue()) {
            File resourcesDir = testSourceSet.getResources().getSrcDirs().stream().findFirst().orElse(null);
            RunConfigSettings clientGameTest = (RunConfigSettings)extension.getRunConfigs().create("clientGameTest", run -> {
                run.inherit((RunConfigSettings)extension.getRunConfigs().getByName("client"));
                run.property("fabric.client.gametest");
                if (resourcesDir != null) {
                    run.property("fabric.client.gametest.testModResourcesPath", resourcesDir.getAbsolutePath());
                }
                run.runDir("build/run/clientGameTest");
                if (settings.getUsername().isPresent()) {
                    run.programArgs("--username", (String)settings.getUsername().get());
                }
                configureBase.accept((RunConfigSettings)run);
            });
            if (((Boolean)settings.getClearRunDirectory().get()).booleanValue()) {
                TaskProvider deleteGameTestRunDir = tasks.register("deleteGameTestRunDir", Delete.class, task -> {
                    task.setGroup("loom");
                    task.delete(new Object[]{clientGameTest.getRunDir()});
                });
                tasks.named(LoomTasks.getRunConfigTaskName(clientGameTest), task -> task.dependsOn(new Object[]{deleteGameTestRunDir}));
            }
            if (((Boolean)settings.getEula().get()).booleanValue()) {
                TaskProvider acceptEula = tasks.register("acceptGameTestEula", AcceptEulaTask.class, task -> {
                    task.getEulaFile().set(this.getProject().file((Object)(clientGameTest.getRunDir() + "/eula.txt")));
                    if (((Boolean)settings.getClearRunDirectory().get()).booleanValue()) {
                        task.dependsOn(new Object[]{tasks.named("deleteGameTestRunDir")});
                    }
                });
                tasks.named("configureLaunch", task -> task.dependsOn(new Object[]{acceptEula}));
            }
        }
    }

    public static abstract class AcceptEulaTask
    extends AbstractLoomTask {
        @OutputFile
        public abstract RegularFileProperty getEulaFile();

        @TaskAction
        public void acceptEula() throws IOException {
            Path eula = ((RegularFile)this.getEulaFile().get()).getAsFile().toPath();
            if (Files.notExists(eula, new LinkOption[0])) {
                Files.writeString(eula, (CharSequence)"#This file was generated by the Fabric Loom Gradle plugin. As the user opted into accepting the EULA.\neula=true\n", new OpenOption[0]);
            }
        }
    }
}

