/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration;

import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.mods.ModConfigurationRemapper;
import net.fabricmc.loom.util.SourceRemapper;
import net.fabricmc.loom.util.service.ServiceFactory;
import org.gradle.api.Project;

public record LoomDependencyManager(Project project, ServiceFactory serviceFactory, LoomGradleExtension extension) {
    public void handleDependencies() {
        if (this.extension.disableObfuscation()) {
            this.handleNonRemapDependencies();
        } else {
            this.handleRemapDependencies();
        }
    }

    private void handleRemapDependencies() {
        LoomGradleExtension extension = LoomGradleExtension.get(this.project);
        SourceRemapper sourceRemapper = new SourceRemapper(this.project, this.serviceFactory, true);
        String platformSuffix = extension.isForgeLike() ? "_forge" : (extension.isQuilt() ? "_arch_quilt" : "");
        String mappingsIdentifier = extension.getMappingConfiguration().mappingsIdentifier() + platformSuffix;
        ModConfigurationRemapper.supplyModConfigurations(this.project, this.serviceFactory, mappingsIdentifier, extension, sourceRemapper);
        sourceRemapper.remapAll();
        if (extension.getInstallerData() == null && !extension.isForgeLike()) {
            if (extension.isQuilt()) {
                this.project.getLogger().info("quilt_installer.json not found in dependencies!");
            } else {
                this.project.getLogger().info("fabric-installer.json not found in dependencies!");
            }
        }
    }

    private void handleNonRemapDependencies() {
    }
}

