/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.neoforge;

import dev.architectury.at.AccessTransformSet;
import dev.architectury.at.io.AccessTransformFormats;
import dev.architectury.loom.metadata.ModMetadataFile;
import dev.architectury.loom.metadata.ModMetadataFiles;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Set;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.ModPlatform;
import net.fabricmc.mappingio.tree.MappingTreeView;

public final class NeoForgeModDependencies {
    public static void remapAts(Path jar, MappingTreeView mappings, String from, String to) throws IOException {
        Set<String> modsTomlAts;
        ModMetadataFile modMetadata = ModMetadataFiles.fromJar(jar);
        Set<String> atPaths = Set.of("META-INF/accesstransformer.cfg");
        if (modMetadata != null && !(modsTomlAts = modMetadata.getAccessTransformers(ModPlatform.NEOFORGE)).isEmpty()) {
            atPaths = modsTomlAts;
        }
        try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(jar);){
            for (String atPathStr : atPaths) {
                Path atPath = fs.getPath(atPathStr, new String[0]);
                if (!Files.exists(atPath, new LinkOption[0])) continue;
                AccessTransformSet ats = AccessTransformFormats.FML.read(atPath);
                ats = ats.remap(mappings, from, to);
                AccessTransformFormats.FML.write(atPath, ats);
            }
        }
    }
}

