/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.loom.metadata.ArchitecturyCommonJson;
import dev.architectury.loom.metadata.JsonBackedModMetadataFile;
import dev.architectury.loom.metadata.SingleIdModMetadataFile;
import dev.architectury.loom.util.collection.CollectionUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.configuration.ifaceinject.InterfaceInjectionProcessor;
import net.fabricmc.loom.util.ModPlatform;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QuiltModJson
implements JsonBackedModMetadataFile,
SingleIdModMetadataFile {
    public static final String FILE_NAME = "quilt.mod.json";
    public static final String JSON5_FILE_NAME = "quilt.mod.json5";
    private static final Logger LOGGER = LoggerFactory.getLogger(QuiltModJson.class);
    private static final String ACCESS_WIDENER_KEY = "access_widener";
    private static final String MIXIN_KEY = "mixin";
    private final JsonObject json;

    private QuiltModJson(JsonObject json) {
        this.json = Objects.requireNonNull(json, "json");
    }

    public static QuiltModJson of(byte[] utf8) {
        return QuiltModJson.of(new String(utf8, StandardCharsets.UTF_8));
    }

    public static QuiltModJson of(String text) {
        return QuiltModJson.of((JsonObject)LoomGradlePlugin.GSON.fromJson(text, JsonObject.class));
    }

    public static QuiltModJson of(Path path) throws IOException {
        return QuiltModJson.of(Files.readString(path, StandardCharsets.UTF_8));
    }

    public static QuiltModJson of(File file) throws IOException {
        return QuiltModJson.of(file.toPath());
    }

    public static QuiltModJson of(JsonObject json) {
        return new QuiltModJson(json);
    }

    @Override
    public JsonObject getJson() {
        return this.json;
    }

    @Override
    @Nullable
    public String getId() {
        JsonObject quiltLoader = this.json.getAsJsonObject("quilt_loader");
        if (quiltLoader != null && quiltLoader.has("id")) {
            return quiltLoader.get("id").getAsString();
        }
        return null;
    }

    @Override
    public Set<String> getAccessWideners() {
        if (this.json.has(ACCESS_WIDENER_KEY)) {
            if (this.json.get(ACCESS_WIDENER_KEY).isJsonArray()) {
                JsonArray array = this.json.get(ACCESS_WIDENER_KEY).getAsJsonArray();
                return CollectionUtil.mapTo(array, new LinkedHashSet(), JsonElement::getAsString);
            }
            return Set.of(this.json.get(ACCESS_WIDENER_KEY).getAsString());
        }
        return Set.of();
    }

    @Override
    public Set<String> getAccessTransformers(ModPlatform platform) {
        return Set.of();
    }

    @Override
    public List<InterfaceInjectionProcessor.InjectedInterface> getInjectedInterfaces(@Nullable String modId) {
        try {
            modId = Objects.requireNonNullElse(this.getId(), modId);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Could not determine mod ID for Quilt mod and no fallback provided", e);
        }
        if (this.json.has("quilt_loom")) {
            JsonElement quiltLoom = this.json.get("quilt_loom");
            if (quiltLoom.isJsonObject()) {
                return ArchitecturyCommonJson.getInjectedInterfaces(this.json.getAsJsonObject("quilt_loom"), modId);
            }
            LOGGER.warn("Unexpected type for 'quilt_loom' in quilt.mod.json: {}", quiltLoom.getClass());
        }
        return List.of();
    }

    @Override
    public List<String> getMixinConfigs() {
        if (this.json.has(MIXIN_KEY)) {
            JsonElement mixin = this.json.get(MIXIN_KEY);
            if (mixin.isJsonPrimitive()) {
                return List.of(mixin.getAsString());
            }
            if (mixin.isJsonArray()) {
                ArrayList<String> mixinConfigs = new ArrayList<String>();
                for (JsonElement child : mixin.getAsJsonArray()) {
                    mixinConfigs.add(child.getAsString());
                }
                return mixinConfigs;
            }
            LOGGER.warn("'mixin' key in quilt.mod.json is of unexpected type {}", mixin.getClass());
        }
        return List.of();
    }

    @Override
    public String getFileName() {
        return FILE_NAME;
    }

    @Override
    @Nullable
    public JsonElement getCustomValue(String key) {
        return this.json.get(key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof QuiltModJson)) return false;
        QuiltModJson qmj = (QuiltModJson)obj;
        if (!qmj.json.equals((Object)this.json)) return false;
        return true;
    }

    public int hashCode() {
        return this.json.hashCode();
    }
}

