/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.mcpconfig.steplogic;

import dev.architectury.loom.mcpconfig.steplogic.StepLogic;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;

public final class ListLibrariesLogic
extends StepLogic<Options> {
    public static final ServiceType<Options, ListLibrariesLogic> TYPE = new ServiceType<Options, ListLibrariesLogic>(Options.class, ListLibrariesLogic.class);

    public static Provider<Options> createOptions(StepLogic.SetupContext context) {
        return TYPE.create(context.project(), (Action<Options>)((Action)options -> options.getMinecraftLibraries().from(new Object[]{context.getMinecraftLibraries()})));
    }

    public ListLibrariesLogic(Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    @Override
    public void execute(StepLogic.ExecutionContext context) throws IOException {
        try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(context.setOutput("libraries.txt"), new OpenOption[0]));){
            for (File lib : ((Options)this.getOptions()).getMinecraftLibraries()) {
                writer.println("-e=" + lib.getAbsolutePath());
            }
        }
    }

    public static interface Options
    extends Service.Options {
        @InputFiles
        public ConfigurableFileCollection getMinecraftLibraries();
    }
}

