/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.mcpconfig;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.loom.mcpconfig.McpConfigFunction;
import dev.architectury.loom.mcpconfig.McpConfigStep;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public record McpConfigData(String version, JsonObject data, String mappingsPath, boolean official, Map<String, List<McpConfigStep>> steps, Map<String, McpConfigFunction> functions) {
    public static McpConfigData fromJson(JsonObject json) {
        String version = json.get("version").getAsString();
        JsonObject data = json.getAsJsonObject("data");
        String mappingsPath = data.get("mappings").getAsString();
        boolean official = json.has("official") && json.getAsJsonPrimitive("official").getAsBoolean();
        JsonObject stepsJson = json.getAsJsonObject("steps");
        HashMap steps = new HashMap();
        for (String key : stepsJson.keySet()) {
            ArrayList<McpConfigStep> stepList = new ArrayList<McpConfigStep>();
            for (JsonElement child : stepsJson.getAsJsonArray(key)) {
                stepList.add(McpConfigStep.fromJson(child.getAsJsonObject()));
            }
            steps.put(key, List.copyOf(stepList));
        }
        JsonObject functionsJson = json.getAsJsonObject("functions");
        HashMap<String, McpConfigFunction> functions = new HashMap<String, McpConfigFunction>();
        for (String key : functionsJson.keySet()) {
            functions.put(key, McpConfigFunction.fromJson(functionsJson.getAsJsonObject(key)));
        }
        return new McpConfigData(version, data, mappingsPath, official, Map.copyOf(steps), Map.copyOf(functions));
    }
}

