/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.mcpconfig;

import dev.architectury.loom.forge.config.ConfigValue;
import dev.architectury.loom.mcpconfig.McpConfigStep;
import dev.architectury.loom.util.collection.CollectionUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class DependencySet {
    private final Map<String, McpConfigStep> allSteps;
    private final List<String> stepNames;
    private final List<Predicate<McpConfigStep>> skipRules = new ArrayList<Predicate<McpConfigStep>>();
    private final Set<String> steps = new HashSet<String>();
    private Predicate<McpConfigStep> ignoreDependenciesFilter = data -> false;

    public DependencySet(List<McpConfigStep> allSteps) {
        this.allSteps = allSteps.stream().collect(Collectors.toMap(McpConfigStep::name, Function.identity()));
        this.stepNames = CollectionUtil.map(allSteps, McpConfigStep::name);
    }

    public void clear() {
        this.steps.clear();
    }

    public void add(String step) {
        if (!this.allSteps.containsKey(step)) {
            return;
        }
        this.steps.add(step);
    }

    public void skip(String step) {
        this.skip((McpConfigStep data) -> data.name().equals(step));
    }

    public void skip(Predicate<McpConfigStep> rule) {
        this.skipRules.add(rule);
    }

    public void setIgnoreDependenciesFilter(Predicate<McpConfigStep> ignoreDependenciesFilter) {
        this.ignoreDependenciesFilter = ignoreDependenciesFilter;
    }

    public SortedSet<String> buildExecutionSet() {
        TreeSet<String> steps = new TreeSet<String>(Comparator.comparingInt(this.stepNames::indexOf));
        ArrayDeque<String> queue = new ArrayDeque<String>(this.steps);
        while (!queue.isEmpty()) {
            String step = (String)queue.remove();
            McpConfigStep data = this.allSteps.get(step);
            if (!this.allSteps.containsKey(step) || this.skipRules.stream().anyMatch(rule -> rule.test(data))) continue;
            steps.add(step);
            if (this.ignoreDependenciesFilter.test(this.allSteps.get(step))) continue;
            this.allSteps.get(step).config().values().forEach(value -> {
                ConfigValue.Variable var;
                String name;
                if (value instanceof ConfigValue.Variable && (name = (var = (ConfigValue.Variable)value).name()).endsWith("Output") && name.length() > "Output".length()) {
                    String substep = name.substring(0, name.length() - "Output".length());
                    queue.offer(substep);
                }
            });
        }
        return steps;
    }
}

