/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.forge.minecraft;

import dev.architectury.loom.forge.minecraft.ForgeMinecraftProvider;
import dev.architectury.loom.forge.minecraft.MinecraftPatchedProvider;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.ConfigContext;
import net.fabricmc.loom.configuration.providers.BundleMetadata;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftMetadataProvider;
import net.fabricmc.loom.configuration.providers.minecraft.SingleJarEnvType;
import net.fabricmc.loom.configuration.providers.minecraft.SingleJarMinecraftProvider;

public abstract class SingleJarForgeMinecraftProvider
extends SingleJarMinecraftProvider
implements ForgeMinecraftProvider {
    private final MinecraftPatchedProvider patchedProvider;

    private SingleJarForgeMinecraftProvider(MinecraftMetadataProvider metadataProvider, ConfigContext configContext) {
        super(metadataProvider, configContext, MappingsNamespace.OFFICIAL);
        this.patchedProvider = new MinecraftPatchedProvider(configContext.project(), this, this.provideServer() ? MinecraftPatchedProvider.Type.SERVER_ONLY : MinecraftPatchedProvider.Type.CLIENT_ONLY);
    }

    public static Server forgeServer(MinecraftMetadataProvider metadataProvider, ConfigContext configContext) {
        return new Server(metadataProvider, configContext);
    }

    public static Client forgeClient(MinecraftMetadataProvider metadataProvider, ConfigContext configContext) {
        return new Client(metadataProvider, configContext);
    }

    @Override
    protected boolean provideClient() {
        return true;
    }

    @Override
    protected void processJar() throws Exception {
    }

    @Override
    public MinecraftPatchedProvider getPatchedProvider() {
        return this.patchedProvider;
    }

    @Override
    public Path getMinecraftEnvOnlyJar() {
        return this.patchedProvider.getMinecraftPatchedJar();
    }

    @Override
    public List<Path> getMinecraftJars() {
        return List.of(this.patchedProvider.getMinecraftPatchedJar());
    }

    public static final class Server
    extends SingleJarForgeMinecraftProvider {
        private Server(MinecraftMetadataProvider metadataProvider, ConfigContext configContext) {
            super(metadataProvider, configContext);
        }

        @Override
        public SingleJarEnvType type() {
            return SingleJarEnvType.SERVER;
        }

        @Override
        public Path getInputJar(SingleJarMinecraftProvider provider) throws Exception {
            BundleMetadata serverBundleMetadata = provider.getServerBundleMetadata();
            if (serverBundleMetadata == null) {
                return provider.getMinecraftServerJar().toPath();
            }
            provider.extractBundledServerJar();
            return provider.getMinecraftExtractedServerJar().toPath();
        }

        @Override
        protected boolean provideServer() {
            return true;
        }

        @Override
        protected boolean provideClient() {
            return false;
        }
    }

    public static final class Client
    extends SingleJarForgeMinecraftProvider {
        private Client(MinecraftMetadataProvider metadataProvider, ConfigContext configContext) {
            super(metadataProvider, configContext);
        }

        @Override
        public SingleJarEnvType type() {
            return SingleJarEnvType.CLIENT;
        }

        @Override
        public Path getInputJar(SingleJarMinecraftProvider provider) throws Exception {
            return provider.getMinecraftClientJar().toPath();
        }

        @Override
        protected boolean provideServer() {
            return false;
        }

        @Override
        protected boolean provideClient() {
            return true;
        }
    }
}

