/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.forge.dependency;

import dev.architectury.loom.forge.dependency.DependencyProvider;
import dev.architectury.loom.forge.tool.ForgeToolExecutor;
import dev.architectury.loom.forge.tool.ForgeToolValueSource;
import dev.architectury.loom.util.DependencyDownloader;
import dev.architectury.loom.util.Stopwatch;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingContext;
import net.fabricmc.loom.configuration.DependencyInfo;
import net.fabricmc.loom.configuration.providers.mappings.GradleMappingContext;
import net.fabricmc.loom.configuration.providers.mappings.mojmap.MojangMappingLayer;
import net.fabricmc.loom.configuration.providers.mappings.mojmap.MojangMappingsSpec;
import net.fabricmc.loom.util.LoomVersions;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.MappingWriter;
import net.fabricmc.mappingio.adapter.ForwardingMappingVisitor;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.jetbrains.annotations.Nullable;

public class SrgProvider
extends DependencyProvider {
    private static final String INSTALLER_TOOLS_MAIN_CLASS = "net.minecraftforge.installertools.ConsoleTool";
    private Path srg;
    private Boolean isTsrgV2;
    private Path mergedMojangRaw;
    private Path mergedMojangTrimmed;
    private static Map<String, Path> mojmapTsrg2Map = new HashMap<String, Path>();

    public SrgProvider(Project project) {
        super(project);
    }

    @Override
    public void provide(DependencyInfo dependency) throws Exception {
        this.init(dependency.getDependency().getVersion());
        if (!Files.exists(this.srg, new LinkOption[0]) || this.refreshDeps()) {
            Path srgZip = dependency.resolveFile().orElseThrow(() -> new RuntimeException("Could not resolve srg")).toPath();
            Files.write(this.srg, ZipUtils.unpack(srgZip, "config/joined.tsrg"), new OpenOption[0]);
        }
        try (BufferedReader reader = Files.newBufferedReader(this.srg);){
            this.isTsrgV2 = reader.readLine().startsWith("tsrg2");
        }
        if (this.isTsrgV2.booleanValue() && (!Files.exists(this.mergedMojangRaw, new LinkOption[0]) || !Files.exists(this.mergedMojangTrimmed, new LinkOption[0]) || this.refreshDeps())) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.getProject().getLogger().lifecycle(":merging mappings (InstallerTools, srg + mojmap)");
            Files.deleteIfExists(this.mergedMojangRaw);
            Path mojmapTsrg2 = SrgProvider.getMojmapTsrg2(this.getProject(), this.getExtension());
            ForgeToolValueSource.exec(this.getProject(), (Action<? super ForgeToolExecutor.Settings>)((Action)settings -> {
                settings.classpath(DependencyDownloader.download(this.getProject(), LoomVersions.FORGE_INSTALLER_TOOLS.mavenNotation()));
                settings.getMainClass().set((Object)INSTALLER_TOOLS_MAIN_CLASS);
                settings.args("--task", "MERGE_MAPPING", "--left", this.getSrg().toAbsolutePath().toString(), "--right", mojmapTsrg2.toAbsolutePath().toString(), "--classes", "--output", this.mergedMojangRaw.toAbsolutePath().toString());
            }));
            MemoryMappingTree tree = new MemoryMappingTree();
            ArgDroppingVisitor visitor = new ArgDroppingVisitor((MappingVisitor)new FieldDescWrappingVisitor(this, (MappingVisitor)tree));
            MappingReader.read((Path)this.mergedMojangRaw, (MappingVisitor)visitor);
            try (MappingWriter writer = MappingWriter.create((Path)this.mergedMojangTrimmed, (MappingFormat)MappingFormat.TSRG_2_FILE);){
                tree.accept((MappingVisitor)writer);
            }
            this.getProject().getLogger().lifecycle(":merged mappings (InstallerTools, srg + mojmap) in " + String.valueOf(stopwatch.stop()));
        }
    }

    private void init(String version) {
        File dir = this.getMinecraftProvider().dir("srg/" + version);
        this.srg = new File(dir, "srg.tsrg").toPath();
        this.mergedMojangRaw = new File(dir, "srg-mojmap-merged-raw.tsrg").toPath();
        this.mergedMojangTrimmed = new File(dir, "srg-mojmap-merged-trimmed.tsrg").toPath();
    }

    public Path getSrg() {
        return this.srg;
    }

    public Path getMergedMojangRaw() {
        if (!this.isTsrgV2()) {
            throw new IllegalStateException("May not access merged mojmap srg if not on modern Minecraft!");
        }
        return this.mergedMojangRaw;
    }

    public Path getMergedMojangTrimmed() {
        if (!this.isTsrgV2()) {
            throw new IllegalStateException("May not access merged mojmap srg if not on modern Minecraft!");
        }
        return this.mergedMojangTrimmed;
    }

    public boolean isTsrgV2() {
        return this.isTsrgV2;
    }

    public static Path getMojmapTsrg2(Project project, LoomGradleExtension extension) throws IOException {
        String minecraftVersion = extension.getMinecraftProvider().minecraftVersion();
        if (mojmapTsrg2Map.containsKey(minecraftVersion)) {
            return mojmapTsrg2Map.get(minecraftVersion);
        }
        Path mojmapTsrg2 = extension.getMinecraftProvider().dir("forge").toPath().resolve("mojmap.tsrg2");
        if (Files.notExists(mojmapTsrg2, new LinkOption[0]) || extension.refreshDeps()) {
            try (MappingWriter writer = MappingWriter.create((Path)mojmapTsrg2, (MappingFormat)MappingFormat.TSRG_2_FILE);){
                GradleMappingContext context = new GradleMappingContext(project, "tmp-mojmap");
                MemoryMappingTree tree = new MemoryMappingTree();
                SrgProvider.visitMojangMappings((MappingVisitor)tree, context);
                tree.accept((MappingVisitor)writer);
            }
        }
        mojmapTsrg2Map.put(minecraftVersion, mojmapTsrg2);
        return mojmapTsrg2;
    }

    public static void visitMojangMappings(MappingVisitor visitor, MappingContext context) {
        try {
            MojangMappingLayer layer = new MojangMappingsSpec(() -> true, true).createLayer(context);
            layer.visit(visitor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String getTargetConfig() {
        return "srg";
    }

    private static final class ArgDroppingVisitor
    extends ForwardingMappingVisitor {
        ArgDroppingVisitor(MappingVisitor next) {
            super(next);
        }

        public boolean visitMethodArg(int argPosition, int lvIndex, @Nullable String srcName) throws IOException {
            return false;
        }
    }

    private class FieldDescWrappingVisitor
    extends ForwardingMappingVisitor {
        private final Map<FieldKey, String> fieldDescMap = new HashMap<FieldKey, String>();
        private String lastClass;

        protected FieldDescWrappingVisitor(SrgProvider srgProvider, MappingVisitor next) throws IOException {
            super(next);
            MemoryMappingTree mojmap = new MemoryMappingTree();
            MappingReader.read((Path)SrgProvider.getMojmapTsrg2(srgProvider.getProject(), srgProvider.getExtension()), (MappingVisitor)mojmap);
            for (MappingTree.ClassMapping classMapping : mojmap.getClasses()) {
                for (MappingTree.FieldMapping fieldMapping : classMapping.getFields()) {
                    this.fieldDescMap.put(new FieldKey(classMapping.getSrcName(), fieldMapping.getSrcName()), fieldMapping.getSrcDesc());
                }
            }
        }

        public boolean visitClass(String srcName) throws IOException {
            if (super.visitClass(srcName)) {
                this.lastClass = srcName;
                return true;
            }
            return false;
        }

        public boolean visitField(String srcName, String srcDesc) throws IOException {
            if (srcDesc == null) {
                srcDesc = this.fieldDescMap.get(new FieldKey(this.lastClass, srcName));
            }
            return super.visitField(srcName, srcDesc);
        }

        private record FieldKey(String owner, String name) {
        }
    }
}

