/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.forge.dependency;

import dev.architectury.loom.forge.dependency.DependencyProvider;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import net.fabricmc.loom.configuration.DependencyInfo;
import org.gradle.api.Project;

public class ForgeUniversalProvider
extends DependencyProvider {
    private File forge;

    public ForgeUniversalProvider(Project project) {
        super(project);
    }

    @Override
    public void provide(DependencyInfo dependency) throws Exception {
        this.forge = new File(this.getExtension().getForgeProvider().getGlobalCache(), "forge-universal.jar");
        if (!this.forge.exists() || this.refreshDeps()) {
            File dep = dependency.resolveFile().orElseThrow(() -> new RuntimeException("Could not resolve Forge"));
            Files.copy(dep.toPath(), this.forge.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public File getForge() {
        return this.forge;
    }

    @Override
    public String getTargetConfig() {
        return "forgeUniversal";
    }
}

