/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.forge.dependency;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.loom.forge.config.ConfigValue;
import dev.architectury.loom.forge.config.ForgeRunTemplate;
import dev.architectury.loom.forge.config.UserdevConfig;
import dev.architectury.loom.forge.dependency.ForgeUserdevProvider;
import dev.architectury.loom.util.DependencyDownloader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.fabricmc.loom.LoomGradleExtension;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Project;

public class ForgeRunsProvider
implements ConfigValue.Resolver {
    private final Project project;
    private final LoomGradleExtension extension;
    private final JsonObject json;
    private final NamedDomainObjectSet<ForgeRunTemplate> templates;

    public ForgeRunsProvider(Project project, JsonObject json, UserdevConfig userdevConfig) {
        this.project = project;
        this.extension = LoomGradleExtension.get(project);
        this.json = json;
        this.templates = project.getObjects().namedDomainObjectSet(ForgeRunTemplate.class);
        this.templates.addAll(userdevConfig.runs().values());
    }

    public NamedDomainObjectSet<ForgeRunTemplate> getTemplates() {
        return this.templates;
    }

    public static ForgeRunsProvider create(Project project) {
        ForgeUserdevProvider userdevProvider = LoomGradleExtension.get(project).getForgeUserdevProvider();
        return new ForgeRunsProvider(project, userdevProvider.getJson(), userdevProvider.getConfig());
    }

    @Override
    public String resolve(ConfigValue.Variable variable) {
        String key = variable.name();
        Object string = "{" + key + "}";
        if (key.equals("runtime_classpath")) {
            string = this.runtimeClasspath().stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
        } else if (key.equals("minecraft_classpath")) {
            string = this.minecraftClasspath().stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
        } else if (key.equals("runtime_classpath_file")) {
            Path path = this.extension.getFiles().getProjectPersistentCache().toPath().resolve("forge_runtime_classpath.txt");
            try {
                Files.writeString(path, (CharSequence)this.runtimeClasspath().stream().map(File::getAbsolutePath).collect(Collectors.joining("\n")), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            string = path.toAbsolutePath().toString();
        } else if (key.equals("minecraft_classpath_file")) {
            Path path = this.extension.getFiles().getProjectPersistentCache().toPath().resolve("forge_minecraft_classpath.txt");
            try {
                Files.writeString(path, (CharSequence)this.minecraftClasspath().stream().map(File::getAbsolutePath).collect(Collectors.joining("\n")), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            string = path.toAbsolutePath().toString();
        } else if (key.equals("asset_index")) {
            string = this.extension.getMinecraftProvider().getVersionInfo().assetIndex().fabricId(this.extension.getMinecraftProvider().minecraftVersion());
        } else if (key.equals("assets_root")) {
            string = new File(this.extension.getFiles().getUserCache(), "assets").getAbsolutePath();
        } else if (key.equals("natives")) {
            string = this.extension.getFiles().getNativesDirectory(this.project).getAbsolutePath();
        } else if (!key.equals("source_roots")) {
            if (key.equals("mcp_mappings")) {
                string = "loom.stub";
            } else if (key.equals("modules")) {
                string = StreamSupport.stream(this.json.getAsJsonArray("modules").spliterator(), false).map(JsonElement::getAsString).flatMap(str -> {
                    if (str.contains(":")) {
                        return DependencyDownloader.download(this.project, str, false, false).getFiles().stream().map(File::getAbsolutePath).filter(dep -> !dep.contains("bootstraplauncher"));
                    }
                    return Stream.of(str);
                }).collect(Collectors.joining(File.pathSeparator));
            } else if (this.json.has(key)) {
                JsonElement element = this.json.get(key);
                string = element.toString();
            } else {
                this.project.getLogger().warn("Unrecognized template! " + (String)string);
            }
        }
        return string;
    }

    private Set<File> runtimeClasspath() {
        return this.minecraftClasspath();
    }

    private Set<File> minecraftClasspath() {
        return DependencyDownloader.resolveFiles(this.project, this.project.getConfigurations().getByName("forgeRuntimeLibrary"), true);
    }
}

