/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.extensions;

import dev.architectury.at.AccessTransformSet;
import dev.architectury.at.io.AccessTransformFormats;
import dev.architectury.loom.accesstransformer.Aw2At;
import dev.architectury.loom.util.LfWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.fabricmc.loom.task.service.MappingsService;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.mappingio.tree.MappingTreeView;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.Nullable;

public final class ModBuildExtensions {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<String> readMixinConfigsFromManifest(File jarFile) {
        try (JarFile jar = new JarFile(jarFile);){
            Attributes attributes;
            String mixinConfigs;
            @Nullable Manifest manifest = jar.getManifest();
            if (manifest != null && (mixinConfigs = (attributes = manifest.getMainAttributes()).getValue("MixinConfigs")) != null) {
                Set<String> set = Set.of(mixinConfigs.split(","));
                return set;
            }
            Set<String> set = Set.of();
            return set;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not read mixin configs from jar " + jarFile.getAbsolutePath(), e);
        }
    }

    public static void convertAwToAt(ServiceFactory serviceFactory, Set<String> atAccessWideners, Path outputFile, Provider<MappingsService.Options> options) throws IOException {
        if (atAccessWideners.isEmpty()) {
            return;
        }
        AccessTransformSet at = AccessTransformSet.create();
        try (FileSystemUtil.Delegate fileSystem = FileSystemUtil.getJarFileSystem(outputFile, false);){
            FileSystem fs = fileSystem.get();
            Path atPath = fs.getPath("META-INF/accesstransformer.cfg", new String[0]);
            if (Files.exists(atPath, new LinkOption[0])) {
                throw new FileAlreadyExistsException("Jar " + String.valueOf(outputFile) + " already contains an access transformer - cannot convert AWs!");
            }
            for (String aw : atAccessWideners) {
                Path awPath = fs.getPath(aw, new String[0]);
                if (Files.notExists(awPath, new LinkOption[0])) {
                    throw new NoSuchFileException("Could not find AW '" + aw + "' to convert into AT!");
                }
                try (BufferedReader reader = Files.newBufferedReader(awPath, StandardCharsets.UTF_8);){
                    at.merge(Aw2At.toAccessTransformSet(reader));
                }
                Files.delete(awPath);
            }
            MappingsService service = (MappingsService)serviceFactory.get(options);
            at = at.remap((MappingTreeView)service.getMemoryMappingTree(), service.getFrom(), service.getTo());
            try (LfWriter writer = new LfWriter(Files.newBufferedWriter(atPath, new OpenOption[0]));){
                AccessTransformFormats.FML.write((Writer)writer, at);
            }
        }
    }
}

