/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.accesstransformer;

import dev.architectury.loom.forge.config.UserdevConfig;
import dev.architectury.loom.forge.tool.ForgeToolExecutor;
import dev.architectury.loom.forge.tool.ForgeToolService;
import dev.architectury.loom.util.DependencyDownloader;
import dev.architectury.loom.util.TempFiles;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftVersionMeta;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.LoomVersions;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;

public final class AccessTransformerService
extends Service<Options> {
    public static final ServiceType<Options, AccessTransformerService> TYPE = new ServiceType<Options, AccessTransformerService>(Options.class, AccessTransformerService.class);

    public static Provider<Options> createOptions(Project project, Object atFiles) {
        return TYPE.create(project, (Action<Options>)((Action)options -> {
            LoomVersions accessTransformer = AccessTransformerService.chooseAccessTransformer(project);
            String mainClass = accessTransformer.equals(LoomVersions.ACCESS_TRANSFORMERS_NEO) ? "net.neoforged.accesstransformer.cli.TransformerProcessor" : "net.minecraftforge.accesstransformer.TransformerProcessor";
            FileCollection classpath = new DependencyDownloader(project).add(accessTransformer.mavenNotation()).add(LoomVersions.ASM.mavenNotation()).platform(LoomVersions.ACCESS_TRANSFORMERS_LOG4J_BOM.mavenNotation()).download();
            options.getMainClass().set((Object)mainClass);
            options.getAccessTransformers().from(new Object[]{atFiles});
            options.getClasspath().from(new Object[]{classpath});
            options.getToolServiceOptions().set(ForgeToolService.createOptions(project));
        }));
    }

    public static Provider<Options> createOptionsForLoaderAts(Project project, TempFiles tempFiles) {
        Provider atFiles = project.provider(() -> {
            LoomGradleExtension extension = LoomGradleExtension.get(project);
            Path userdevJar = extension.getForgeUserdevProvider().getUserdevJar().toPath();
            return AccessTransformerService.extractAccessTransformers(userdevJar, extension.getForgeUserdevProvider().getConfig().ats(), tempFiles);
        });
        return AccessTransformerService.createOptions(project, atFiles);
    }

    private static List<String> extractAccessTransformers(Path jar, UserdevConfig.AccessTransformerLocation location, TempFiles tempFiles) throws IOException {
        ArrayList<String> extracted = new ArrayList<String>();
        try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(jar);){
            for (Path atFile : AccessTransformerService.getAccessTransformerPaths(fs, location)) {
                byte[] atBytes;
                try {
                    atBytes = Files.readAllBytes(atFile);
                }
                catch (NoSuchFileException e) {
                    continue;
                }
                Path tmpFile = tempFiles.file("at-conf", ".cfg");
                Files.write(tmpFile, atBytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                extracted.add(tmpFile.toAbsolutePath().toString());
            }
        }
        return extracted;
    }

    private static List<Path> getAccessTransformerPaths(FileSystemUtil.Delegate fs, UserdevConfig.AccessTransformerLocation location) throws IOException {
        return location.visitIo(directory -> {
            Path dirPath = fs.getPath((String)directory, new String[0]);
            try (Stream<Path> paths = Files.list(dirPath);){
                List<Path> list = paths.toList();
                return list;
            }
        }, paths -> paths.stream().map(x$0 -> fs.getPath((String)x$0, new String[0])).toList());
    }

    public AccessTransformerService(Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    private static LoomVersions chooseAccessTransformer(Project project) {
        MinecraftVersionMeta.JavaVersion javaVersion;
        boolean serverBundleMetadataPresent;
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        boolean bl = serverBundleMetadataPresent = extension.getMinecraftProvider().getServerBundleMetadata() != null;
        if (!serverBundleMetadataPresent) {
            return LoomVersions.ACCESS_TRANSFORMERS;
        }
        if (extension.isNeoForge() && (javaVersion = extension.getMinecraftProvider().getVersionInfo().javaVersion()) != null && javaVersion.majorVersion() >= 21) {
            return LoomVersions.ACCESS_TRANSFORMERS_NEO;
        }
        return LoomVersions.ACCESS_TRANSFORMERS_NEW;
    }

    public void execute(Path input, Path output) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--inJar");
        args.add(input.toAbsolutePath().toString());
        args.add("--outJar");
        args.add(output.toAbsolutePath().toString());
        for (File atFile : ((Options)this.getOptions()).getAccessTransformers().getFiles()) {
            args.add("--atFile");
            args.add(atFile.getAbsolutePath());
        }
        ForgeToolService toolService = (ForgeToolService)this.getServiceFactory().get(((Options)this.getOptions()).getToolServiceOptions());
        toolService.exec((Action<? super ForgeToolExecutor.Settings>)((Action)spec -> {
            spec.getMainClass().set(((Options)this.getOptions()).getMainClass());
            spec.setArgs(args);
            spec.setClasspath(((Options)this.getOptions()).getClasspath());
        }));
    }

    public static interface Options
    extends Service.Options {
        @InputFiles
        public ConfigurableFileCollection getAccessTransformers();

        @Input
        public Property<String> getMainClass();

        @Classpath
        public ConfigurableFileCollection getClasspath();

        @Nested
        public Property<ForgeToolService.Options> getToolServiceOptions();
    }
}

