/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiConsumer;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.ConfigContext;
import net.fabricmc.loom.configuration.providers.BundleMetadata;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftMetadataProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.SingleJarEnvType;
import net.fabricmc.loom.util.TinyRemapperLoggerAdapter;
import net.fabricmc.tinyremapper.NonClassCopyMode;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.api.TrLogger;

public abstract class SingleJarMinecraftProvider
extends MinecraftProvider {
    private final MappingsNamespace officialNamespace;
    private Path minecraftEnvOnlyJar;

    protected SingleJarMinecraftProvider(MinecraftMetadataProvider metadataProvider, ConfigContext configContext, MappingsNamespace officialNamespace) {
        super(metadataProvider, configContext);
        this.officialNamespace = officialNamespace;
    }

    public static Server server(MinecraftMetadataProvider metadataProvider, ConfigContext configContext) {
        return new Server(metadataProvider, configContext, SingleJarMinecraftProvider.getOfficialNamespace(metadataProvider, true));
    }

    public static Client client(MinecraftMetadataProvider metadataProvider, ConfigContext configContext) {
        return new Client(metadataProvider, configContext, SingleJarMinecraftProvider.getOfficialNamespace(metadataProvider, false));
    }

    private static MappingsNamespace getOfficialNamespace(MinecraftMetadataProvider metadataProvider, boolean server) {
        if (metadataProvider.getVersionMeta().isLegacySplitOfficialNamespaceVersion()) {
            return server ? MappingsNamespace.SERVER_OFFICIAL : MappingsNamespace.CLIENT_OFFICIAL;
        }
        return MappingsNamespace.OFFICIAL;
    }

    @Override
    protected void initFiles() {
        super.initFiles();
        this.minecraftEnvOnlyJar = this.path("minecraft-%s-only.jar".formatted(new Object[]{this.type()}));
    }

    @Override
    public List<Path> getMinecraftJars() {
        return List.of(this.minecraftEnvOnlyJar);
    }

    @Override
    public void provide() throws Exception {
        super.provide();
        if (this.provideClient() && !this.isLegacyVersion()) {
            this.getProject().getLogger().warn("Using `clientOnlyMinecraftJar()` is not recommended for Minecraft versions 1.3 or newer.");
        }
        this.processJar();
    }

    protected void processJar() throws Exception {
        boolean requiresRefresh;
        boolean bl = requiresRefresh = this.getExtension().refreshDeps() || Files.notExists(this.minecraftEnvOnlyJar, new LinkOption[0]);
        if (!requiresRefresh) {
            return;
        }
        Path inputJar = this.getInputJar(this);
        TinyRemapper remapper = null;
        try {
            remapper = TinyRemapper.newRemapper((TrLogger)TinyRemapperLoggerAdapter.INSTANCE).build();
            Files.deleteIfExists(this.minecraftEnvOnlyJar);
            try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(this.minecraftEnvOnlyJar).build();){
                outputConsumer.addNonClassFiles(inputJar, NonClassCopyMode.FIX_META_INF, remapper);
                remapper.readInputs(new Path[]{inputJar});
                remapper.apply((BiConsumer)outputConsumer);
            }
        }
        catch (Exception e) {
            Files.deleteIfExists(this.minecraftEnvOnlyJar);
            throw new RuntimeException("Failed to process %s only jar".formatted(new Object[]{this.type()}), e);
        }
        finally {
            if (remapper != null) {
                remapper.finish();
            }
        }
    }

    public Path getMinecraftEnvOnlyJar() {
        return this.minecraftEnvOnlyJar;
    }

    @Override
    public MappingsNamespace getOfficialNamespace() {
        return this.officialNamespace;
    }

    protected abstract SingleJarEnvType type();

    protected abstract Path getInputJar(SingleJarMinecraftProvider var1) throws Exception;

    public static final class Server
    extends SingleJarMinecraftProvider {
        private Server(MinecraftMetadataProvider metadataProvider, ConfigContext configContext, MappingsNamespace officialNamespace) {
            super(metadataProvider, configContext, officialNamespace);
        }

        @Override
        public SingleJarEnvType type() {
            return SingleJarEnvType.SERVER;
        }

        @Override
        public Path getInputJar(SingleJarMinecraftProvider provider) {
            BundleMetadata serverBundleMetadata = provider.getServerBundleMetadata();
            if (serverBundleMetadata == null) {
                return provider.getMinecraftServerJar().toPath();
            }
            return provider.getMinecraftExtractedServerJar().toPath();
        }

        @Override
        protected boolean provideServer() {
            return true;
        }

        @Override
        protected boolean provideClient() {
            return false;
        }
    }

    public static final class Client
    extends SingleJarMinecraftProvider {
        private Client(MinecraftMetadataProvider metadataProvider, ConfigContext configContext, MappingsNamespace officialNamespace) {
            super(metadataProvider, configContext, officialNamespace);
        }

        @Override
        public SingleJarEnvType type() {
            return SingleJarEnvType.CLIENT;
        }

        @Override
        public Path getInputJar(SingleJarMinecraftProvider provider) throws Exception {
            return provider.getMinecraftClientJar().toPath();
        }

        @Override
        protected boolean provideServer() {
            return false;
        }

        @Override
        protected boolean provideClient() {
            return true;
        }
    }
}

