/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import dev.architectury.loom.forge.ForgeSourcesService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.fabricmc.loom.api.decompilers.DecompilationMetadata;
import net.fabricmc.loom.api.decompilers.DecompilerOptions;
import net.fabricmc.loom.api.decompilers.LoomDecompiler;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJar;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.AbstractMappedMinecraftProvider;
import net.fabricmc.loom.decompilers.ClassLineNumbers;
import net.fabricmc.loom.decompilers.LineNumberRemapper;
import net.fabricmc.loom.decompilers.cache.CachedData;
import net.fabricmc.loom.decompilers.cache.CachedFileStoreImpl;
import net.fabricmc.loom.decompilers.cache.CachedJarProcessor;
import net.fabricmc.loom.task.AbstractLoomTask;
import net.fabricmc.loom.task.AbstractRemapJarTask;
import net.fabricmc.loom.task.service.SourceMappingsService;
import net.fabricmc.loom.task.service.UnpickService;
import net.fabricmc.loom.util.Checksum;
import net.fabricmc.loom.util.ExceptionUtil;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.IOStringConsumer;
import net.fabricmc.loom.util.ModPlatform;
import net.fabricmc.loom.util.Platform;
import net.fabricmc.loom.util.gradle.GradleUtils;
import net.fabricmc.loom.util.gradle.SyncTaskBuildService;
import net.fabricmc.loom.util.gradle.ThreadedProgressLoggerConsumer;
import net.fabricmc.loom.util.gradle.ThreadedSimpleProgressLogger;
import net.fabricmc.loom.util.gradle.WorkerDaemonClientsManagerHelper;
import net.fabricmc.loom.util.gradle.daemon.DaemonUtils;
import net.fabricmc.loom.util.ipc.IPCClient;
import net.fabricmc.loom.util.ipc.IPCServer;
import net.fabricmc.loom.util.service.ScopedServiceFactory;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.process.ExecOperations;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.gradle.workers.internal.WorkerDaemonClientsManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@UntrackedTask(because="Manually invoked, has internal caching")
public abstract class GenerateSourcesTask
extends AbstractLoomTask {
    private static final String CACHE_VERSION = "v1";
    private final DecompilerOptions decompilerOptions;

    @Input
    public abstract Property<String> getInputJarName();

    @InputFiles
    protected abstract ConfigurableFileCollection getClassesInputJar();

    @InputFiles
    protected abstract ConfigurableFileCollection getClasspath();

    @InputFiles
    protected abstract ConfigurableFileCollection getMinecraftCompileLibraries();

    @OutputFile
    public abstract RegularFileProperty getSourcesOutputJar();

    @OutputFile
    protected abstract ConfigurableFileCollection getClassesOutputJar();

    @Input
    @Option(option="use-cache", description="Use the decompile cache")
    @ApiStatus.Experimental
    public abstract Property<Boolean> getUseCache();

    @Input
    @Option(option="reset-cache", description="When set the cache will be reset")
    @ApiStatus.Experimental
    public abstract Property<Boolean> getResetCache();

    @Nested
    @ApiStatus.Internal
    protected abstract Property<SourceMappingsService.Options> getMappings();

    @Internal
    @ApiStatus.Internal
    protected abstract RegularFileProperty getDecompileCacheFile();

    @Input
    @ApiStatus.Internal
    protected abstract Property<Integer> getMaxCachedFiles();

    @Input
    @ApiStatus.Internal
    protected abstract Property<Integer> getMaxCacheFileAge();

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @Inject
    protected abstract ExecOperations getExecOperations();

    @Inject
    protected abstract WorkerDaemonClientsManager getWorkerDaemonClientsManager();

    @Inject
    protected abstract ProgressLoggerFactory getProgressLoggerFactory();

    @Nested
    protected abstract Property<DaemonUtils.Context> getDaemonUtilsContext();

    @Nested
    @Optional
    protected abstract Property<UnpickService.Options> getUnpickOptions();

    @Nested
    @Optional
    protected abstract Property<ForgeSourcesService.Options> getForgeSourcesOptions();

    @ServiceReference(value="loomSyncTask")
    abstract Property<SyncTaskBuildService> getSyncTask();

    @Inject
    public GenerateSourcesTask(DecompilerOptions decompilerOptions) {
        this.decompilerOptions = decompilerOptions;
        this.getClassesInputJar().setFrom(new Object[]{this.getInputJarName().map(minecraftJarName -> {
            List<MinecraftJar> minecraftJars = this.getExtension().getNamedMinecraftProvider().getMinecraftJars();
            for (MinecraftJar minecraftJar : minecraftJars) {
                if (!minecraftJar.getName().equals(minecraftJarName)) continue;
                Path backupJarPath = AbstractMappedMinecraftProvider.getBackupJarPath(minecraftJar);
                if (Files.notExists(backupJarPath, new LinkOption[0])) {
                    throw new IllegalStateException("Input minecraft jar not found at: " + String.valueOf(backupJarPath));
                }
                return backupJarPath.toFile();
            }
            throw new IllegalStateException("Input minecraft jar not found: " + (String)this.getInputJarName().get());
        })});
        this.getClassesOutputJar().setFrom(new Object[]{this.getInputJarName().map(minecraftJarName -> {
            List<MinecraftJar> minecraftJars = this.getExtension().getNamedMinecraftProvider().getMinecraftJars();
            for (MinecraftJar minecraftJar : minecraftJars) {
                if (!minecraftJar.getName().equals(minecraftJarName)) continue;
                return minecraftJar.toFile();
            }
            throw new IllegalStateException("Input minecraft jar not found: " + (String)this.getInputJarName().get());
        })});
        this.getClasspath().from(new Object[]{decompilerOptions.getClasspath()}).finalizeValueOnRead();
        this.dependsOn(new Object[]{decompilerOptions.getClasspath().getBuiltBy()});
        this.getMinecraftCompileLibraries().from(new Object[]{this.getProject().getConfigurations().getByName("minecraftLibraries")});
        this.getDecompileCacheFile().set(this.getExtension().getFiles().getDecompileCache(CACHE_VERSION));
        this.getUseCache().convention((Object)true);
        this.getResetCache().convention((Object)this.getExtension().refreshDeps());
        this.getMappings().set(SourceMappingsService.create(this.getProject()));
        this.getMaxCachedFiles().set(GradleUtils.getIntegerPropertyProvider(this.getProject(), "fabric.loom.decompileCacheMaxFiles").orElse((Object)50000));
        this.getMaxCacheFileAge().set(GradleUtils.getIntegerPropertyProvider(this.getProject(), "fabric.loom.decompileCacheMaxAge").orElse((Object)90));
        this.getDaemonUtilsContext().set((Object)((DaemonUtils.Context)this.getProject().getObjects().newInstance(DaemonUtils.Context.class, new Object[]{this.getProject()})));
        this.getUnpickOptions().set(UnpickService.createOptions(this));
        this.getForgeSourcesOptions().set(ForgeSourcesService.createOptions(this.getProject()));
        this.mustRunAfter(new Object[]{this.getProject().getTasks().withType(AbstractRemapJarTask.class)});
    }

    @TaskAction
    public void run() throws IOException {
        Platform platform = Platform.CURRENT;
        if (!platform.getArchitecture().is64Bit()) {
            throw new UnsupportedOperationException("GenSources task requires a 64bit JVM to run due to the memory requirements.");
        }
        try (ScopedServiceFactory serviceFactory = new ScopedServiceFactory();){
            if (!((Boolean)this.getUseCache().get()).booleanValue()) {
                this.getLogger().info("Not using decompile cache.");
                try (Timer timer = new Timer("Decompiled sources");){
                    this.runWithoutCache(serviceFactory);
                }
                catch (Exception e) {
                    ExceptionUtil.processException(e, (DaemonUtils.Context)this.getDaemonUtilsContext().get());
                    throw ExceptionUtil.createDescriptiveWrapper(RuntimeException::new, "Failed to decompile", e);
                }
                return;
            }
            this.getLogger().info("Using decompile cache.");
            try (Timer timer = new Timer("Decompiled sources with cache");){
                FileSystemUtil.Delegate fs;
                Path cacheFile = ((File)this.getDecompileCacheFile().getAsFile().get()).toPath();
                if (((Boolean)this.getResetCache().get()).booleanValue()) {
                    this.getLogger().warn("Resetting decompile cache");
                    Files.deleteIfExists(cacheFile);
                }
                Files.createDirectories(cacheFile.getParent(), new FileAttribute[0]);
                if (Files.exists(cacheFile, new LinkOption[0])) {
                    try {
                        fs = FileSystemUtil.getJarFileSystem(cacheFile, true);
                        if (fs != null) {
                            fs.close();
                        }
                    }
                    catch (IOException e) {
                        this.getLogger().warn("Discarding invalid decompile cache file: {}", (Object)cacheFile, (Object)e);
                        Files.delete(cacheFile);
                    }
                }
                fs = FileSystemUtil.getJarFileSystem(cacheFile, true);
                try {
                    this.runWithCache(serviceFactory, fs.getRoot());
                }
                finally {
                    if (fs != null) {
                        fs.close();
                    }
                }
            }
            catch (Exception e) {
                ExceptionUtil.processException(e, (DaemonUtils.Context)this.getDaemonUtilsContext().get());
                throw ExceptionUtil.createDescriptiveWrapper(RuntimeException::new, "Failed to decompile", e);
            }
        }
    }

    private void runWithCache(ServiceFactory serviceFactory, Path cacheRoot) throws IOException {
        CachedJarProcessor.WorkRequest workRequest;
        Path classesInputJar = this.getClassesInputJar().getSingleFile().toPath();
        Path sourcesOutputJar = ((RegularFile)this.getSourcesOutputJar().get()).getAsFile().toPath();
        Path classesOutputJar = this.getClassesOutputJar().getSingleFile().toPath();
        CachedFileStoreImpl.CacheRules cacheRules = new CachedFileStoreImpl.CacheRules(((Integer)this.getMaxCachedFiles().get()).intValue(), Duration.ofDays(((Integer)this.getMaxCacheFileAge().get()).intValue()));
        CachedFileStoreImpl<CachedData> decompileCache = new CachedFileStoreImpl<CachedData>(cacheRoot, CachedData.SERIALIZER, cacheRules);
        String cacheKey = this.getCacheKey(serviceFactory);
        CachedJarProcessor cachedJarProcessor = new CachedJarProcessor(decompileCache, cacheKey);
        this.getLogger().info("Decompile cache key: {}", (Object)cacheKey);
        this.getLogger().debug("Decompile cache rules: {}", (Object)cacheRules);
        try (Timer timer = new Timer("Prepare job");){
            workRequest = cachedJarProcessor.prepareJob(classesInputJar);
        }
        CachedJarProcessor.WorkJob job = workRequest.job();
        CachedJarProcessor.CacheStats cacheStats = workRequest.stats();
        this.getLogger().lifecycle("Decompile cache stats: {} hits, {} misses", new Object[]{cacheStats.hits(), cacheStats.misses()});
        ClassLineNumbers outputLineNumbers = null;
        if (job instanceof CachedJarProcessor.WorkToDoJob) {
            Timer timer;
            Path existingClasses;
            CachedJarProcessor.WorkToDoJob workToDoJob = (CachedJarProcessor.WorkToDoJob)job;
            Path workInputJar = workToDoJob.incomplete();
            if (job instanceof CachedJarProcessor.PartialWorkJob) {
                CachedJarProcessor.PartialWorkJob partialWorkJob = (CachedJarProcessor.PartialWorkJob)job;
                v0 = partialWorkJob.existingClasses();
            } else {
                v0 = existingClasses = null;
            }
            if (this.usingUnpick()) {
                timer = new Timer("Unpick");
                try {
                    UnpickService unpick = (UnpickService)serviceFactory.get(this.getUnpickOptions());
                    workInputJar = unpick.unpickJar(workInputJar, existingClasses);
                }
                finally {
                    timer.close();
                }
            }
            timer = new Timer("Decompile");
            try {
                outputLineNumbers = this.runDecompileJob(workInputJar, workToDoJob.output(), existingClasses);
                this.removeForgeInnerClassSources(workToDoJob.output());
                outputLineNumbers = this.filterForgeLineNumbers(outputLineNumbers);
            }
            finally {
                timer.close();
            }
            if (Files.notExists(workToDoJob.output(), new LinkOption[0])) {
                throw new RuntimeException("Failed to decompile sources");
            }
        } else if (job instanceof CachedJarProcessor.CompletedWorkJob) {
            CachedJarProcessor.CompletedWorkJob completedWorkJob = (CachedJarProcessor.CompletedWorkJob)job;
        }
        Files.deleteIfExists(sourcesOutputJar);
        try (Timer timer = new Timer("Complete job");){
            cachedJarProcessor.completeJob(sourcesOutputJar, job, outputLineNumbers);
        }
        this.getLogger().info("Decompiled sources written to {}", (Object)sourcesOutputJar);
        ClassLineNumbers existingLinenumbers = workRequest.lineNumbers();
        ClassLineNumbers lineNumbers = ClassLineNumbers.merge(existingLinenumbers, outputLineNumbers);
        this.applyLineNumbers(lineNumbers, classesInputJar, classesOutputJar);
        try (Timer timer = new Timer("Prune cache");){
            decompileCache.prune();
        }
    }

    private void runWithoutCache(ServiceFactory serviceFactory) throws IOException {
        ClassLineNumbers lineNumbers;
        Path classesInputJar = this.getClassesInputJar().getSingleFile().toPath();
        Path sourcesOutputJar = ((RegularFile)this.getSourcesOutputJar().get()).getAsFile().toPath();
        Path classesOutputJar = this.getClassesOutputJar().getSingleFile().toPath();
        Path workClassesJar = classesInputJar;
        if (this.usingUnpick()) {
            try (Timer timer = new Timer("Unpick");){
                UnpickService unpick = (UnpickService)serviceFactory.get(this.getUnpickOptions());
                workClassesJar = unpick.unpickJar(workClassesJar, null);
            }
        }
        try (Timer timer = new Timer("Decompile");){
            lineNumbers = this.runDecompileJob(workClassesJar, sourcesOutputJar, null);
            this.removeForgeInnerClassSources(sourcesOutputJar);
            lineNumbers = this.filterForgeLineNumbers(lineNumbers);
        }
        if (Files.notExists(sourcesOutputJar, new LinkOption[0])) {
            throw new RuntimeException("Failed to decompile sources");
        }
        this.getLogger().info("Decompiled sources written to {}", (Object)sourcesOutputJar);
        this.applyLineNumbers(lineNumbers, classesInputJar, classesOutputJar);
    }

    private void applyLineNumbers(@Nullable ClassLineNumbers lineNumbers, Path classesInputJar, Path classesOutputJar) throws IOException {
        if (lineNumbers == null) {
            this.getLogger().info("No line numbers to remap, skipping remapping");
            return;
        }
        Path tempJar = Files.createTempFile("loom", "linenumber-remap.jar", new FileAttribute[0]);
        Files.delete(tempJar);
        try (Timer timer = new Timer("Remap line numbers");){
            this.remapLineNumbers(lineNumbers, classesInputJar, tempJar);
        }
        Files.move(tempJar, classesOutputJar, StandardCopyOption.REPLACE_EXISTING);
    }

    private String getCacheKey(ServiceFactory serviceFactory) {
        SourceMappingsService mappingsService;
        String mappingsHash;
        StringJoiner sj = new StringJoiner(",");
        sj.add(this.getDecompilerCheckKey());
        if (this.usingUnpick()) {
            UnpickService unpick = (UnpickService)serviceFactory.get(this.getUnpickOptions());
            sj.add(unpick.getUnpickCacheKey());
        }
        if ((mappingsHash = (mappingsService = (SourceMappingsService)serviceFactory.get(this.getMappings())).getProcessorHash()) != null) {
            sj.add(mappingsHash);
        }
        this.getLogger().info("Decompile cache data: {}", (Object)sj);
        return Checksum.of(sj.toString()).sha256().hex();
    }

    private String getDecompilerCheckKey() {
        StringJoiner sj = new StringJoiner(",");
        sj.add((CharSequence)this.decompilerOptions.getDecompilerClassName().get());
        sj.add(Checksum.of((FileCollection)this.decompilerOptions.getClasspath()).sha256().hex());
        for (Map.Entry entry : ((Map)this.decompilerOptions.getOptions().get()).entrySet()) {
            sj.add((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        return sj.toString();
    }

    @Nullable
    private ClassLineNumbers runDecompileJob(Path inputJar, Path outputJar, @Nullable Path existingJar) throws IOException {
        Platform platform = Platform.CURRENT;
        Path lineMapFile = File.createTempFile("loom", "linemap").toPath();
        Files.delete(lineMapFile);
        if (!platform.supportsUnixDomainSockets()) {
            this.getLogger().warn("Decompile worker logging disabled as Unix Domain Sockets is not supported on your operating system.");
            this.doWork(null, inputJar, outputJar, lineMapFile, existingJar);
            try (ScopedServiceFactory serviceFactory = new ScopedServiceFactory();){
                @Nullable ForgeSourcesService service = (ForgeSourcesService)serviceFactory.getOrNull(this.getForgeSourcesOptions());
                if (service != null) {
                    service.addForgeSources(inputJar, outputJar);
                }
            }
            return GenerateSourcesTask.readLineNumbers(lineMapFile);
        }
        Path ipcPath = Files.createTempFile("loom", "ipc", new FileAttribute[0]);
        Files.deleteIfExists(ipcPath);
        try (ThreadedProgressLoggerConsumer loggerConsumer = new ThreadedProgressLoggerConsumer(this.getLogger(), this.getProgressLoggerFactory(), this.decompilerOptions.getName(), "Decompiling minecraft sources");
             IPCServer logReceiver = new IPCServer(ipcPath, loggerConsumer);){
            this.doWork(logReceiver, inputJar, outputJar, lineMapFile, existingJar);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to shutdown log receiver", e);
        }
        finally {
            Files.deleteIfExists(ipcPath);
        }
        try (ScopedServiceFactory serviceFactory = new ScopedServiceFactory();){
            @Nullable ForgeSourcesService service = (ForgeSourcesService)serviceFactory.getOrNull(this.getForgeSourcesOptions());
            if (service != null) {
                service.addForgeSources(inputJar, outputJar);
            }
        }
        return GenerateSourcesTask.readLineNumbers(lineMapFile);
    }

    @Nullable
    private ClassLineNumbers filterForgeLineNumbers(@Nullable ClassLineNumbers lineNumbers) {
        if (lineNumbers == null) {
            return null;
        }
        if (((ModPlatform)((Object)this.getModPlatform().get())).isForgeLike()) {
            HashMap<String, ClassLineNumbers.Entry> lineMap = new HashMap<String, ClassLineNumbers.Entry>();
            for (Map.Entry<String, ClassLineNumbers.Entry> entry : lineNumbers.lineMap().entrySet()) {
                String name = entry.getKey();
                if (name.startsWith("net/minecraftforge/") || name.startsWith("net/neoforged/")) continue;
                lineMap.put(name, entry.getValue());
            }
            return new ClassLineNumbers(lineMap);
        }
        return lineNumbers;
    }

    private void removeForgeInnerClassSources(Path sourcesJar) throws IOException {
        if (!((ModPlatform)((Object)this.getModPlatform().get())).isForgeLike()) {
            return;
        }
        try (FileSystemUtil.Delegate outputFs = FileSystemUtil.getJarFileSystem(sourcesJar, false);
             Stream<Path> walk = Files.walk(outputFs.getRoot(), new FileVisitOption[0]);){
            Iterator iterator = walk.iterator();
            while (iterator.hasNext()) {
                Path fsPath = (Path)iterator.next();
                if (fsPath.startsWith("/META-INF/") || !Files.isRegularFile(fsPath, new LinkOption[0]) || fsPath.toString().substring(outputFs.getRoot().toString().length()).indexOf(36) == -1) continue;
                Files.delete(fsPath);
            }
        }
    }

    private void remapLineNumbers(ClassLineNumbers lineNumbers, Path inputJar, Path outputJar) throws IOException {
        Objects.requireNonNull(lineNumbers, "lineNumbers");
        LineNumberRemapper remapper = new LineNumberRemapper(lineNumbers);
        remapper.process(inputJar, outputJar);
        Path lineMap = inputJar.resolveSibling(String.valueOf(inputJar.getFileName()) + ".linemap.txt");
        try (BufferedWriter writer = Files.newBufferedWriter(lineMap, new OpenOption[0]);){
            lineNumbers.write(writer);
        }
        this.getLogger().info("Wrote linemap to {}", (Object)lineMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork(@Nullable IPCServer ipcServer, Path inputJar, Path outputJar, Path linemapFile, @Nullable Path existingClasses) {
        String jvmMarkerValue = UUID.randomUUID().toString();
        WorkQueue workQueue = this.createWorkQueue(jvmMarkerValue);
        workQueue.submit(DecompileAction.class, params -> {
            params.getDecompilerOptions().set((Object)this.decompilerOptions.toDto());
            params.getInputJar().set(inputJar.toFile());
            params.getOutputJar().set(outputJar.toFile());
            params.getLinemapFile().set(linemapFile.toFile());
            params.getMappings().set(this.getMappings());
            if (ipcServer != null) {
                params.getIPCPath().set(ipcServer.getPath().toFile());
            }
            params.getClassPath().setFrom((Iterable)this.getMinecraftCompileLibraries());
            if (existingClasses != null) {
                params.getClassPath().from(new Object[]{existingClasses});
            }
            params.getForge().set((Object)((ModPlatform)((Object)((Object)this.getModPlatform().get()))).isForgeLike());
        });
        try {
            workQueue.await();
        }
        finally {
            boolean stopped;
            if (ipcServer != null && !(stopped = WorkerDaemonClientsManagerHelper.stopIdleJVM(this.getWorkerDaemonClientsManager(), jvmMarkerValue)) && ipcServer.hasReceivedMessage()) {
                this.getLogger().info("Failed to stop decompile worker JVM, it may have already been stopped?");
            }
        }
    }

    private WorkQueue createWorkQueue(String jvmMarkerValue) {
        if (!this.useProcessIsolation()) {
            return this.getWorkerExecutor().classLoaderIsolation(spec -> spec.getClasspath().from(new Object[]{this.getClasspath()}));
        }
        return this.getWorkerExecutor().processIsolation(spec -> {
            spec.forkOptions(forkOptions -> {
                forkOptions.setMinHeapSize(String.format(Locale.ENGLISH, "%dm", Math.min(512L, (Long)this.decompilerOptions.getMemory().get())));
                forkOptions.setMaxHeapSize(String.format(Locale.ENGLISH, "%dm", this.decompilerOptions.getMemory().get()));
                forkOptions.systemProperty("fabric.loom.decompile.worker", (Object)jvmMarkerValue);
            });
            spec.getClasspath().from(new Object[]{this.getClasspath()});
        });
    }

    private boolean useProcessIsolation() {
        return !Boolean.getBoolean("fabric.loom.genSources.debug");
    }

    private boolean usingUnpick() {
        return this.getUnpickOptions().isPresent();
    }

    public static File getJarFileWithSuffix(String suffix, Path runtimeJar) {
        String path = runtimeJar.toFile().getAbsolutePath();
        if (!path.toLowerCase(Locale.ROOT).endsWith(".jar")) {
            throw new RuntimeException("Invalid mapped JAR path: " + path);
        }
        return new File(path.substring(0, path.length() - 4) + suffix);
    }

    static File getJarFileWithSuffix(RegularFileProperty runtimeJar, String suffix) {
        return GenerateSourcesTask.getJarFileWithSuffix(suffix, ((RegularFile)runtimeJar.get()).getAsFile().toPath());
    }

    @Nullable
    private static ClassLineNumbers readLineNumbers(Path linemapFile) throws IOException {
        ClassLineNumbers classLineNumbers;
        block9: {
            if (Files.notExists(linemapFile, new LinkOption[0])) {
                return null;
            }
            BufferedReader reader = Files.newBufferedReader(linemapFile, StandardCharsets.UTF_8);
            try {
                classLineNumbers = ClassLineNumbers.readMappings(reader);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException("Failed to read line number map: " + String.valueOf(linemapFile), e);
                }
            }
            reader.close();
        }
        return classLineNumbers;
    }

    private static Constructor<LoomDecompiler> getDecompilerConstructor(String clazz) {
        try {
            return Class.forName(clazz).getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private final class Timer
    implements AutoCloseable {
        private final String name;
        private final long start;

        Timer(String name) {
            this.name = name;
            this.start = System.currentTimeMillis();
        }

        @Override
        public void close() {
            GenerateSourcesTask.this.getLogger().info("{} took {}ms", (Object)this.name, (Object)(System.currentTimeMillis() - this.start));
        }
    }

    public static abstract class DecompileAction
    implements WorkAction<DecompileParams> {
        public void execute() {
            block11: {
                block10: {
                    if (!((DecompileParams)this.getParameters()).getIPCPath().isPresent()) break block10;
                    if (Platform.CURRENT.supportsUnixDomainSockets()) break block11;
                }
                this.doDecompile(System.out::println);
                return;
            }
            Path ipcPath = ((RegularFile)((DecompileParams)this.getParameters()).getIPCPath().get()).getAsFile().toPath();
            try (IPCClient ipcClient = new IPCClient(ipcPath);){
                this.doDecompile(new ThreadedSimpleProgressLogger(ipcClient));
            }
            catch (Exception e) {
                throw ExceptionUtil.createDescriptiveWrapper(RuntimeException::new, "Failed to decompile", e);
            }
        }

        private void doDecompile(IOStringConsumer logger) {
            LoomDecompiler decompiler;
            Path inputJar = ((RegularFile)((DecompileParams)this.getParameters()).getInputJar().get()).getAsFile().toPath();
            Path linemap = ((RegularFile)((DecompileParams)this.getParameters()).getLinemapFile().get()).getAsFile().toPath();
            Path outputJar = ((RegularFile)((DecompileParams)this.getParameters()).getOutputJar().get()).getAsFile().toPath();
            DecompilerOptions.Dto decompilerOptions = (DecompilerOptions.Dto)((DecompileParams)this.getParameters()).getDecompilerOptions().get();
            try {
                String className = decompilerOptions.className();
                Constructor<LoomDecompiler> decompilerConstructor = GenerateSourcesTask.getDecompilerConstructor(className);
                Objects.requireNonNull(decompilerConstructor, "%s must have a no args constructor".formatted(className));
                decompiler = decompilerConstructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException("Failed to create decompiler", e);
            }
            try (ScopedServiceFactory serviceFactory = new ScopedServiceFactory();){
                SourceMappingsService mappingsService = (SourceMappingsService)serviceFactory.get(((DecompileParams)this.getParameters()).getMappings());
                DecompilationMetadata metadata = new DecompilationMetadata(decompilerOptions.maxThreads(), mappingsService.getMappingsFile(), this.getLibraries(), logger, decompilerOptions.options());
                decompiler.decompile(inputJar, outputJar, linemap, metadata);
                try {
                    metadata.logger().accept("LOOM_CLOSE_LOGGERS");
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to close loggers", e);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private Collection<Path> getLibraries() {
            return DecompileAction.toPaths((FileCollection)((DecompileParams)this.getParameters()).getClassPath());
        }

        static Collection<Path> toPaths(FileCollection files) {
            return files.getFiles().stream().map(File::toPath).collect(Collectors.toSet());
        }
    }

    public static interface DecompileParams
    extends WorkParameters {
        public Property<DecompilerOptions.Dto> getDecompilerOptions();

        public RegularFileProperty getInputJar();

        public RegularFileProperty getOutputJar();

        public RegularFileProperty getLinemapFile();

        public Property<SourceMappingsService.Options> getMappings();

        public RegularFileProperty getIPCPath();

        public ConfigurableFileCollection getClassPath();

        public Property<Boolean> getForge();
    }

    public static interface MappingsProcessor {
        public boolean transform(MemoryMappingTree var1);
    }
}

