/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.loom.LoomRepositoryPlugin;
import net.fabricmc.loom.api.LoomGradleExtensionAPI;
import net.fabricmc.loom.api.fabricapi.FabricApiExtension;
import net.fabricmc.loom.configuration.CompileConfiguration;
import net.fabricmc.loom.configuration.LoomConfigurations;
import net.fabricmc.loom.configuration.MavenPublication;
import net.fabricmc.loom.configuration.fabricapi.FabricApiExtensionImpl;
import net.fabricmc.loom.configuration.ide.idea.IdeaConfiguration;
import net.fabricmc.loom.configuration.sandbox.SandboxConfiguration;
import net.fabricmc.loom.decompilers.DecompilerConfiguration;
import net.fabricmc.loom.extension.LoomFiles;
import net.fabricmc.loom.extension.LoomGradleExtensionImpl;
import net.fabricmc.loom.task.LoomTasks;
import net.fabricmc.loom.task.RemapTaskConfiguration;
import net.fabricmc.loom.util.LibraryLocationLogger;
import net.fabricmc.loom.util.OneDrive;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.PluginAware;

public class LoomGradlePlugin
implements Plugin<PluginAware> {
    public static final String NAME = "dev.architectury.loom";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final String LOOM_VERSION = Objects.requireNonNullElse(LoomGradlePlugin.class.getPackage().getImplementationVersion(), "0.0.0+unknown");
    private static final List<Class<? extends Runnable>> SETUP_JOBS = List.of(LoomConfigurations.class, CompileConfiguration.class, MavenPublication.class, RemapTaskConfiguration.class, LoomTasks.class, DecompilerConfiguration.class, IdeaConfiguration.class, SandboxConfiguration.class);

    public void apply(PluginAware target) {
        target.getPlugins().apply(LoomRepositoryPlugin.class);
        if (target instanceof Project) {
            Project project = (Project)target;
            this.apply(project);
        }
    }

    private void apply(Project project) {
        HashSet<String> loggedVersions = new HashSet<String>(Arrays.asList(System.getProperty("loom.printed.logged", "").split(",")));
        if (!loggedVersions.contains(LOOM_VERSION)) {
            loggedVersions.add(LOOM_VERSION);
            System.setProperty("loom.printed.logged", String.join((CharSequence)",", loggedVersions));
            project.getLogger().lifecycle("Architectury Loom: " + LOOM_VERSION);
            project.getLogger().lifecycle("This version of Architectury Loom is in beta! Please report any issues you encounter: https://github.com/architectury/architectury-loom/issues");
        }
        LibraryLocationLogger.logLibraryVersions();
        OneDrive.verify(project);
        project.apply(Map.of("plugin", "java-library"));
        project.apply(Map.of("plugin", "eclipse"));
        project.getExtensions().create(LoomGradleExtensionAPI.class, "loom", LoomGradleExtensionImpl.class, new Object[]{project, LoomFiles.create(project)});
        project.getExtensions().create(FabricApiExtension.class, "fabricApi", FabricApiExtensionImpl.class, new Object[0]);
        for (Class<? extends Runnable> jobClass : SETUP_JOBS) {
            ((Runnable)project.getObjects().newInstance(jobClass, new Object[0])).run();
        }
        project.apply(Map.of("plugin", "dev.architectury.loom-companion"));
    }
}

