/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.forge.tool;

import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;

public abstract class JavaExecutableFetcher {
    @Inject
    protected abstract JavaToolchainService getToolchainService();

    public static Provider<String> getJavaToolchainExecutable(Project project) {
        return project.provider(() -> {
            JavaExecutableFetcher fetcher = (JavaExecutableFetcher)project.getObjects().newInstance(JavaExecutableFetcher.class, new Object[0]);
            JavaPluginExtension java = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            JavaToolchainSpec toolchain = java.getToolchain();
            if (!toolchain.getLanguageVersion().isPresent()) {
                return null;
            }
            JavaLauncher launcher = (JavaLauncher)fetcher.getToolchainService().launcherFor(toolchain).get();
            return launcher.getExecutablePath().getAsFile().getAbsolutePath();
        });
    }
}

