/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.extension;

import dev.architectury.loom.forge.dependency.DependencyProviders;
import dev.architectury.loom.forge.dependency.ForgeRunsProvider;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.ForgeExtensionAPI;
import net.fabricmc.loom.api.NeoForgeExtensionAPI;
import net.fabricmc.loom.api.mappings.intermediate.IntermediateMappingsProvider;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.InstallerData;
import net.fabricmc.loom.configuration.LoomDependencyManager;
import net.fabricmc.loom.configuration.accesswidener.AccessWidenerFile;
import net.fabricmc.loom.configuration.providers.mappings.IntermediaryMappingsProvider;
import net.fabricmc.loom.configuration.providers.mappings.LayeredMappingsFactory;
import net.fabricmc.loom.configuration.providers.mappings.MappingConfiguration;
import net.fabricmc.loom.configuration.providers.mappings.NoOpIntermediateMappingsProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftMetadataProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.library.LibraryProcessorManager;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.IntermediaryMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MojangMappedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.NamedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.SrgMinecraftProvider;
import net.fabricmc.loom.extension.ForgeExtensionImpl;
import net.fabricmc.loom.extension.LoomFiles;
import net.fabricmc.loom.extension.LoomGradleExtensionApiImpl;
import net.fabricmc.loom.extension.MixinExtension;
import net.fabricmc.loom.extension.MixinExtensionImpl;
import net.fabricmc.loom.extension.NeoForgeExtensionImpl;
import net.fabricmc.loom.extension.RemapperExtensionHolder;
import net.fabricmc.loom.util.Lazy;
import net.fabricmc.loom.util.ModPlatform;
import net.fabricmc.loom.util.download.Download;
import net.fabricmc.loom.util.download.DownloadBuilder;
import net.fabricmc.loom.util.gradle.GradleUtils;
import org.gradle.api.Project;
import org.gradle.api.configuration.BuildFeatures;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;

public abstract class LoomGradleExtensionImpl
extends LoomGradleExtensionApiImpl
implements LoomGradleExtension {
    private final Project project;
    private final MixinExtension mixinApExtension;
    private final LoomFiles loomFiles;
    private final ConfigurableFileCollection unmappedMods;
    private final List<AccessWidenerFile> transitiveAccessWideners = new ArrayList<AccessWidenerFile>();
    private LoomDependencyManager dependencyManager;
    private MinecraftMetadataProvider metadataProvider;
    private MinecraftProvider minecraftProvider;
    private MappingConfiguration mappingConfiguration;
    private NamedMinecraftProvider<?> namedMinecraftProvider;
    private IntermediaryMinecraftProvider<?> intermediaryMinecraftProvider;
    private SrgMinecraftProvider<?> srgMinecraftProvider;
    private MojangMappedMinecraftProvider<?> mojangMappedMinecraftProvider;
    private InstallerData installerData;
    private boolean refreshDeps;
    private final ListProperty<LibraryProcessorManager.LibraryProcessorFactory> libraryProcessorFactories;
    private final boolean configurationCacheActive;
    private final boolean isolatedProjectsActive;
    private final boolean isCollectingDependencyVerificationMetadata;
    private final Property<Boolean> disableObfuscation;
    private final Property<Boolean> dontRemap;
    private DependencyProviders dependencyProviders;
    private ForgeRunsProvider forgeRunsProvider;
    private final Supplier<ForgeExtensionAPI> forgeExtension;
    private final Supplier<NeoForgeExtensionAPI> neoForgeExtension;

    @Inject
    protected abstract BuildFeatures getBuildFeatures();

    @Inject
    public LoomGradleExtensionImpl(Project project, LoomFiles files) {
        super(project, files);
        this.project = project;
        this.mixinApExtension = (MixinExtension)project.getObjects().newInstance(MixinExtensionImpl.class, new Object[]{project});
        this.loomFiles = files;
        this.unmappedMods = project.files(new Object[0]);
        this.forgeExtension = Lazy.of(() -> this.isForge() ? (ForgeExtensionAPI)project.getObjects().newInstance(ForgeExtensionImpl.class, new Object[]{project, this}) : null);
        this.neoForgeExtension = Lazy.of(() -> this.isNeoForge() ? (NeoForgeExtensionAPI)project.getObjects().newInstance(NeoForgeExtensionImpl.class, new Object[]{project}) : null);
        this.setIntermediateMappingsProvider(IntermediaryMappingsProvider.class, provider -> {
            provider.getIntermediaryUrl().convention(this.getIntermediaryUrl()).finalizeValueOnRead();
            provider.getRefreshDeps().set(project.provider(() -> LoomGradleExtension.get(project).refreshDeps()));
        });
        this.refreshDeps = this.manualRefreshDeps();
        this.libraryProcessorFactories = project.getObjects().listProperty(LibraryProcessorManager.LibraryProcessorFactory.class);
        this.libraryProcessorFactories.addAll(LibraryProcessorManager.DEFAULT_LIBRARY_PROCESSORS);
        this.libraryProcessorFactories.finalizeValueOnRead();
        this.configurationCacheActive = (Boolean)this.getBuildFeatures().getConfigurationCache().getActive().get();
        this.isolatedProjectsActive = (Boolean)this.getBuildFeatures().getIsolatedProjects().getActive().get();
        this.isCollectingDependencyVerificationMetadata = !project.getGradle().getStartParameter().getWriteDependencyVerifications().isEmpty();
        this.disableObfuscation = project.getObjects().property(Boolean.class);
        this.dontRemap = project.getObjects().property(Boolean.class);
        this.disableObfuscation.set(project.provider(() -> GradleUtils.getBooleanProperty(this.getProject(), "fabric.loom.disableObfuscation")));
        this.disableObfuscation.finalizeValueOnRead();
        this.dontRemap.set(this.disableObfuscation.map(notObfuscated -> notObfuscated != false || GradleUtils.getBooleanProperty(this.getProject(), "fabric.loom.dontRemap")));
        this.dontRemap.finalizeValueOnRead();
        if (this.refreshDeps) {
            project.getLogger().lifecycle("Refresh dependencies is in use, loom will be significantly slower.");
        }
        if (this.isolatedProjectsActive) {
            project.getLogger().lifecycle("Isolated projects is enabled, Loom support is highly experimental, not all features will be enabled.");
        }
    }

    @Override
    protected Project getProject() {
        return this.project;
    }

    @Override
    public LoomFiles getFiles() {
        return this.loomFiles;
    }

    @Override
    public MinecraftMetadataProvider getMetadataProvider() {
        return Objects.requireNonNull(this.metadataProvider, "Cannot get MinecraftMetadataProvider before it has been setup");
    }

    @Override
    public void setMetadataProvider(MinecraftMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    @Override
    public MinecraftProvider getMinecraftProvider() {
        return Objects.requireNonNull(this.minecraftProvider, "Cannot get MinecraftProvider before it has been setup");
    }

    @Override
    public void setMinecraftProvider(MinecraftProvider minecraftProvider) {
        this.minecraftProvider = minecraftProvider;
    }

    @Override
    public MappingConfiguration getMappingConfiguration() {
        if (this.disableObfuscation()) {
            throw new UnsupportedOperationException("Cannot get mappings configuration in a non-obfuscated environment");
        }
        return Objects.requireNonNull(this.mappingConfiguration, "Cannot get MappingsProvider before it has been setup");
    }

    @Override
    public void setMappingConfiguration(MappingConfiguration mappingConfiguration) {
        if (this.disableObfuscation()) {
            throw new UnsupportedOperationException("Cannot set mappings configuration in a non-obfuscated environment");
        }
        this.mappingConfiguration = mappingConfiguration;
    }

    @Override
    public NamedMinecraftProvider<?> getNamedMinecraftProvider() {
        return Objects.requireNonNull(this.namedMinecraftProvider, "Cannot get NamedMinecraftProvider before it has been setup");
    }

    @Override
    public IntermediaryMinecraftProvider<?> getIntermediaryMinecraftProvider() {
        return Objects.requireNonNull(this.intermediaryMinecraftProvider, "Cannot get IntermediaryMinecraftProvider before it has been setup");
    }

    @Override
    public void setNamedMinecraftProvider(NamedMinecraftProvider<?> namedMinecraftProvider) {
        this.namedMinecraftProvider = namedMinecraftProvider;
    }

    @Override
    public void setIntermediaryMinecraftProvider(IntermediaryMinecraftProvider<?> intermediaryMinecraftProvider) {
        this.intermediaryMinecraftProvider = intermediaryMinecraftProvider;
    }

    @Override
    public void noIntermediateMappings() {
        this.setIntermediateMappingsProvider(NoOpIntermediateMappingsProvider.class, p -> {});
    }

    @Override
    public SrgMinecraftProvider<?> getSrgMinecraftProvider() {
        return Objects.requireNonNull(this.srgMinecraftProvider, "Cannot get SrgMinecraftProvider before it has been setup");
    }

    @Override
    public void setSrgMinecraftProvider(SrgMinecraftProvider<?> srgMinecraftProvider) {
        this.srgMinecraftProvider = srgMinecraftProvider;
    }

    @Override
    public MojangMappedMinecraftProvider<?> getMojangMappedMinecraftProvider() {
        return Objects.requireNonNull(this.mojangMappedMinecraftProvider, "Cannot get MojangMappedMinecraftProvider before it has been setup");
    }

    @Override
    public void setMojangMappedMinecraftProvider(MojangMappedMinecraftProvider<?> mojangMappedMinecraftProvider) {
        this.mojangMappedMinecraftProvider = mojangMappedMinecraftProvider;
    }

    @Override
    public FileCollection getMinecraftJarsCollection(MappingsNamespace mappingsNamespace) {
        return this.getProject().files(new Object[]{this.getProject().provider(() -> this.getProject().files(new Object[]{this.getMinecraftJars(mappingsNamespace).stream().map(Path::toFile).toList()}))});
    }

    @Override
    public ConfigurableFileCollection getUnmappedModCollection() {
        return this.unmappedMods;
    }

    @Override
    public void setInstallerData(InstallerData object) {
        this.installerData = object;
    }

    @Override
    public InstallerData getInstallerData() {
        return this.installerData;
    }

    @Override
    public MixinExtension getMixin() {
        return this.mixinApExtension;
    }

    @Override
    public List<AccessWidenerFile> getTransitiveAccessWideners() {
        return this.transitiveAccessWideners;
    }

    @Override
    public void addTransitiveAccessWideners(List<AccessWidenerFile> accessWidenerFiles) {
        this.transitiveAccessWideners.addAll(accessWidenerFiles);
    }

    @Override
    public DownloadBuilder download(String url) {
        DownloadBuilder builder;
        try {
            builder = Download.create(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to create downloader for: " + String.valueOf(e));
        }
        if (this.project.getGradle().getStartParameter().isOffline()) {
            builder.offline();
        }
        if (this.manualRefreshDeps()) {
            builder.forceDownload();
        }
        return builder;
    }

    @Override
    public boolean manualRefreshDeps() {
        return this.project.getGradle().getStartParameter().isRefreshDependencies() || Boolean.getBoolean("loom.refresh");
    }

    @Override
    public boolean refreshDeps() {
        return this.refreshDeps;
    }

    @Override
    public void setRefreshDeps(boolean refreshDeps) {
        this.refreshDeps = refreshDeps;
    }

    @Override
    public ListProperty<LibraryProcessorManager.LibraryProcessorFactory> getLibraryProcessors() {
        return this.libraryProcessorFactories;
    }

    @Override
    public ListProperty<RemapperExtensionHolder> getRemapperExtensions() {
        return this.remapperExtensions;
    }

    @Override
    public Collection<LayeredMappingsFactory> getLayeredMappingFactories() {
        if (this.disableObfuscation()) {
            throw new UnsupportedOperationException("Cannot get layered mapping factories in a non-obfuscated environment");
        }
        this.hasEvaluatedLayeredMappings = true;
        return Collections.unmodifiableCollection(this.layeredMappingsDependencyMap.values());
    }

    @Override
    protected <T extends IntermediateMappingsProvider> void configureIntermediateMappingsProviderInternal(T provider) {
        provider.getMinecraftVersion().set(this.getProject().provider(() -> this.getMinecraftProvider().minecraftVersion()));
        provider.getMinecraftVersion().disallowChanges();
        provider.getDownloader().set(this::download);
        provider.getDownloader().disallowChanges();
        provider.getUseSplitOfficialNamespaces().set(this.getProject().provider(() -> this.getMinecraftProvider().isLegacySplitOfficialNamespaceVersion()));
        provider.getUseSplitOfficialNamespaces().disallowChanges();
    }

    @Override
    public boolean isConfigurationCacheActive() {
        return this.configurationCacheActive;
    }

    @Override
    public boolean isProjectIsolationActive() {
        return this.isolatedProjectsActive;
    }

    @Override
    public boolean isCollectingDependencyVerificationMetadata() {
        return this.isCollectingDependencyVerificationMetadata;
    }

    @Override
    public boolean dontRemapOutputs() {
        return (Boolean)this.dontRemap.get();
    }

    @Override
    public boolean disableObfuscation() {
        return (Boolean)this.disableObfuscation.get();
    }

    @Override
    public ForgeExtensionAPI getForge() {
        ModPlatform.assertPlatform(this, ModPlatform.FORGE);
        return this.forgeExtension.get();
    }

    @Override
    public NeoForgeExtensionAPI getNeoForge() {
        ModPlatform.assertPlatform(this, ModPlatform.NEOFORGE);
        return this.neoForgeExtension.get();
    }

    @Override
    public DependencyProviders getDependencyProviders() {
        return this.dependencyProviders;
    }

    @Override
    public void setDependencyProviders(DependencyProviders dependencyProviders) {
        this.dependencyProviders = dependencyProviders;
    }

    @Override
    public ForgeRunsProvider getForgeRunsProvider() {
        ModPlatform.assertForgeLike(this);
        return this.forgeRunsProvider;
    }

    @Override
    public void setForgeRunsProvider(ForgeRunsProvider forgeRunsProvider) {
        ModPlatform.assertForgeLike(this);
        this.forgeRunsProvider = forgeRunsProvider;
    }
}

