/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.forge.minecraft;

import de.oceanlabs.mcp.mcinjector.adaptors.ParameterAnnotationFixer;
import dev.architectury.loom.accesstransformer.AccessTransformerService;
import dev.architectury.loom.forge.CoreModClassRemapper;
import dev.architectury.loom.forge.InnerClassRemapper;
import dev.architectury.loom.forge.config.UserdevConfig;
import dev.architectury.loom.forge.dependency.DependencyProvider;
import dev.architectury.loom.forge.dependency.ForgeProvider;
import dev.architectury.loom.forge.dependency.ForgeUserdevProvider;
import dev.architectury.loom.forge.dependency.PatchProvider;
import dev.architectury.loom.forge.minecraft.ForgeMinecraftProvider;
import dev.architectury.loom.forge.tool.ForgeToolExecutor;
import dev.architectury.loom.forge.tool.ForgeToolValueSource;
import dev.architectury.loom.mappings.MappingOption;
import dev.architectury.loom.mcpconfig.McpConfigProvider;
import dev.architectury.loom.mcpconfig.McpExecutor;
import dev.architectury.loom.mcpconfig.McpExecutorBuilder;
import dev.architectury.loom.neoforge.SidedJarIndexGenerator;
import dev.architectury.loom.util.DependencyDownloader;
import dev.architectury.loom.util.Stopwatch;
import dev.architectury.loom.util.TempFiles;
import dev.architectury.loom.util.ThreadingUtils;
import dev.architectury.loom.util.Version;
import dev.architectury.loom.util.function.FsPathConsumer;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.build.IntermediaryNamespaces;
import net.fabricmc.loom.configuration.providers.mappings.TinyMappingsService;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.util.Check;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.LoomVersions;
import net.fabricmc.loom.util.ModPlatform;
import net.fabricmc.loom.util.TinyRemapperHelper;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.service.ScopedServiceFactory;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MappingTreeView;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.fabricmc.tinyremapper.InputTag;
import net.fabricmc.tinyremapper.NonClassCopyMode;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.extension.mixin.MixinExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;

public class MinecraftPatchedProvider {
    private static final String LOOM_PATCH_VERSION_KEY = "Loom-Patch-Version";
    private static final String CURRENT_LOOM_PATCH_VERSION = "10";
    private static final String NAME_MAPPING_SERVICE_PATH = "/inject/META-INF/services/cpw.mods.modlauncher.api.INameMappingService";
    private static final String MIN_NEOFORGE_MANUAL_CLEAN_JAR_CREATION_VERSION = "21.10.57-beta";
    private static final String MAX_NEOFORGE_MANUAL_CLEAN_JAR_CREATION_VERSION = "21.10.64";
    private final Project project;
    private final Logger logger;
    private final MinecraftProvider minecraftProvider;
    private final Type type;
    private Path minecraftIntermediateJar;
    private Path minecraftPatchedIntermediateJar;
    private Path minecraftPatchedIntermediateAtJar;
    private Path minecraftPatchedJar;
    private Path minecraftClientExtra;
    private boolean dirty = false;

    public static MinecraftPatchedProvider get(Project project) {
        MinecraftProvider provider = LoomGradleExtension.get(project).getMinecraftProvider();
        if (provider instanceof ForgeMinecraftProvider) {
            ForgeMinecraftProvider patched = (ForgeMinecraftProvider)((Object)provider);
            return patched.getPatchedProvider();
        }
        throw new UnsupportedOperationException("Project " + project.getPath() + " does not use MinecraftPatchedProvider!");
    }

    public MinecraftPatchedProvider(Project project, MinecraftProvider minecraftProvider, Type type) {
        this.project = project;
        this.logger = project.getLogger();
        this.minecraftProvider = minecraftProvider;
        this.type = type;
    }

    private LoomGradleExtension getExtension() {
        return LoomGradleExtension.get(this.project);
    }

    private void initPatchedFiles() {
        String forgeVersion = this.getExtension().getForgeProvider().getVersion().getCombined();
        Path forgeWorkingDir = ForgeProvider.getForgeCache(this.project);
        String patchId = (this.getExtension().isNeoForge() ? "neoforge" : "forge") + "-" + forgeVersion + "-";
        this.minecraftProvider.setJarPrefix(patchId);
        String intermediateId = this.getExtension().isNeoForge() ? "mojang" : "srg";
        this.minecraftIntermediateJar = forgeWorkingDir.resolve("minecraft-" + this.type.id + "-" + intermediateId + ".jar");
        this.minecraftPatchedIntermediateJar = forgeWorkingDir.resolve("minecraft-" + this.type.id + "-" + intermediateId + "-patched.jar");
        this.minecraftPatchedIntermediateAtJar = forgeWorkingDir.resolve("minecraft-" + this.type.id + "-" + intermediateId + "-at-patched.jar");
        this.minecraftPatchedJar = forgeWorkingDir.resolve("minecraft-" + this.type.id + "-patched.jar");
        this.minecraftClientExtra = forgeWorkingDir.resolve("client-extra.jar");
    }

    private void cleanAllCache() throws IOException {
        for (Path path : this.getGlobalCaches()) {
            Files.deleteIfExists(path);
        }
    }

    private Path[] getGlobalCaches() {
        Path[] files = new Path[]{this.minecraftIntermediateJar, this.minecraftPatchedIntermediateJar, this.minecraftPatchedIntermediateAtJar, this.minecraftPatchedJar, this.minecraftClientExtra};
        return files;
    }

    private void checkCache() throws IOException {
        if (this.getExtension().refreshDeps() || Stream.of(this.getGlobalCaches()).anyMatch(x$0 -> Files.notExists(x$0, new LinkOption[0])) || !this.isPatchedJarUpToDate(this.minecraftPatchedJar)) {
            this.cleanAllCache();
        }
    }

    private boolean shouldUseNeoForgeInstallerToolsToCreatePrePatchJar() {
        Version minVersion;
        if (!this.getExtension().isNeoForge()) {
            return false;
        }
        Version currentVersion = Version.parse(this.getExtension().getForgeProvider().getVersion().getCombined());
        if (currentVersion.compareTo(minVersion = Version.parse(MIN_NEOFORGE_MANUAL_CLEAN_JAR_CREATION_VERSION)) < 0) {
            return false;
        }
        Version maxVersion = Version.parse(MAX_NEOFORGE_MANUAL_CLEAN_JAR_CREATION_VERSION);
        return currentVersion.compareTo(maxVersion) < 0;
    }

    public void provide() throws Exception {
        this.initPatchedFiles();
        this.checkCache();
        this.dirty = false;
        if (Files.notExists(this.minecraftIntermediateJar, new LinkOption[0])) {
            this.dirty = true;
            this.createPrePatchJar();
        }
        if (this.dirty || Files.notExists(this.minecraftPatchedIntermediateJar, new LinkOption[0])) {
            this.dirty = true;
            this.patchJars();
        }
        if (this.dirty || Files.notExists(this.minecraftPatchedIntermediateAtJar, new LinkOption[0])) {
            this.dirty = true;
            this.accessTransformForge();
        }
    }

    public void remapJar(ServiceFactory serviceFactory) throws Exception {
        if (this.dirty) {
            this.remapPatchedJar(serviceFactory);
            this.fillClientExtraJar(serviceFactory);
        }
        DependencyProvider.addDependency(this.project, this.minecraftClientExtra, "forgeExtra");
    }

    private void createPrePatchJar() throws IOException {
        if (this.shouldUseNeoForgeInstallerToolsToCreatePrePatchJar()) {
            this.createNeoForgeInstallerToolsPrePatchJar();
            return;
        }
        try (TempFiles tempFiles = new TempFiles();
             ScopedServiceFactory serviceFactory = new ScopedServiceFactory();){
            McpExecutorBuilder builder = this.createMcpExecutor(tempFiles.directory("loom-mcp"));
            builder.enqueue("rename");
            McpExecutor executor = (McpExecutor)serviceFactory.get(builder.build());
            Path output = executor.execute();
            Files.copy(output, this.minecraftIntermediateJar, new CopyOption[0]);
        }
    }

    private void createNeoForgeInstallerToolsPrePatchJar() throws IOException {
        try (TempFiles tempFiles = new TempFiles();){
            Path mappings = tempFiles.file("mappings", ".txt");
            this.getExtension().download(this.minecraftProvider.getVersionInfo().download("client_mappings").url()).downloadPath(mappings);
            ForgeToolValueSource.exec(this.project, (Action<? super ForgeToolExecutor.Settings>)((Action)settings -> {
                settings.getExecClasspath().from(new Object[]{DependencyDownloader.download(this.project, LoomVersions.NEOFORGE_INSTALLER_TOOLS.mavenNotation() + ":fatjar")});
                settings.getMainClass().set((Object)"net.neoforged.installertools.ConsoleTool");
                settings.args("--task", "PROCESS_MINECRAFT_JAR");
                switch (this.type.ordinal()) {
                    case 0: {
                        settings.args("--input", this.minecraftProvider.getMinecraftClientJar().getAbsolutePath());
                        break;
                    }
                    case 1: {
                        settings.args("--input", this.minecraftProvider.getMinecraftServerJar().getAbsolutePath());
                        break;
                    }
                    case 2: {
                        settings.args("--input", this.minecraftProvider.getMinecraftClientJar().getAbsolutePath());
                        settings.args("--input", this.minecraftProvider.getMinecraftServerJar().getAbsolutePath());
                    }
                }
                settings.args("--input-mappings", mappings.toAbsolutePath().toString());
                settings.args("--output", this.minecraftIntermediateJar.toAbsolutePath().toString());
                settings.args("--neoform-data", this.getExtension().getMcpConfigProvider().getMcp().toAbsolutePath().toString());
            }));
        }
    }

    private void fillClientExtraJar(ServiceFactory serviceFactory) throws IOException {
        Files.deleteIfExists(this.minecraftClientExtra);
        try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(this.minecraftClientExtra, true);){
            if (this.getExtension().isNeoForge()) {
                Path manifestPath = fs.getPath("META-INF", "MANIFEST.MF");
                this.generateNeoForgeDistManifest(serviceFactory, manifestPath);
            }
        }
        this.copyNonClassFiles(this.minecraftProvider.getMinecraftClientJar().toPath(), this.minecraftClientExtra);
    }

    private void generateNeoForgeDistManifest(ServiceFactory serviceFactory, Path manifestPath) throws IOException {
        MemoryMappingTree mappings = this.getMappingTree(serviceFactory);
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().putValue("Minecraft-Dists", this.type.getNeoForgeDistsAttribute());
        if (this.type == Type.MERGED) {
            Path clientJar = this.minecraftProvider.getMinecraftClientJar().toPath();
            Path serverJar = Objects.requireNonNullElse(this.minecraftProvider.getMinecraftExtractedServerJar(), this.minecraftProvider.getMinecraftServerJar()).toPath();
            SidedJarIndexGenerator generator = new SidedJarIndexGenerator(clientJar, serverJar, (MappingTreeView)mappings);
            generator.split((filePath, dist) -> {
                Attributes fileAttributes = new Attributes();
                fileAttributes.putValue("Minecraft-Dist", dist);
                manifest.getEntries().put(filePath, fileAttributes);
            });
        }
        Files.createDirectories(manifestPath.getParent(), new FileAttribute[0]);
        try (OutputStream out = Files.newOutputStream(manifestPath, new OpenOption[0]);){
            manifest.write(out);
        }
    }

    private MemoryMappingTree getMappingTree(ServiceFactory serviceFactory) {
        MappingOption mappingOption = MappingOption.forPlatform(this.getExtension());
        TinyMappingsService mappingsService = this.getExtension().getMappingConfiguration().getMappingsService(this.project, serviceFactory, mappingOption);
        return mappingsService.getMappingTree();
    }

    private TinyRemapper buildRemapper(ServiceFactory serviceFactory, Path input) throws IOException {
        String sourceNamespace = IntermediaryNamespaces.intermediary(this.project);
        MemoryMappingTree mappings = this.getMappingTree(serviceFactory);
        TinyRemapper.Builder builder = TinyRemapper.newRemapper().withMappings(TinyRemapperHelper.create((MappingTree)mappings, sourceNamespace, "official", true)).withMappings(InnerClassRemapper.of(InnerClassRemapper.readClassNames(input), (MappingTree)mappings, sourceNamespace, "official")).renameInvalidLocals(true).rebuildSourceFilenames(true);
        if (this.getExtension().isNeoForge()) {
            builder.extension((TinyRemapper.Extension)new MixinExtension(inputTag -> true));
        }
        return builder.build();
    }

    private void fixParameterAnnotation(Path jarFile) throws Exception {
        this.logger.info(":fixing parameter annotations for " + String.valueOf(jarFile.toAbsolutePath()));
        Stopwatch stopwatch = Stopwatch.createStarted();
        try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(jarFile, false);){
            ThreadingUtils.TaskCompleter completer = ThreadingUtils.taskCompleter();
            for (Path file : Files.walk(fs.getPath("/", new String[0]), new FileVisitOption[0])::iterator) {
                if (!file.toString().endsWith(".class")) continue;
                completer.add(() -> {
                    byte[] bytes = Files.readAllBytes(file);
                    ClassReader reader = new ClassReader(bytes);
                    ClassNode node = new ClassNode();
                    ParameterAnnotationFixer visitor = new ParameterAnnotationFixer((ClassVisitor)node, null);
                    reader.accept((ClassVisitor)visitor, 0);
                    ClassWriter writer = new ClassWriter(1);
                    node.accept((ClassVisitor)writer);
                    byte[] out = writer.toByteArray();
                    if (!Arrays.equals(bytes, out)) {
                        Files.delete(file);
                        Files.write(file, out, new OpenOption[0]);
                    }
                });
            }
            completer.complete();
        }
        this.logger.info(":fixed parameter annotations for " + String.valueOf(jarFile.toAbsolutePath()) + " in " + String.valueOf(stopwatch.stop()));
    }

    private void deleteParameterNames(Path jarFile) throws Exception {
        this.logger.info(":deleting parameter names for " + String.valueOf(jarFile.toAbsolutePath()));
        Stopwatch stopwatch = Stopwatch.createStarted();
        try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(jarFile, false);){
            ThreadingUtils.TaskCompleter completer = ThreadingUtils.taskCompleter();
            final Pattern vignetteParameters = Pattern.compile("p_[0-9a-zA-Z]+_(?:[0-9a-zA-Z]+_)?");
            for (Path file : Files.walk(fs.getPath("/", new String[0]), new FileVisitOption[0])::iterator) {
                if (!file.toString().endsWith(".class")) continue;
                completer.add(() -> {
                    byte[] bytes = Files.readAllBytes(file);
                    ClassReader reader = new ClassReader(bytes);
                    ClassWriter writer = new ClassWriter(0);
                    reader.accept(new ClassVisitor(this, 589824, (ClassVisitor)writer){

                        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                            return new MethodVisitor(589824, super.visitMethod(access, name, descriptor, signature, exceptions)){

                                public void visitParameter(String name, int access) {
                                    if (name != null && vignetteParameters.matcher(name).matches()) {
                                        super.visitParameter(null, access);
                                    } else {
                                        super.visitParameter(name, access);
                                    }
                                }

                                public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
                                    if (!vignetteParameters.matcher(name).matches()) {
                                        super.visitLocalVariable(name, descriptor, signature, start, end, index);
                                    }
                                }
                            };
                        }
                    }, 0);
                    byte[] out = writer.toByteArray();
                    if (!Arrays.equals(bytes, out)) {
                        Files.delete(file);
                        Files.write(file, out, new OpenOption[0]);
                    }
                });
            }
            completer.complete();
        }
        this.logger.info(":deleted parameter names for " + String.valueOf(jarFile.toAbsolutePath()) + " in " + String.valueOf(stopwatch.stop()));
    }

    private File getForgeJar() {
        return this.getExtension().getForgeUniversalProvider().getForge();
    }

    private File getForgeUserdevJar() {
        return this.getExtension().getForgeUserdevProvider().getUserdevJar();
    }

    private boolean isPatchedJarUpToDate(Path jar) throws IOException {
        if (Files.notExists(jar, new LinkOption[0])) {
            return false;
        }
        byte[] manifestBytes = ZipUtils.unpackNullable(jar, "META-INF/MANIFEST.MF");
        if (manifestBytes == null) {
            return false;
        }
        Manifest manifest = new Manifest(new ByteArrayInputStream(manifestBytes));
        Attributes attributes = manifest.getMainAttributes();
        String value = attributes.getValue(LOOM_PATCH_VERSION_KEY);
        if (Objects.equals(value, CURRENT_LOOM_PATCH_VERSION)) {
            return true;
        }
        this.logger.lifecycle(":forge patched jars not up to date. current version: " + value);
        return false;
    }

    private void accessTransformForge() throws IOException {
        Path input = this.minecraftPatchedIntermediateJar;
        Path target = this.minecraftPatchedIntermediateAtJar;
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.logger.lifecycle(":access transforming minecraft");
        try (TempFiles tempFiles = new TempFiles();
             ScopedServiceFactory serviceFactory = new ScopedServiceFactory();){
            AccessTransformerService service = (AccessTransformerService)serviceFactory.get(AccessTransformerService.createOptionsForLoaderAts(this.project, tempFiles));
            Files.deleteIfExists(target);
            service.execute(input, target);
        }
        this.logger.lifecycle(":access transformed minecraft in " + String.valueOf(stopwatch.stop()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remapPatchedJar(ServiceFactory serviceFactory) throws Exception {
        this.logger.lifecycle(":remapping minecraft (TinyRemapper, srg -> official)");
        Path mcInput = this.minecraftPatchedIntermediateAtJar;
        Path mcOutput = this.minecraftPatchedJar;
        Path forgeJar = this.getForgeJar().toPath();
        Path forgeUserdevJar = this.getForgeUserdevJar().toPath();
        Files.deleteIfExists(mcOutput);
        TinyRemapper remapper = this.buildRemapper(serviceFactory, mcInput);
        try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(mcOutput).build();){
            outputConsumer.addNonClassFiles(forgeJar, NonClassCopyMode.FIX_META_INF, remapper);
            InputTag mcTag = remapper.createInputTag();
            InputTag forgeTag = remapper.createInputTag();
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            futures.add(remapper.readInputsAsync(mcTag, new Path[]{mcInput}));
            futures.add(remapper.readInputsAsync(forgeTag, new Path[]{forgeJar, forgeUserdevJar}));
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            remapper.apply((BiConsumer)outputConsumer, new InputTag[]{mcTag});
            remapper.apply((BiConsumer)outputConsumer, new InputTag[]{forgeTag});
        }
        finally {
            remapper.finish();
        }
        this.copyUserdevFiles(forgeUserdevJar, mcOutput);
        this.remapCoreMods(mcOutput, serviceFactory);
        this.applyLoomPatchVersion(mcOutput);
    }

    private void remapCoreMods(Path patchedJar, ServiceFactory serviceFactory) throws Exception {
        MappingOption mappingOption = MappingOption.forPlatform(this.getExtension());
        TinyMappingsService mappingsService = this.getExtension().getMappingConfiguration().getMappingsService(this.project, serviceFactory, mappingOption);
        MemoryMappingTree mappings = mappingsService.getMappingTree();
        CoreModClassRemapper.remapJar(this.project, (ModPlatform)((Object)this.getExtension().getPlatform().get()), patchedJar, (MappingTree)mappings);
    }

    private void patchJars() throws Exception {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.logger.lifecycle(":patching jars");
        this.patchJars(this.minecraftIntermediateJar, this.minecraftPatchedIntermediateJar, this.type.patches.apply(this.getExtension().getPatchProvider(), this.getExtension().getForgeUserdevProvider()));
        this.copyMissingClasses(this.minecraftIntermediateJar, this.minecraftPatchedIntermediateJar);
        this.deleteParameterNames(this.minecraftPatchedIntermediateJar);
        if (this.getExtension().isForgeLikeAndNotOfficial()) {
            this.fixParameterAnnotation(this.minecraftPatchedIntermediateJar);
        }
        this.logger.lifecycle(":patched jars in " + String.valueOf(stopwatch.stop()));
    }

    private void patchJars(Path clean, Path output, Path patches) {
        ForgeToolValueSource.exec(this.project, (Action<? super ForgeToolExecutor.Settings>)((Action)spec -> {
            UserdevConfig.BinaryPatcherConfig config = this.getExtension().getForgeUserdevProvider().getConfig().binpatcher();
            FileCollection download = DependencyDownloader.download(this.project, config.dependency());
            spec.classpath(download);
            spec.getMainClass().set((Object)MinecraftPatchedProvider.getMainClass((Iterable<File>)download));
            Iterator<String> iterator = config.args().iterator();
            while (iterator.hasNext()) {
                String arg;
                String actual = switch (arg = iterator.next()) {
                    case "{clean}" -> clean.toAbsolutePath().toString();
                    case "{output}" -> output.toAbsolutePath().toString();
                    case "{patch}" -> patches.toAbsolutePath().toString();
                    default -> arg;
                };
                spec.args(actual);
            }
        }));
    }

    private static String getMainClass(Iterable<File> files) {
        String mainClass = null;
        IOException ex = null;
        for (File file : files) {
            block18: {
                if (!file.getName().endsWith(".jar")) continue;
                try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(file.toPath());){
                    Path mfPath = fs.getPath("META-INF/MANIFEST.MF", new String[0]);
                    if (!Files.exists(mfPath, new LinkOption[0])) break block18;
                    try (InputStream in = Files.newInputStream(mfPath, new OpenOption[0]);){
                        mainClass = new Manifest(in).getMainAttributes().getValue("Main-Class");
                    }
                }
                catch (IOException e) {
                    if (ex == null) {
                        ex = e;
                    }
                    ex.addSuppressed(e);
                }
            }
            if (mainClass == null) continue;
            break;
        }
        if (mainClass == null) {
            if (ex != null) {
                throw new UncheckedIOException(ex);
            }
            throw new RuntimeException("Failed to find main class");
        }
        return mainClass;
    }

    private void walkFileSystems(Path source, Path target, Predicate<Path> filter, Function<FileSystem, Iterable<Path>> toWalk, FsPathConsumer action) throws IOException {
        try (FileSystemUtil.Delegate sourceFs = FileSystemUtil.getJarFileSystem(source, false);
             FileSystemUtil.Delegate targetFs = FileSystemUtil.getJarFileSystem(target, false);){
            for (Path sourceDir : toWalk.apply(sourceFs.get())) {
                Path dir = sourceDir.toAbsolutePath();
                if (!Files.exists(dir, new LinkOption[0])) continue;
                Files.walk(dir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(filter).forEach(it -> {
                    boolean root = dir.getParent() == null;
                    try {
                        Path relativeSource = root ? it : dir.relativize((Path)it);
                        Path targetPath = targetFs.get().getPath(relativeSource.toString(), new String[0]);
                        action.accept(sourceFs.get(), targetFs.get(), (Path)it, targetPath);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
        }
    }

    private void walkFileSystems(Path source, Path target, Predicate<Path> filter, FsPathConsumer action) throws IOException {
        this.walkFileSystems(source, target, filter, FileSystem::getRootDirectories, action);
    }

    private void copyMissingClasses(Path source, Path target) throws IOException {
        this.walkFileSystems(source, target, it -> it.toString().endsWith(".class"), (sourceFs, targetFs, sourcePath, targetPath) -> {
            if (Files.exists(targetPath, new LinkOption[0])) {
                return;
            }
            Path parent = targetPath.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.copy(sourcePath, targetPath, new CopyOption[0]);
        });
    }

    private void copyNonClassFiles(Path source, Path target) throws IOException {
        Predicate<Path> filter = file -> {
            String s = file.toString();
            return !s.endsWith(".class") && !s.startsWith("/META-INF");
        };
        this.walkFileSystems(source, target, filter, this::copyReplacing);
    }

    private void copyReplacing(FileSystem sourceFs, FileSystem targetFs, Path sourcePath, Path targetPath) throws IOException {
        Path parent = targetPath.getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
    }

    private void copyUserdevFiles(Path source, Path target) throws IOException {
        Predicate<Path> filter = file -> !file.toString().endsWith(".class") && !file.toString().equals(NAME_MAPPING_SERVICE_PATH);
        this.walkFileSystems(source, target, filter, fs -> Collections.singleton(fs.getPath("inject", new String[0])), (sourceFs, targetFs, sourcePath, targetPath) -> {
            Path parent = targetPath.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.copy(sourcePath, targetPath, new CopyOption[0]);
        });
    }

    public void applyLoomPatchVersion(Path target) throws IOException {
        try (FileSystemUtil.Delegate delegate = FileSystemUtil.getJarFileSystem(target, false);){
            Closeable stream;
            Path manifestPath = delegate.get().getPath("META-INF/MANIFEST.MF", new String[0]);
            Check.require(Files.exists(manifestPath, new LinkOption[0]), "META-INF/MANIFEST.MF does not exist in patched srg jar!");
            Manifest manifest = new Manifest();
            if (Files.exists(manifestPath, new LinkOption[0])) {
                stream = Files.newInputStream(manifestPath, new OpenOption[0]);
                try {
                    manifest.read((InputStream)stream);
                    manifest.getMainAttributes().putValue(LOOM_PATCH_VERSION_KEY, CURRENT_LOOM_PATCH_VERSION);
                }
                finally {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                }
            }
            stream = Files.newOutputStream(manifestPath, StandardOpenOption.CREATE);
            try {
                manifest.write((OutputStream)stream);
            }
            finally {
                if (stream != null) {
                    ((OutputStream)stream).close();
                }
            }
        }
    }

    public McpExecutorBuilder createMcpExecutor(Path cache) {
        McpConfigProvider provider = this.getExtension().getMcpConfigProvider();
        return new McpExecutorBuilder(this.project, this.minecraftProvider, cache, provider, this.type.mcpId);
    }

    public Path getMinecraftIntermediateJar() {
        return this.minecraftIntermediateJar;
    }

    public Path getMinecraftPatchedIntermediateJar() {
        return this.minecraftPatchedIntermediateJar;
    }

    public Path getMinecraftPatchedJar() {
        return this.minecraftPatchedJar;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public static enum Type {
        CLIENT_ONLY("client", "client", (patch, userdev) -> patch.extractClientPatches()),
        SERVER_ONLY("server", "server", (patch, userdev) -> patch.extractServerPatches()),
        MERGED("merged", "joined", (patch, userdev) -> userdev.getJoinedPatches());

        private final String id;
        private final String mcpId;
        private final BiFunction<PatchProvider, ForgeUserdevProvider, Path> patches;

        private Type(String id, String mcpId, BiFunction<PatchProvider, ForgeUserdevProvider, Path> patches) {
            this.id = id;
            this.mcpId = mcpId;
            this.patches = patches;
        }

        private String getNeoForgeDistsAttribute() {
            return this == MERGED ? "client server" : this.id;
        }
    }
}

