/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.mcpconfig.steplogic;

import dev.architectury.loom.forge.config.ConfigValue;
import dev.architectury.loom.mcpconfig.steplogic.StepLogic;
import dev.architectury.loom.util.ThreadingUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import org.gradle.api.Action;
import org.gradle.api.provider.Provider;

public final class StripLogic
extends StepLogic<Service.Options> {
    public static final ServiceType<Service.Options, StripLogic> TYPE = new ServiceType<Service.Options, StripLogic>(Service.Options.class, StripLogic.class);

    public static Provider<Service.Options> createOptions(StepLogic.SetupContext context) {
        return TYPE.create(context.project(), (Action<Service.Options>)((Action)options -> {}));
    }

    public StripLogic(Service.Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    @Override
    public void execute(StepLogic.ExecutionContext context) throws IOException {
        Set filter = Files.readAllLines(context.mappings(), StandardCharsets.UTF_8).stream().filter(s -> !s.startsWith("\t")).map(s -> s.split(" ")[0] + ".class").collect(Collectors.toSet());
        Path input = Path.of(context.resolve(new ConfigValue.Variable("input")), new String[0]);
        try (FileSystemUtil.Delegate output = FileSystemUtil.getJarFileSystem(context.setOutput("stripped.jar"), true);
             FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(input, false);){
            ThreadingUtils.TaskCompleter completer = ThreadingUtils.taskCompleter();
            for (Path path : Files.walk(fs.get().getPath("/", new String[0]), new FileVisitOption[0])::iterator) {
                String trimLeadingSlash = StripLogic.trimLeadingSlash(path.toString());
                if (!trimLeadingSlash.endsWith(".class")) continue;
                boolean has = filter.contains(trimLeadingSlash);
                Object s2 = trimLeadingSlash;
                while (((String)s2).contains("$") && !has) {
                    s2 = ((String)s2).substring(0, ((String)s2).lastIndexOf("$")) + ".class";
                    has = filter.contains(s2);
                }
                if (!has) continue;
                Path to = output.get().getPath(trimLeadingSlash, new String[0]);
                Path parent = to.getParent();
                if (parent != null) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                completer.add(() -> Files.copy(path, to, StandardCopyOption.COPY_ATTRIBUTES));
            }
            completer.complete();
        }
    }

    private static String trimLeadingSlash(String string) {
        if (string.startsWith(File.separator)) {
            return string.substring(File.separator.length());
        }
        if (string.startsWith("/")) {
            return string.substring(1);
        }
        return string;
    }
}

