/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import codechicken.diffpatch.cli.CliOperation;
import codechicken.diffpatch.cli.PatchOperation;
import codechicken.diffpatch.util.LoggingOutputStream;
import codechicken.diffpatch.util.PatchMode;
import dev.architectury.loom.accesstransformer.AccessTransformerService;
import dev.architectury.loom.forge.ForgeSourcesService;
import dev.architectury.loom.forge.minecraft.MinecraftPatchedProvider;
import dev.architectury.loom.forge.tool.ForgeToolExecutor;
import dev.architectury.loom.forge.tool.ForgeToolService;
import dev.architectury.loom.mcpconfig.McpExecutor;
import dev.architectury.loom.mcpconfig.McpExecutorBuilder;
import dev.architectury.loom.mcpconfig.steplogic.ConstantLogic;
import dev.architectury.loom.util.DependencyDownloader;
import dev.architectury.loom.util.TempFiles;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.loom.task.AbstractLoomTask;
import net.fabricmc.loom.task.GenerateSourcesTask;
import net.fabricmc.loom.task.service.MappingsService;
import net.fabricmc.loom.task.service.SourceRemapperService;
import net.fabricmc.loom.util.service.ScopedServiceFactory;
import net.fabricmc.loom.util.service.ServiceFactory;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class GenerateForgePatchedSourcesTask
extends AbstractLoomTask {
    @InputFile
    public abstract RegularFileProperty getInputJar();

    @InputFile
    public abstract RegularFileProperty getRuntimeJar();

    @OutputFile
    public abstract RegularFileProperty getOutputJar();

    @OutputFile
    protected abstract RegularFileProperty getSideAnnotationStrippedMinecraftJar();

    @Nested
    protected abstract Property<ForgeSourcesService.Options> getForgeSourcesOptions();

    @Nested
    protected abstract Property<McpExecutor.Options> getMcpExecutorOptions();

    @Nested
    protected abstract Property<AccessTransformerService.Options> getAccessTransformerOptions();

    @Nested
    protected abstract Property<ForgeToolService.Options> getToolServiceOptions();

    @Nested
    protected abstract Property<SourceRemapperService.Options> getSourceRemapperOptions();

    @Nested
    protected abstract Property<SasOptions> getSasOptions();

    @Input
    protected abstract Property<String> getPatchPathInZip();

    @Input
    protected abstract Property<String> getPatchesOriginalPrefix();

    @Input
    protected abstract Property<String> getPatchesModifiedPrefix();

    @Internal
    protected abstract Property<TempFiles> getTempFiles();

    public GenerateForgePatchedSourcesTask() {
        Path cache;
        this.getOutputs().upToDateWhen(o -> false);
        this.getOutputJar().fileProvider(this.getProject().provider(() -> GenerateSourcesTask.getJarFileWithSuffix(this.getRuntimeJar(), "-sources.jar")));
        this.getForgeSourcesOptions().convention(ForgeSourcesService.createOptions(this.getProject()));
        TempFiles tempFiles = new TempFiles();
        this.getTempFiles().value((Object)tempFiles).finalizeValue();
        try {
            cache = tempFiles.directory("mcp-cache");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.getSideAnnotationStrippedMinecraftJar().set(cache.resolve("side-annotation-stripped.jar").toFile());
        this.getMcpExecutorOptions().convention(this.getProject().provider(() -> {
            MinecraftPatchedProvider patchedProvider = MinecraftPatchedProvider.get(this.getProject());
            McpExecutorBuilder mcp = patchedProvider.createMcpExecutor(cache);
            mcp.setStepLogicProvider((setupContext, name, type) -> {
                if (name.equals("rename")) {
                    return ConstantLogic.createOptions(setupContext, () -> ((RegularFile)this.getSideAnnotationStrippedMinecraftJar().get()).getAsFile().toPath());
                }
                return null;
            });
            mcp.enqueue("decompile");
            mcp.enqueue("patch");
            try {
                return mcp.build();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).flatMap(o -> o));
        this.getAccessTransformerOptions().convention(AccessTransformerService.createOptionsForLoaderAts(this.getProject(), tempFiles));
        this.getToolServiceOptions().convention(ForgeToolService.createOptions(this.getProject()));
        SasOptions sasOptions = (SasOptions)this.getProject().getObjects().newInstance(SasOptions.class, new Object[0]);
        sasOptions.getUserdevJar().set(this.getExtension().getForgeUserdevProvider().getUserdevJar());
        sasOptions.getSass().set(this.getExtension().getForgeUserdevProvider().getConfig().sass());
        sasOptions.getClasspath().from(new Object[]{DependencyDownloader.download(this.getProject(), "net.minecraftforge:mergetool:1.1.6:fatjar", false, false)});
        this.getSasOptions().set((Object)sasOptions);
        this.getPatchPathInZip().set((Object)this.getExtension().getForgeUserdevProvider().getConfig().patches());
        this.getPatchesOriginalPrefix().set((Object)this.getExtension().getForgeUserdevProvider().getConfig().patchesOriginalPrefix().orElseThrow());
        this.getPatchesModifiedPrefix().set((Object)this.getExtension().getForgeUserdevProvider().getConfig().patchesModifiedPrefix().orElseThrow());
        this.getSourceRemapperOptions().set(SourceRemapperService.TYPE.create(this.getProject(), (Action<SourceRemapperService.Options>)((Action)sro -> {
            sro.getMappings().set(MappingsService.createOptionsWithProjectMappings(this.getProject(), (Provider<String>)this.getProject().provider(() -> "srg"), (Provider<String>)this.getProject().provider(() -> "named")));
            sro.getJavaCompileRelease().set((Object)SourceRemapperService.getJavaCompileRelease(this.getProject()));
            sro.getClasspath().from(new Object[]{this.getProject().getConfigurations().getByName("minecraftLibraries")});
        })));
    }

    @TaskAction
    public void run() throws IOException {
        try (TempFiles tempFiles = (TempFiles)this.getTempFiles().get();
             ScopedServiceFactory serviceFactory = new ScopedServiceFactory();){
            Path cache = tempFiles.directory("loom-decompilation");
            Path accessTransformed = cache.resolve("access-transformed.jar");
            AccessTransformerService atService = (AccessTransformerService)serviceFactory.get(this.getAccessTransformerOptions());
            atService.execute(((RegularFile)this.getInputJar().get()).getAsFile().toPath(), accessTransformed);
            Path sideAnnotationStripped = ((RegularFile)this.getSideAnnotationStrippedMinecraftJar().get()).getAsFile().toPath();
            this.stripSideAnnotations(accessTransformed, sideAnnotationStripped, serviceFactory);
            Path rawDecompiled = this.decompileAndPatch(serviceFactory);
            this.getLogger().lifecycle(":applying Forge patches");
            Path patched = this.sourcePatch(cache, rawDecompiled);
            this.remap(patched, serviceFactory);
            ForgeSourcesService sourcesService = (ForgeSourcesService)serviceFactory.get(this.getForgeSourcesOptions());
            sourcesService.addForgeSources(null, ((RegularFile)this.getOutputJar().get()).getAsFile().toPath());
        }
    }

    private Path decompileAndPatch(ScopedServiceFactory serviceFactory) throws IOException {
        McpExecutor executor = (McpExecutor)serviceFactory.get(this.getMcpExecutorOptions());
        return executor.execute();
    }

    private Path sourcePatch(Path cache, Path rawDecompiled) throws IOException {
        String patchPathInZip = (String)this.getPatchPathInZip().get();
        Path output = cache.resolve("patched.jar");
        Path rejects = cache.resolve("rejects");
        CliOperation.Result result = PatchOperation.builder().logTo((OutputStream)new LoggingOutputStream(this.getLogger(), LogLevel.INFO)).basePath(rawDecompiled).patchesPath(((RegularFile)((SasOptions)this.getSasOptions().get()).getUserdevJar().get()).getAsFile().toPath()).patchesPrefix(patchPathInZip).outputPath(output).mode(PatchMode.ACCESS).rejectsPath(rejects).aPrefix((String)this.getPatchesOriginalPrefix().get()).bPrefix((String)this.getPatchesModifiedPrefix().get()).build().operate();
        if (result.exit != 0) {
            throw new RuntimeException("Could not patch " + String.valueOf(rawDecompiled) + "; rejects saved to " + String.valueOf(rejects.toAbsolutePath()));
        }
        return output;
    }

    private void remap(Path input, ServiceFactory serviceFactory) throws IOException {
        SourceRemapperService remapperService = (SourceRemapperService)serviceFactory.get(this.getSourceRemapperOptions());
        remapperService.remapSourcesJar(input, ((RegularFile)this.getOutputJar().get()).getAsFile().toPath());
    }

    /*
     * Exception decompiling
     */
    private void stripSideAnnotations(Path input, Path output, ServiceFactory serviceFactory) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private /* synthetic */ void lambda$stripSideAnnotations$9(Path input, Path output, List sasPaths, ForgeToolExecutor.Settings spec) {
        spec.setClasspath(((SasOptions)this.getSasOptions().get()).getClasspath());
        spec.args("--strip", "--input", input.toAbsolutePath().toString(), "--output", output.toAbsolutePath().toString());
        for (Path sasPath : sasPaths) {
            spec.args("--data", sasPath.toAbsolutePath().toString());
        }
    }

    public static interface SasOptions {
        @InputFile
        public RegularFileProperty getUserdevJar();

        @Input
        public ListProperty<String> getSass();

        @Classpath
        public ConfigurableFileCollection getClasspath();
    }
}

