/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.ForgeExtensionAPI;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;

public class ForgeExtensionImpl
implements ForgeExtensionAPI {
    private final LoomGradleExtension extension;
    private final Property<Boolean> convertAccessWideners;
    private final SetProperty<String> extraAccessWideners;
    private final ConfigurableFileCollection accessTransformers;
    private final SetProperty<String> mixinConfigs;
    private final Property<Boolean> useCustomMixin;
    private final Property<Boolean> useForgeLoggerConfig;
    private final List<String> dataGenMods = new ArrayList<String>();

    @Inject
    public ForgeExtensionImpl(Project project, LoomGradleExtension extension) {
        this.extension = extension;
        this.convertAccessWideners = project.getObjects().property(Boolean.class).convention((Object)false);
        this.extraAccessWideners = project.getObjects().setProperty(String.class).empty();
        this.accessTransformers = project.getObjects().fileCollection();
        this.mixinConfigs = project.getObjects().setProperty(String.class).empty();
        this.useCustomMixin = project.getObjects().property(Boolean.class).convention((Object)true);
        this.useForgeLoggerConfig = project.getObjects().property(Boolean.class).convention((Object)false);
    }

    @Override
    public Property<Boolean> getConvertAccessWideners() {
        return this.convertAccessWideners;
    }

    @Override
    public SetProperty<String> getExtraAccessWideners() {
        return this.extraAccessWideners;
    }

    @Override
    public ConfigurableFileCollection getAccessTransformers() {
        return this.accessTransformers;
    }

    @Override
    public void accessTransformer(Object file) {
        this.accessTransformers.from(new Object[]{file});
    }

    @Override
    public SetProperty<String> getMixinConfigs() {
        return this.mixinConfigs;
    }

    @Override
    public void mixinConfigs(String ... mixinConfigs) {
        this.mixinConfigs.addAll((Object[])mixinConfigs);
    }

    @Override
    public Property<Boolean> getUseCustomMixin() {
        return this.useCustomMixin;
    }

    @Override
    public Property<Boolean> getUseForgeLoggerConfig() {
        return this.useForgeLoggerConfig;
    }

    @Override
    public List<String> getDataGenMods() {
        return Collections.unmodifiableList(this.dataGenMods);
    }

    @Override
    public void dataGen(Action<ForgeExtensionAPI.DataGenConsumer> action) {
        action.execute((Object)new ForgeExtensionAPI.DataGenConsumer(){

            @Override
            public void mod(String ... modIds) {
                ForgeExtensionImpl.this.dataGenMods.addAll(Arrays.asList(modIds));
                if (modIds.length > 0 && ForgeExtensionImpl.this.extension.getRunConfigs().findByName("data") == null) {
                    ForgeExtensionImpl.this.extension.getRunConfigs().create("data", RunConfigSettings::data);
                }
            }
        });
    }
}

