/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.mcpconfig;

import com.google.gson.JsonObject;
import dev.architectury.loom.forge.config.ConfigValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public record McpConfigStep(String type, String name, Map<String, ConfigValue> config) implements Serializable
{
    private static final String TYPE_KEY = "type";
    private static final String NAME_KEY = "name";

    public static McpConfigStep fromJson(JsonObject json) {
        String type = json.get(TYPE_KEY).getAsString();
        String name = json.has(NAME_KEY) ? json.get(NAME_KEY).getAsString() : type;
        HashMap<String, ConfigValue> config = new HashMap<String, ConfigValue>();
        for (String key : json.keySet()) {
            if (key.equals(TYPE_KEY) || key.equals(NAME_KEY)) continue;
            config.put(key, ConfigValue.of(json.get(key).getAsString()));
        }
        return new McpConfigStep(type, name, Map.copyOf(config));
    }
}

