/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.gradle;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.Logger;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;

public class ThreadedProgressLoggerConsumer
implements Consumer<String>,
AutoCloseable {
    public static final String CLOSE_LOGGERS = "LOOM_CLOSE_LOGGERS";
    private final Logger logger;
    private final String name;
    private final String desc;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final ProgressLogger progressGroup;
    private final Map<String, ProgressLogger> loggers = Collections.synchronizedMap(new HashMap());

    public ThreadedProgressLoggerConsumer(Project project, String name, String desc) {
        this.logger = project.getLogger();
        this.name = name;
        this.desc = desc;
        this.progressLoggerFactory = (ProgressLoggerFactory)((ProjectInternal)project).getServices().get(ProgressLoggerFactory.class);
        this.progressGroup = this.progressLoggerFactory.newOperation(name).setDescription(desc);
        this.progressGroup.started();
    }

    public ThreadedProgressLoggerConsumer(Logger logger, ProgressLoggerFactory progressLoggerFactory, String name, String desc) {
        this.logger = logger;
        this.name = name;
        this.desc = desc;
        this.progressLoggerFactory = progressLoggerFactory;
        this.progressGroup = this.progressLoggerFactory.newOperation(name).setDescription(desc);
        this.progressGroup.started();
    }

    @Override
    public void accept(String line) {
        if (!line.contains("::")) {
            this.logger.debug("Malformed threaded IPC log message: " + line);
            return;
        }
        int idx = line.indexOf("::");
        String id = line.substring(0, idx).trim();
        String data = line.substring(idx + 2).trim();
        if (data.equals(CLOSE_LOGGERS)) {
            this.resetLoggers();
            return;
        }
        this.loggers.computeIfAbsent(id, this::createLogger).progress(data);
    }

    private ProgressLogger createLogger(String id) {
        ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(this.getClass(), this.progressGroup);
        progressLogger.setDescription(this.desc);
        progressLogger.started();
        return progressLogger;
    }

    private void resetLoggers() {
        this.loggers.values().forEach(ProgressLogger::completed);
        this.loggers.clear();
    }

    @Override
    public void close() {
        this.resetLoggers();
        this.progressGroup.completed();
    }
}

