/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.launch;

import dev.architectury.loom.forge.ForgeLoggerConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.inject.Inject;
import net.fabricmc.loom.task.AbstractLoomTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class GenerateLog4jConfigTask
extends AbstractLoomTask {
    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @Input
    @ApiStatus.Internal
    protected abstract Property<Boolean> getUseForgeLoggerConfig();

    @InputFile
    @Optional
    @ApiStatus.Internal
    protected abstract RegularFileProperty getForgeLoggerConfigSource();

    @Inject
    public GenerateLog4jConfigTask() {
        this.getOutputFile().set(this.getExtension().getFiles().getDefaultLog4jConfigFile());
        if (this.getExtension().isForge()) {
            this.getUseForgeLoggerConfig().set(this.getProject().provider(() -> (Boolean)this.getExtension().getForge().getUseForgeLoggerConfig().get()));
            this.getForgeLoggerConfigSource().set(this.getProject().getLayout().file(this.getProject().provider(() -> ForgeLoggerConfig.getForgeLoggerConfigSource(this.getProject()))));
        } else {
            this.getUseForgeLoggerConfig().set((Object)false);
        }
    }

    @TaskAction
    public void run() {
        Path outputFile = ((RegularFile)this.getOutputFile().get()).getAsFile().toPath();
        if (((Boolean)this.getUseForgeLoggerConfig().get()).booleanValue()) {
            @Nullable RegularFile source = (RegularFile)this.getForgeLoggerConfigSource().getOrNull();
            if (source == null) {
                ForgeLoggerConfig.throwNotFound();
            }
            ForgeLoggerConfig.copyToPath(source.getAsFile().toPath(), outputFile);
            return;
        }
        try (InputStream is = GenerateLog4jConfigTask.class.getClassLoader().getResourceAsStream("log4j2.fabric.xml");){
            Files.deleteIfExists(outputFile);
            Files.copy(is, outputFile, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate log4j config", e);
        }
    }
}

