/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.fmj;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.loom.util.fmj.FabricModJsonSource;
import net.fabricmc.loom.util.fmj.FabricModJsonUtils;
import net.fabricmc.loom.util.fmj.FabricModJsonV0;
import net.fabricmc.loom.util.fmj.FabricModJsonV1;
import net.fabricmc.loom.util.fmj.FabricModJsonV2;
import net.fabricmc.loom.util.fmj.ModEnvironment;
import net.fabricmc.loom.util.fmj.ModMetadataFabricModJson;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public abstract sealed class FabricModJson
permits FabricModJsonV0, FabricModJsonV1, FabricModJsonV2, ModMetadataFabricModJson, Mockable {
    protected final JsonObject jsonObject;
    private final FabricModJsonSource source;

    protected FabricModJson(JsonObject jsonObject, FabricModJsonSource source) {
        this.jsonObject = Objects.requireNonNull(jsonObject);
        this.source = Objects.requireNonNull(source);
    }

    public abstract int getVersion();

    public String getId() {
        return FabricModJsonUtils.readString(this.jsonObject, "id");
    }

    public String getModVersion() {
        return FabricModJsonUtils.readString(this.jsonObject, "version");
    }

    @Nullable
    public abstract JsonElement getCustom(String var1);

    public abstract List<String> getMixinConfigurations();

    public abstract Map<String, ModEnvironment> getClassTweakers();

    public FabricModJsonSource getSource() {
        return this.source;
    }

    public final String toString() {
        return this.getClass().getName() + "[id=%s, version=%s, classTweakers=%s]".formatted(this.getId(), this.getVersion(), this.getClassTweakers());
    }

    public final int hashCode() {
        return Objects.hash(this.getId(), this.getVersion());
    }

    @VisibleForTesting
    public abstract non-sealed class Mockable
    extends FabricModJson {
        private Mockable(FabricModJson this$0) {
            super(null, null);
            throw new AssertionError();
        }
    }
}

