/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.forge.dependency;

import dev.architectury.loom.util.Version;
import dev.architectury.loom.util.collection.Multimap;
import java.io.File;
import java.util.SequencedSet;
import java.util.stream.Collectors;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.ModSettings;
import net.fabricmc.loom.configuration.classpathgroups.ClasspathGroup;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.task.service.ClasspathGroupService;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ForgeModClassesService
extends Service<Options> {
    public static final ServiceType<Options, ForgeModClassesService> TYPE = new ServiceType<Options, ForgeModClassesService>(Options.class, ForgeModClassesService.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ForgeModClassesService.class);
    public static final String ENVIRONMENT_VARIABLE = "MOD_CLASSES";
    public static final String VARIABLE_KEY = "{source_roots}";

    public static Provider<Options> createOptions(Project project) {
        return TYPE.maybeCreate(project, options -> {
            LoomGradleExtension extension = LoomGradleExtension.get(project);
            if (!extension.isForgeLike()) {
                return false;
            }
            for (RunConfigSettings runConfigSettings : extension.getRunConfigs()) {
                NamedDomainObjectContainer<ModSettings> modOverrides = runConfigSettings.getMods();
                NamedDomainObjectContainer<ModSettings> modSettings = !modOverrides.isEmpty() ? modOverrides : extension.getMods();
                options.getClasspathGroupOptions().put((Object)runConfigSettings.getName(), ClasspathGroupService.create(project, modSettings));
            }
            options.getSourceRootsSeparator().set((Object)ForgeModClassesService.getSourceRootsSeparator(project));
            return true;
        });
    }

    private static String getSourceRootsSeparator(Project project) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        if (!extension.isForge() || extension.getForgeProvider().getVersion().getMajorVersion() < 49) {
            return File.pathSeparator;
        }
        for (Dependency dependency : project.getConfigurations().getByName("forgeDependencies").getDependencies()) {
            if (!dependency.getGroup().equals("net.minecraftforge") || !dependency.getName().equals("bootstrap-dev")) continue;
            Version version = Version.parse(dependency.getVersion());
            return version.compareTo(Version.parse("2.1.4")) >= 0 ? File.pathSeparator : ";";
        }
        LOGGER.warn("Failed to find bootstrap-dev in forge dependencies, using File.pathSeparator as separator");
        return File.pathSeparator;
    }

    public ForgeModClassesService(Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    public String getModClasses(String runConfig) {
        Multimap.Specialized<String, String, SequencedSet<String>> modClasses = Multimap.setMultimap();
        String separator = (String)((Options)this.getOptions()).getSourceRootsSeparator().get();
        ClasspathGroupService classpathGroupService = (ClasspathGroupService)this.getServiceFactory().get(((Options)this.getOptions()).getClasspathGroupOptions().getting((Object)runConfig));
        for (ClasspathGroup group : classpathGroupService.getClasspathGroups()) {
            if (group.resourceDir() != null) {
                modClasses.put(group.name(), group.resourceDir());
            }
            for (File file : classpathGroupService.getClasspath(group)) {
                modClasses.put(group.name(), file.getAbsolutePath());
            }
        }
        return modClasses.streamEntries().map(entry -> (String)entry.left() + "%%" + (String)entry.right()).collect(Collectors.joining(separator));
    }

    public static interface Options
    extends Service.Options {
        @Nested
        public MapProperty<String, ClasspathGroupService.Options> getClasspathGroupOptions();

        @Input
        public Property<String> getSourceRootsSeparator();
    }
}

