/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom;

import java.util.List;
import net.fabricmc.loom.extension.LoomFiles;
import net.fabricmc.loom.util.MirrorUtil;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.PluginAware;
import org.jetbrains.annotations.NotNull;

public class LoomRepositoryPlugin
implements Plugin<PluginAware> {
    private static final List<String> FORGE_GROUPS = List.of("net.minecraftforge", "cpw.mods", "de.oceanlabs", "net.jodah", "org.mcmodlauncher");

    public void apply(@NotNull PluginAware target) {
        if (target instanceof Settings) {
            Settings settings = (Settings)target;
            this.declareRepositories(settings.getDependencyResolutionManagement().getRepositories(), LoomFiles.create(settings), (ExtensionAware)settings);
            settings.getGradle().getPluginManager().apply(LoomRepositoryPlugin.class);
        } else if (target instanceof Project) {
            Project project = (Project)target;
            if (project.getGradle().getPlugins().hasPlugin(LoomRepositoryPlugin.class)) {
                return;
            }
            this.declareRepositories(project.getRepositories(), LoomFiles.create(project), (ExtensionAware)project);
        } else {
            if (target instanceof Gradle) {
                return;
            }
            throw new IllegalArgumentException("Expected target to be a Project or Settings, but was a " + String.valueOf(target.getClass()));
        }
    }

    private void declareRepositories(RepositoryHandler repositories, LoomFiles files, ExtensionAware target) {
        this.declareLocalRepositories(repositories, files);
        repositories.maven(repo -> {
            repo.setName("Architectury");
            repo.setUrl((Object)"https://maven.architectury.dev/");
            repo.mavenContent(content -> content.includeGroup("dev.architectury"));
        });
        repositories.maven(repo -> {
            repo.setName("Fabric");
            repo.setUrl((Object)MirrorUtil.getFabricRepository(target));
        });
        MavenArtifactRepository mojangRepo = repositories.maven(repo -> {
            repo.setName("Mojang");
            repo.setUrl((Object)MirrorUtil.getLibrariesBase(target));
            repo.metadataSources(sources -> {
                sources.mavenPom();
                sources.artifact();
                sources.ignoreGradleMetadataRedirection();
            });
            repo.artifactUrls(new Object[]{"https://repo.maven.apache.org/maven2/"});
        });
        repositories.maven(repo -> {
            repo.setName("Forge");
            repo.setUrl((Object)"https://maven.minecraftforge.net/");
            repo.content(descriptor -> {
                for (String group : FORGE_GROUPS) {
                    descriptor.includeGroupAndSubgroups(group);
                }
            });
            repo.metadataSources(sources -> {
                sources.mavenPom();
                sources.ignoreGradleMetadataRedirection();
            });
        });
        ArtifactRepository mavenCentral = (ArtifactRepository)repositories.findByName("MavenRepo");
        if (mavenCentral != null) {
            repositories.remove((Object)mojangRepo);
            repositories.add(repositories.indexOf((Object)mavenCentral), (Object)mojangRepo);
        }
        repositories.mavenCentral();
    }

    private void declareLocalRepositories(RepositoryHandler repositories, LoomFiles files) {
        repositories.maven(repo -> {
            repo.setName("LoomLocalRemappedMods");
            repo.setUrl((Object)files.getRemappedModCache());
        });
        repositories.maven(repo -> {
            repo.setName("LoomGlobalMinecraft");
            repo.setUrl((Object)files.getGlobalMinecraftRepo());
        });
        repositories.maven(repo -> {
            repo.setName("LoomLocalMinecraft");
            repo.setUrl((Object)files.getLocalMinecraftRepo());
        });
        repositories.maven(repo -> {
            repo.setName("LoomTransformedForgeDependencies");
            repo.setUrl((Object)files.getForgeDependencyRepo());
        });
    }

    public static void setupForLegacyVersions(RepositoryHandler repositories) {
        repositories.named("Mojang", MavenArtifactRepository.class, repo -> repo.metadataSources(sources -> {
            sources.artifact();
            sources.ignoreGradleMetadataRedirection();
        }));
    }

    public static void forceLWJGLFromMavenCentral(RepositoryHandler repositories) {
        if (repositories.findByName("MavenCentralLWJGL") != null) {
            return;
        }
        MavenArtifactRepository central = repositories.maven(repo -> {
            repo.setName("MavenCentralLWJGL");
            repo.setUrl((Object)"https://repo.maven.apache.org/maven2/");
            repo.content(content -> content.includeGroup("org.lwjgl"));
        });
        repositories.exclusiveContent(repository -> {
            repository.forRepositories(new ArtifactRepository[]{central});
            repository.filter(filter -> filter.includeGroup("org.lwjgl"));
        });
    }
}

