/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic;

import dev.architectury.loom.forge.tool.ForgeToolExecutor;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.loom.configuration.providers.forge.ConfigValue;
import net.fabricmc.loom.util.download.DownloadBuilder;
import net.fabricmc.loom.util.function.CollectionUtil;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.Nullable;

public abstract class StepLogic<O extends Service.Options>
extends Service<O> {
    public StepLogic(O options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    public abstract void execute(ExecutionContext var1) throws IOException;

    public String getDisplayName(String stepName) {
        return stepName;
    }

    @FunctionalInterface
    public static interface StepLogicProvider {
        @Nullable
        public Provider<? extends Service.Options> getStepLogic(SetupContext var1, String var2, String var3);
    }

    public static interface SetupContext {
        public Project project();

        public Path downloadFile(String var1) throws IOException;

        public Path downloadDependency(String var1);

        public Provider<FileCollection> getMinecraftLibraries();
    }

    public static interface ExecutionContext {
        public Logger logger();

        public Path setOutput(String var1) throws IOException;

        public Path setOutput(Path var1);

        public Path cache() throws IOException;

        public Path mappings();

        public String resolve(ConfigValue var1);

        public DownloadBuilder downloadBuilder(String var1);

        public void javaexec(Action<? super ForgeToolExecutor.Settings> var1);

        default public List<String> resolve(List<ConfigValue> configValues) {
            return CollectionUtil.map(configValues, this::resolve);
        }
    }
}

