/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.inject.Inject;
import net.fabricmc.accesswidener.AccessWidenerFormatException;
import net.fabricmc.accesswidener.AccessWidenerReader;
import net.fabricmc.accesswidener.AccessWidenerVisitor;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.util.TinyRemapperLoggerAdapter;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.api.TrEnvironment;
import net.fabricmc.tinyremapper.api.TrLogger;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;

public abstract class ValidateAccessWidenerTask
extends DefaultTask {
    @SkipWhenEmpty
    @InputFile
    public abstract RegularFileProperty getAccessWidener();

    @InputFiles
    public abstract ConfigurableFileCollection getTargetJars();

    @Inject
    public ValidateAccessWidenerTask() {
        LoomGradleExtension extension = LoomGradleExtension.get(this.getProject());
        this.getAccessWidener().convention((Provider)extension.getAccessWidenerPath()).finalizeValueOnRead();
        this.getTargetJars().from(new Object[]{extension.getMinecraftJarsCollection(MappingsNamespace.NAMED)}).finalizeValueOnRead();
        this.getOutputs().upToDateWhen(task -> true);
    }

    @TaskAction
    public void run() {
        TinyRemapper tinyRemapper = TinyRemapper.newRemapper((TrLogger)TinyRemapperLoggerAdapter.INSTANCE).build();
        for (File file : this.getTargetJars().getFiles()) {
            tinyRemapper.readClassPath(new Path[]{file.toPath()});
        }
        AccessWidenerValidator validator = new AccessWidenerValidator(tinyRemapper.getEnvironment());
        AccessWidenerReader accessWidenerReader = new AccessWidenerReader((AccessWidenerVisitor)validator);
        try (BufferedReader reader = Files.newBufferedReader(((RegularFile)this.getAccessWidener().get()).getAsFile().toPath(), StandardCharsets.UTF_8);){
            accessWidenerReader.read(reader, "named");
        }
        catch (AccessWidenerFormatException e) {
            this.getLogger().error("Failed to validate access-widener file {} on line {}: {}", new Object[]{((RegularFile)this.getAccessWidener().get()).getAsFile().getName(), e.getLineNumber(), e.getMessage()});
            throw e;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read access widener", e);
        }
        finally {
            tinyRemapper.finish();
        }
    }

    private record AccessWidenerValidator(TrEnvironment environment) implements AccessWidenerVisitor
    {
        public void visitClass(String name, AccessWidenerReader.AccessType access, boolean transitive) {
            if (this.environment().getClass(name) == null) {
                throw new RuntimeException("Could not find class (%s)".formatted(name));
            }
        }

        public void visitMethod(String owner, String name, String descriptor, AccessWidenerReader.AccessType access, boolean transitive) {
            if (this.environment().getMethod(owner, name, descriptor) == null) {
                throw new RuntimeException("Could not find method (%s%s) in class (%s)".formatted(name, descriptor, owner));
            }
        }

        public void visitField(String owner, String name, String descriptor, AccessWidenerReader.AccessType access, boolean transitive) {
            if (this.environment().getField(owner, name, descriptor) == null) {
                throw new RuntimeException("Could not find field (%s%s) in class (%s)".formatted(name, descriptor, owner));
            }
        }
    }
}

