/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import com.google.common.base.Strings;
import com.google.common.collect.Ordering;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Version(int major, int minor, int micro, int patch, @Nullable String qualifier) implements Comparable<Version>
{
    private static final Pattern REGEX = Pattern.compile("(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?()(?:[.-]([^+\\s]*))?(?:\\+.*)?");
    private static final Pattern REGEX_WITH_PATCH = Pattern.compile("(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:\\.(\\d+))?(?:[+.-]([^+\\s]*))?(?:\\+.*)?");
    public static final Version UNKNOWN = new Version(0, 0, 0, 0, null);

    public static Version parse(String version) {
        return Version.parse(version, false);
    }

    public static Version parse(String version, boolean withPatch) {
        Matcher matcher = (withPatch ? REGEX_WITH_PATCH : REGEX).matcher(version);
        if (!matcher.matches()) {
            return UNKNOWN;
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = !Strings.isNullOrEmpty((String)matcher.group(2)) ? Integer.parseInt(matcher.group(2)) : 0;
        int micro = !Strings.isNullOrEmpty((String)matcher.group(3)) ? Integer.parseInt(matcher.group(3)) : 0;
        int patch = !Strings.isNullOrEmpty((String)matcher.group(4)) ? Integer.parseInt(matcher.group(4)) : 0;
        String qualifier = matcher.group(5);
        return new Version(major, minor, micro, patch, qualifier == null ? null : qualifier.toLowerCase(Locale.ROOT));
    }

    public Version asBaseVersion() {
        return new Version(this.major, this.minor, this.micro, this.patch, null);
    }

    @Override
    public int compareTo(@NotNull Version other) {
        if (this.major != other.major) {
            return this.major - other.major;
        }
        if (this.minor != other.minor) {
            return this.minor - other.minor;
        }
        if (this.micro != other.micro) {
            return this.micro - other.micro;
        }
        if (this.patch != other.patch) {
            return this.patch - other.patch;
        }
        return Ordering.natural().nullsLast().compare((Object)this.qualifier, (Object)other.qualifier);
    }
}

