/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.ConfigContext;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJarMerger;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftMetadataProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergedMinecraftProvider
extends MinecraftProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MergedMinecraftProvider.class);
    private Path minecraftMergedJar;

    public MergedMinecraftProvider(MinecraftMetadataProvider metadataProvider, ConfigContext configContext) {
        super(metadataProvider, configContext);
        if (this.isLegacyVersion()) {
            throw new RuntimeException("something has gone wrong - merged jar configuration selected but Minecraft " + metadataProvider.getMinecraftVersion() + " does not allow merging the obfuscated jars - the legacy-merged jar configuration should have been selected!");
        }
    }

    @Override
    protected void initFiles() {
        super.initFiles();
        this.minecraftMergedJar = this.path("minecraft-merged.jar");
    }

    @Override
    public List<Path> getMinecraftJars() {
        return List.of(this.minecraftMergedJar);
    }

    @Override
    public MappingsNamespace getOfficialNamespace() {
        return MappingsNamespace.OFFICIAL;
    }

    @Override
    public void provide() throws Exception {
        super.provide();
        if (!this.provideServer() || !this.provideClient()) {
            throw new UnsupportedOperationException("This version does not provide both the client and server jars - please select the client-only or server-only jar configuration!");
        }
        if (!Files.exists(this.minecraftMergedJar, new LinkOption[0]) || this.getExtension().refreshDeps()) {
            try {
                this.mergeJars();
            }
            catch (Throwable e) {
                Files.deleteIfExists(this.getMinecraftClientJar().toPath());
                Files.deleteIfExists(this.getMinecraftServerJar().toPath());
                Files.deleteIfExists(this.minecraftMergedJar);
                this.getProject().getLogger().error("Could not merge JARs! Deleting source JARs - please re-run the command and move on.", e);
                throw e;
            }
        }
    }

    protected void mergeJars() throws IOException {
        File minecraftClientJar = this.getMinecraftClientJar();
        File minecraftServerJar = this.getMinecraftServerJar();
        if (this.getServerBundleMetadata() != null) {
            minecraftServerJar = this.getMinecraftExtractedServerJar();
        }
        MergedMinecraftProvider.mergeJars(minecraftClientJar, minecraftServerJar, this.minecraftMergedJar.toFile());
    }

    public static void mergeJars(File clientJar, File serverJar, File mergedJar) throws IOException {
        LOGGER.info(":merging jars");
        Objects.requireNonNull(clientJar, "Cannot merge null client jar?");
        Objects.requireNonNull(serverJar, "Cannot merge null server jar?");
        try (MinecraftJarMerger jarMerger = new MinecraftJarMerger(clientJar, serverJar, mergedJar);){
            jarMerger.enableSyntheticParamsOffset();
            jarMerger.merge();
        }
    }

    public Path getMergedJar() {
        return this.minecraftMergedJar;
    }
}

