/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.forge.mcpconfig;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loom.configuration.DependencyInfo;
import net.fabricmc.loom.configuration.providers.forge.DependencyProvider;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.McpConfigData;
import net.fabricmc.loom.util.DeletingFileVisitor;
import net.fabricmc.loom.util.ZipUtils;
import org.gradle.api.Project;

public class McpConfigProvider
extends DependencyProvider {
    private Path mcp;
    private Path configJson;
    private Path unpacked;
    private McpConfigData data;

    public McpConfigProvider(Project project) {
        super(project);
    }

    @Override
    public void provide(DependencyInfo dependency) throws Exception {
        JsonObject json;
        this.init(dependency.getDependency().getVersion());
        Path mcpZip = dependency.resolveFile().orElseThrow(() -> new RuntimeException("Could not resolve MCPConfig")).toPath();
        if (!Files.exists(this.mcp, new LinkOption[0]) || !Files.exists(this.unpacked, new LinkOption[0]) || this.refreshDeps()) {
            Files.copy(mcpZip, this.mcp, StandardCopyOption.REPLACE_EXISTING);
            if (Files.exists(this.unpacked, new LinkOption[0])) {
                Files.walkFileTree(this.unpacked, new DeletingFileVisitor());
            }
            Files.createDirectory(this.unpacked, new FileAttribute[0]);
            ZipUtils.unpackAll(this.mcp, this.unpacked);
        }
        try (BufferedReader reader = Files.newBufferedReader(this.configJson);){
            json = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
        }
        this.data = McpConfigData.fromJson(json);
    }

    private void init(String version) {
        String mcpName = this.getExtension().isNeoForge() ? "neoform" : "mcp";
        Path dir = this.getMinecraftProvider().dir(mcpName + "/" + version).toPath();
        this.mcp = dir.resolve("mcp.zip");
        this.unpacked = dir.resolve("unpacked");
        this.configJson = this.unpacked.resolve("config.json");
    }

    public Path getMappings() {
        return this.unpacked.resolve(this.getMappingsPath());
    }

    public Path getUnpackedZip() {
        return this.unpacked;
    }

    public Path getMcp() {
        return this.mcp;
    }

    public boolean isOfficial() {
        return this.data.official();
    }

    public String getMappingsPath() {
        return this.data.mappingsPath();
    }

    @Override
    public String getTargetConfig() {
        return "mcp";
    }

    public McpConfigData getData() {
        return this.data;
    }
}

