/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.forge.mcpconfig;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.McpConfigFunction;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.McpConfigStep;

public record McpConfigData(String version, JsonObject data, String mappingsPath, boolean official, Map<String, List<McpConfigStep>> steps, Map<String, McpConfigFunction> functions) {
    public static McpConfigData fromJson(JsonObject json) {
        String version = json.get("version").getAsString();
        JsonObject data = json.getAsJsonObject("data");
        String mappingsPath = data.get("mappings").getAsString();
        boolean official = json.has("official") && json.getAsJsonPrimitive("official").getAsBoolean();
        JsonObject stepsJson = json.getAsJsonObject("steps");
        ImmutableMap.Builder stepsBuilder = ImmutableMap.builder();
        for (String key : stepsJson.keySet()) {
            ImmutableList.Builder stepListBuilder = ImmutableList.builder();
            for (JsonElement child : stepsJson.getAsJsonArray(key)) {
                stepListBuilder.add((Object)McpConfigStep.fromJson(child.getAsJsonObject()));
            }
            stepsBuilder.put((Object)key, (Object)stepListBuilder.build());
        }
        JsonObject functionsJson = json.getAsJsonObject("functions");
        ImmutableMap.Builder functionsBuilder = ImmutableMap.builder();
        for (String key : functionsJson.keySet()) {
            functionsBuilder.put((Object)key, (Object)McpConfigFunction.fromJson(functionsJson.getAsJsonObject(key)));
        }
        return new McpConfigData(version, data, mappingsPath, official, (Map<String, List<McpConfigStep>>)stepsBuilder.build(), (Map<String, McpConfigFunction>)functionsBuilder.build());
    }
}

