/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.LoomRepositoryPlugin;
import net.fabricmc.loom.configuration.ide.idea.IdeaUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record InstallerData(String version, JsonObject installerJson) {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstallerData.class);

    public void applyToProject(Project project) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        if (extension.getInstallerData() != null) {
            throw new IllegalStateException("Already applied installer data");
        }
        extension.setInstallerData(this);
        JsonObject libraries = this.installerJson.get("libraries").getAsJsonObject();
        this.applyDependendencies(libraries.get("common").getAsJsonArray(), project);
        if (libraries.has("development")) {
            this.applyDependendencies(libraries.get("development").getAsJsonArray(), project);
        }
    }

    private void applyDependendencies(JsonArray jsonArray, Project project) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        Configuration loaderDepsConfig = project.getConfigurations().getByName("loaderLibraries");
        Configuration annotationProcessor = project.getConfigurations().getByName("annotationProcessor");
        for (JsonElement jsonElement : jsonArray) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            String name = jsonObject.get("name").getAsString();
            LOGGER.debug("Adding dependency ({}) from installer JSON", (Object)name);
            ExternalModuleDependency modDep = (ExternalModuleDependency)project.getDependencies().create((Object)name);
            modDep.setTransitive(false);
            loaderDepsConfig.getDependencies().add((Object)modDep);
            if (!IdeaUtils.isIdeaSync() && ((Boolean)extension.getMixin().getUseLegacyMixinAp().get()).booleanValue()) {
                annotationProcessor.getDependencies().add((Object)modDep);
            }
            if (project.getGradle().getPlugins().hasPlugin(LoomRepositoryPlugin.class)) continue;
            this.addRepository(jsonObject, project);
        }
    }

    private void addRepository(JsonObject jsonObject, Project project) {
        if (!jsonObject.has("url")) {
            return;
        }
        String url = jsonObject.get("url").getAsString();
        boolean isPresent = project.getRepositories().stream().filter(artifactRepository -> artifactRepository instanceof MavenArtifactRepository).map(artifactRepository -> (MavenArtifactRepository)artifactRepository).anyMatch(mavenArtifactRepository -> mavenArtifactRepository.getUrl().toString().equalsIgnoreCase(url));
        if (isPresent) {
            return;
        }
        project.getRepositories().maven(mavenArtifactRepository -> mavenArtifactRepository.setUrl((Object)jsonObject.get("url").getAsString()));
    }
}

