/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration;

import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.mods.ModConfigurationRemapper;
import net.fabricmc.loom.util.SourceRemapper;
import net.fabricmc.loom.util.service.ServiceFactory;
import org.gradle.api.Project;

public class LoomDependencyManager {
    public void handleDependencies(Project project, ServiceFactory serviceFactory) {
        project.getLogger().info(":setting up loom dependencies");
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        SourceRemapper sourceRemapper = new SourceRemapper(project, serviceFactory, true);
        String platformSuffix = extension.isForgeLike() ? "_forge" : (extension.isQuilt() ? "_arch_quilt" : "");
        String mappingsIdentifier = extension.getMappingConfiguration().mappingsIdentifier() + platformSuffix;
        ModConfigurationRemapper.supplyModConfigurations(project, serviceFactory, mappingsIdentifier, extension, sourceRemapper);
        sourceRemapper.remapAll();
        if (extension.getInstallerData() == null && !extension.isForgeLike()) {
            if (extension.isQuilt()) {
                project.getLogger().info("quilt_installer.json not found in dependencies!");
            } else {
                project.getLogger().info("fabric-installer.json not found in dependencies!");
            }
        }
    }
}

