/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.forge.mcpconfig;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.loom.configuration.providers.forge.ConfigValue;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.StepLogic;
import net.fabricmc.loom.util.function.CollectionUtil;
import org.jetbrains.annotations.Nullable;

public record McpConfigFunction(String version, List<ConfigValue> args, List<ConfigValue> jvmArgs, @Nullable String repo) implements Serializable
{
    private static final String VERSION_KEY = "version";
    private static final String ARGS_KEY = "args";
    private static final String JVM_ARGS_KEY = "jvmargs";
    private static final String REPO_KEY = "repo";

    public Path download(StepLogic.SetupContext executionContext) throws IOException {
        if (this.repo != null) {
            return executionContext.downloadFile(this.getDownloadUrl());
        }
        return executionContext.downloadDependency(this.version);
    }

    private String getDownloadUrl() {
        String[] parts = this.version.split(":");
        StringBuilder builder = new StringBuilder();
        builder.append(this.repo);
        builder.append(parts[0].replace('.', '/')).append('/');
        builder.append(parts[1]).append('/');
        builder.append(parts[2]).append('/');
        builder.append(parts[1]).append('-').append(parts[2]);
        if (parts.length >= 4) {
            builder.append('-').append(parts[3]);
        }
        builder.append(".jar");
        return builder.toString();
    }

    public static McpConfigFunction fromJson(JsonObject json) {
        String version = json.get(VERSION_KEY).getAsString();
        List<ConfigValue> args = json.has(ARGS_KEY) ? McpConfigFunction.configValuesFromJson(json.getAsJsonArray(ARGS_KEY)) : List.of();
        List<ConfigValue> jvmArgs = json.has(JVM_ARGS_KEY) ? McpConfigFunction.configValuesFromJson(json.getAsJsonArray(JVM_ARGS_KEY)) : List.of();
        JsonElement repoJson = json.get(REPO_KEY);
        String repo = repoJson.isJsonPrimitive() ? repoJson.getAsString() : null;
        return new McpConfigFunction(version, args, jvmArgs, repo);
    }

    private static List<ConfigValue> configValuesFromJson(JsonArray json) {
        return CollectionUtil.map(json, child -> ConfigValue.of(child.getAsString()));
    }
}

