/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.forge.mcpconfig;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.hash.Hashing;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.loom.forge.tool.ForgeToolService;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.providers.forge.ForgeProvider;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.DependencySet;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.McpConfigFunction;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.McpConfigProvider;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.McpConfigStep;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.McpExecutor;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.ConstantLogic;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.DownloadManifestFileLogic;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.FunctionLogic;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.InjectLogic;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.ListLibrariesLogic;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.NoOpLogic;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.PatchLogic;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.StepLogic;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.StripLogic;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.util.ModPlatform;
import net.fabricmc.loom.util.function.CollectionUtil;
import net.fabricmc.loom.util.gradle.GradleUtils;
import net.fabricmc.loom.util.service.Service;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.Nullable;

public final class McpExecutorBuilder {
    private final Project project;
    private final MinecraftProvider minecraftProvider;
    private final Path cache;
    private final List<McpConfigStep> steps;
    private final DependencySet dependencySet;
    private final Map<String, McpConfigFunction> functions;
    private final Map<String, String> config = new HashMap<String, String>();
    private final StepLogic.SetupContext setupContext = new SetupContextImpl();
    @Nullable
    private StepLogic.StepLogicProvider stepLogicProvider = null;

    public McpExecutorBuilder(Project project, MinecraftProvider minecraftProvider, Path cache, McpConfigProvider provider, String environment) {
        this.project = project;
        this.minecraftProvider = minecraftProvider;
        this.cache = cache;
        this.steps = provider.getData().steps().get(environment);
        this.functions = provider.getData().functions();
        this.dependencySet = new DependencySet(this.steps);
        this.dependencySet.skip(step -> this.isNoOp(step.type()));
        this.checkMinecraftVersion(provider);
        this.addDefaultFiles(provider, environment);
    }

    private void checkMinecraftVersion(McpConfigProvider provider) {
        String actual;
        String expected = provider.getData().version();
        if (!expected.equals(actual = this.minecraftProvider.minecraftVersion())) {
            LoomGradleExtension extension = LoomGradleExtension.get(this.project);
            ForgeProvider forgeProvider = extension.getForgeProvider();
            String message = "%s %s is not for Minecraft %s (expected: %s).".formatted(((ModPlatform)((Object)extension.getPlatform().get())).displayName(), forgeProvider.getVersion().getCombined(), actual, expected);
            if (GradleUtils.getBooleanProperty(this.project, "loom.allowMismatchedPlatformVersion")) {
                this.project.getLogger().warn(message);
            } else {
                String fullMessage = "%s\nYou can suppress this error by adding '%s = true' to gradle.properties.".formatted(message, "loom.allowMismatchedPlatformVersion");
                throw new UnsupportedOperationException(fullMessage);
            }
        }
    }

    private void addDefaultFiles(McpConfigProvider provider, String environment) {
        for (Map.Entry entry : provider.getData().data().entrySet()) {
            JsonObject json;
            if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                this.addDefaultFile(provider, (String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            if (!((JsonElement)entry.getValue()).isJsonObject() || !(json = ((JsonElement)entry.getValue()).getAsJsonObject()).has(environment) || !json.get(environment).isJsonPrimitive()) continue;
            this.addDefaultFile(provider, (String)entry.getKey(), json.getAsJsonPrimitive(environment).getAsString());
        }
    }

    private void addDefaultFile(McpConfigProvider provider, String key, String value) {
        Path path = provider.getUnpackedZip().resolve(value).toAbsolutePath();
        if (!path.startsWith(provider.getUnpackedZip().toAbsolutePath())) {
            return;
        }
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        this.addConfig(key, path.toString());
    }

    public void addConfig(String key, String value) {
        this.config.put(key, value);
    }

    private Path getDownloadCache() throws IOException {
        Path downloadCache = this.cache.resolve("downloads");
        Files.createDirectories(downloadCache, new FileAttribute[0]);
        return downloadCache;
    }

    public McpExecutorBuilder enqueue(String step) {
        this.dependencySet.add(step);
        return this;
    }

    public Provider<McpExecutor.Options> build() throws IOException {
        SortedSet<String> stepNames = this.dependencySet.buildExecutionSet();
        this.dependencySet.clear();
        ArrayList<McpConfigStep> toExecute = new ArrayList<McpConfigStep>();
        for (String stepName : stepNames) {
            McpConfigStep step = CollectionUtil.find(this.steps, s -> s.name().equals(stepName)).orElseThrow(() -> new NoSuchElementException("Step '" + stepName + "' not found in MCP config"));
            toExecute.add(step);
        }
        return McpExecutor.TYPE.create(this.project, (Action<McpExecutor.Options>)((Action)options -> {
            LoomGradleExtension extension = LoomGradleExtension.get(this.project);
            for (McpConfigStep step : toExecute) {
                options.getStepLogicOptions().put((Object)step.name(), this.getStepLogic(step.name(), step.type()));
            }
            options.getStepsToExecute().set((Iterable)toExecute);
            options.getMappings().set(extension.getMcpConfigProvider().getMappings().toFile());
            options.getInitialConfig().set(this.config);
            options.getOffline().set((Object)this.project.getGradle().getStartParameter().isOffline());
            options.getManualRefreshDeps().set((Object)extension.manualRefreshDeps());
            options.getToolServiceOptions().set(ForgeToolService.createOptions(this.project));
            options.getCache().set(this.cache.toFile());
        }));
    }

    public void setStepLogicProvider(@Nullable StepLogic.StepLogicProvider stepLogicProvider) {
        this.stepLogicProvider = stepLogicProvider;
    }

    private boolean isNoOp(String stepType) {
        return "downloadManifest".equals(stepType) || "downloadJson".equals(stepType);
    }

    private Provider<? extends Service.Options> getStepLogic(String name, String type) {
        Provider<? extends Service.Options> custom;
        if (this.stepLogicProvider != null && (custom = this.stepLogicProvider.getStepLogic(this.setupContext, name, type)) != null) {
            return custom;
        }
        return switch (type) {
            case "downloadManifest", "downloadJson" -> NoOpLogic.createOptions(this.setupContext);
            case "downloadClient" -> ConstantLogic.createOptions(this.setupContext, () -> this.minecraftProvider.getMinecraftClientJar().toPath());
            case "downloadServer" -> ConstantLogic.createOptions(this.setupContext, () -> this.minecraftProvider.getMinecraftServerJar().toPath());
            case "strip" -> StripLogic.createOptions(this.setupContext);
            case "listLibraries" -> ListLibrariesLogic.createOptions(this.setupContext);
            case "downloadClientMappings" -> DownloadManifestFileLogic.createOptions(this.setupContext, this.minecraftProvider.getVersionInfo().download("client_mappings"));
            case "downloadServerMappings" -> DownloadManifestFileLogic.createOptions(this.setupContext, this.minecraftProvider.getVersionInfo().download("server_mappings"));
            case "inject" -> InjectLogic.createOptions(this.setupContext);
            case "patch" -> PatchLogic.createOptions(this.setupContext);
            default -> {
                if (this.functions.containsKey(type)) {
                    yield FunctionLogic.createOptions(this.setupContext, this.functions.get(type));
                }
                throw new UnsupportedOperationException("MCP config step type: " + type);
            }
        };
    }

    private class SetupContextImpl
    implements StepLogic.SetupContext {
        private SetupContextImpl() {
        }

        @Override
        public Project project() {
            return McpExecutorBuilder.this.project;
        }

        @Override
        public Path downloadFile(String url) throws IOException {
            Path path = McpExecutorBuilder.this.getDownloadCache().resolve(Hashing.sha256().hashString((CharSequence)url, StandardCharsets.UTF_8).toString().substring(0, 24));
            if (Files.exists(path, new LinkOption[0])) {
                return path;
            }
            SetupContextImpl.redirectAwareDownload(url, path);
            return path;
        }

        private static void redirectAwareDownload(String urlString, Path path) throws IOException {
            URL url = new URL(urlString);
            if (url.getProtocol().equals("http")) {
                url = new URL("https", url.getHost(), url.getPort(), url.getFile());
            }
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            if (connection.getResponseCode() == 301 || connection.getResponseCode() == 302) {
                SetupContextImpl.redirectAwareDownload(connection.getHeaderField("Location"), path);
            } else {
                try (InputStream in = connection.getInputStream();){
                    Files.copy(in, path, new CopyOption[0]);
                }
            }
        }

        @Override
        public Path downloadDependency(String notation) {
            Dependency dependency = McpExecutorBuilder.this.project.getDependencies().create((Object)notation);
            Configuration configuration = McpExecutorBuilder.this.project.getConfigurations().detachedConfiguration(new Dependency[]{dependency});
            configuration.setTransitive(false);
            return configuration.getSingleFile().toPath();
        }

        @Override
        public Provider<FileCollection> getMinecraftLibraries() {
            return this.project().provider(() -> ((Supplier)Suppliers.memoize(() -> {
                McpExecutorBuilder.this.project.getLogger().lifecycle(":downloading minecraft libraries, this may take a while...");
                Set files = McpExecutorBuilder.this.project.getConfigurations().getByName("minecraftRuntimeLibraries").resolve();
                return McpExecutorBuilder.this.project.files(new Object[]{files});
            })).get());
        }
    }
}

