/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.aw2at;

import dev.architectury.at.AccessChange;
import dev.architectury.at.AccessTransform;
import dev.architectury.at.AccessTransformSet;
import dev.architectury.at.ModifierChange;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.fabricmc.accesswidener.AccessWidenerReader;
import net.fabricmc.accesswidener.AccessWidenerVisitor;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.task.RemapJarTask;
import org.cadixdev.bombe.type.signature.MethodSignature;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.jetbrains.annotations.VisibleForTesting;

public final class Aw2At {
    public static void setup(Project project, RemapJarTask remapJar) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        if (extension.getAccessWidenerPath().isPresent()) {
            String awName = null;
            Path awPath = ((RegularFile)extension.getAccessWidenerPath().get()).getAsFile().toPath();
            SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
            SourceSet main = (SourceSet)sourceSets.getByName("main");
            boolean found = false;
            for (File srcDir : main.getResources().getSrcDirs()) {
                Path srcDirPath = srcDir.toPath().toAbsolutePath();
                if (!awPath.startsWith(srcDirPath)) continue;
                awName = srcDirPath.relativize(awPath).toString().replace(File.separator, "/");
                found = true;
                break;
            }
            if (!found) {
                awName = awPath.getFileName().toString();
            }
            remapJar.getAtAccessWideners().add((Object)awName);
        }
        remapJar.getAtAccessWideners().addAll(extension.getForge().getExtraAccessWideners());
    }

    public static AccessTransformSet toAccessTransformSet(BufferedReader reader) throws IOException {
        final AccessTransformSet atSet = AccessTransformSet.create();
        new AccessWidenerReader(new AccessWidenerVisitor(){

            public void visitClass(String name, AccessWidenerReader.AccessType access, boolean transitive) {
                atSet.getOrCreateClass(name).merge(Aw2At.toAt(access));
            }

            public void visitMethod(String owner, String name, String descriptor, AccessWidenerReader.AccessType access, boolean transitive) {
                atSet.getOrCreateClass(owner).mergeMethod(MethodSignature.of((String)name, (String)descriptor), Aw2At.toAt(access));
            }

            public void visitField(String owner, String name, String descriptor, AccessWidenerReader.AccessType access, boolean transitive) {
                atSet.getOrCreateClass(owner).mergeField(name, Aw2At.toAt(access));
            }
        }).read(reader);
        return atSet;
    }

    @VisibleForTesting
    public static AccessTransform toAt(AccessWidenerReader.AccessType access) {
        return switch (access) {
            default -> throw new IncompatibleClassChangeError();
            case AccessWidenerReader.AccessType.ACCESSIBLE -> AccessTransform.of((AccessChange)AccessChange.PUBLIC);
            case AccessWidenerReader.AccessType.EXTENDABLE, AccessWidenerReader.AccessType.MUTABLE -> AccessTransform.of((AccessChange)AccessChange.PUBLIC, (ModifierChange)ModifierChange.REMOVE);
        };
    }
}

