/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.processors;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.RemapConfigurationSettings;
import net.fabricmc.loom.api.processor.SpecContext;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonFactory;
import net.fabricmc.loom.util.fmj.FabricModJsonHelpers;
import net.fabricmc.loom.util.gradle.GradleUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.attributes.Usage;
import org.jetbrains.annotations.Nullable;

public record SpecContextImpl(List<FabricModJson> modDependencies, List<FabricModJson> localMods, List<FabricModJson> compileRuntimeMods) implements SpecContext
{
    public static SpecContextImpl create(Project project) {
        HashMap<String, List<FabricModJson>> fmjCache = new HashMap<String, List<FabricModJson>>();
        return new SpecContextImpl(SpecContextImpl.getDependentMods(project, fmjCache), FabricModJsonHelpers.getModsInProject(project), SpecContextImpl.getCompileRuntimeMods(project, fmjCache));
    }

    private static List<FabricModJson> getDependentMods(Project project, Map<String, List<FabricModJson>> fmjCache) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        ArrayList<FabricModJson> mods = new ArrayList<FabricModJson>();
        for (RemapConfigurationSettings entry : extension.getRemapConfigurations()) {
            Set artifacts = ((Configuration)entry.getSourceConfiguration().get()).resolve();
            for (File artifact : artifacts) {
                List fabricModJson = fmjCache.computeIfAbsent(artifact.toPath().toAbsolutePath().toString(), $ -> FabricModJsonFactory.createFromZipOptional(artifact.toPath()).map(List::of).orElseGet(List::of));
                if (fabricModJson.isEmpty()) continue;
                mods.add((FabricModJson)fabricModJson.get(0));
            }
        }
        if (!extension.isProjectIsolationActive() && !GradleUtils.getBooleanProperty(project, "fabric.loom.disableProjectDependentMods")) {
            for (Project dependentProject : SpecContextImpl.getDependentProjects(project).toList()) {
                mods.addAll(fmjCache.computeIfAbsent(dependentProject.getPath(), $ -> FabricModJsonHelpers.getModsInProject(dependentProject)));
            }
        }
        return SpecContextImpl.sorted(mods);
    }

    private static Stream<Project> getDependentProjects(Project project) {
        Stream<Project> runtimeProjects = SpecContextImpl.getLoomProjectDependencies(project, project.getConfigurations().getByName("runtimeClasspath"));
        Stream<Project> compileProjects = SpecContextImpl.getLoomProjectDependencies(project, project.getConfigurations().getByName("compileClasspath"));
        return Stream.concat(runtimeProjects, compileProjects).distinct();
    }

    private static List<FabricModJson> getCompileRuntimeMods(Project project, Map<String, List<FabricModJson>> fmjCache) {
        ArrayList<FabricModJson> mods = new ArrayList<FabricModJson>(SpecContextImpl.getCompileRuntimeModsFromRemapConfigs(project, fmjCache).toList());
        for (Project dependentProject : SpecContextImpl.getCompileRuntimeProjectDependencies(project).toList()) {
            mods.addAll(fmjCache.computeIfAbsent(dependentProject.getPath(), $ -> FabricModJsonHelpers.getModsInProject(dependentProject)));
        }
        return Collections.unmodifiableList(mods);
    }

    private static Stream<FabricModJson> getCompileRuntimeModsFromRemapConfigs(Project project, Map<String, List<FabricModJson>> fmjCache) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        Set runtimeModIds = extension.getRuntimeRemapConfigurations().stream().filter(settings -> (Boolean)settings.getApplyDependencyTransforms().get()).flatMap(SpecContextImpl.resolveArtifacts(project, true)).map(SpecContextImpl.modFromZip(fmjCache)).filter(Objects::nonNull).map(FabricModJson::getId).collect(Collectors.toSet());
        return extension.getCompileRemapConfigurations().stream().filter(settings -> (Boolean)settings.getApplyDependencyTransforms().get()).flatMap(SpecContextImpl.resolveArtifacts(project, false)).map(SpecContextImpl.modFromZip(fmjCache)).filter(Objects::nonNull).filter(fabricModJson -> runtimeModIds.contains(fabricModJson.getId())).sorted(Comparator.comparing(FabricModJson::getId));
    }

    private static Function<Path, @Nullable FabricModJson> modFromZip(Map<String, List<FabricModJson>> fmjCache) {
        return zipPath -> {
            List list = fmjCache.computeIfAbsent(zipPath.toAbsolutePath().toString(), $ -> FabricModJsonFactory.createFromZipOptional(zipPath).map(List::of).orElseGet(List::of));
            return list.isEmpty() ? null : (FabricModJson)list.get(0);
        };
    }

    private static Function<RemapConfigurationSettings, Stream<Path>> resolveArtifacts(Project project, boolean runtime) {
        Usage usage = (Usage)project.getObjects().named(Usage.class, runtime ? "java-runtime" : "java-api");
        return settings -> {
            Configuration configuration = ((Configuration)settings.getSourceConfiguration().get()).copyRecursive();
            configuration.setCanBeConsumed(false);
            configuration.attributes(attributes -> attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)usage));
            return configuration.resolve().stream().map(File::toPath);
        };
    }

    private static Stream<Project> getCompileRuntimeProjectDependencies(Project project) {
        Stream<Project> runtimeProjects = SpecContextImpl.getLoomProjectDependencies(project, project.getConfigurations().getByName("runtimeClasspath"));
        List<Project> compileProjects = SpecContextImpl.getLoomProjectDependencies(project, project.getConfigurations().getByName("compileClasspath")).toList();
        return runtimeProjects.filter(compileProjects::contains);
    }

    private static Stream<Project> getLoomProjectDependencies(Project project, Configuration configuration) {
        return configuration.getAllDependencies().withType(ProjectDependency.class).stream().map(d -> project.project(d.getPath())).filter(GradleUtils::isLoomProject);
    }

    private static List<FabricModJson> sorted(List<FabricModJson> mods) {
        return mods.stream().sorted(Comparator.comparing(FabricModJson::getId)).toList();
    }

    @Override
    public List<FabricModJson> modDependenciesCompileRuntime() {
        return this.compileRuntimeMods;
    }
}

