/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.forge;

import com.google.common.hash.Hashing;
import dev.architectury.loom.forge.ModDirTransformerDiscovererPatch;
import dev.architectury.loom.neoforge.LaunchHandlerPatcher;
import dev.architectury.loom.util.ClassVisitorUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.mods.ModConfigurationRemapper;
import net.fabricmc.loom.configuration.mods.dependency.LocalMavenHelper;
import net.fabricmc.loom.configuration.providers.forge.DependencyProvider;
import net.fabricmc.loom.configuration.providers.mappings.GradleMappingContext;
import net.fabricmc.loom.configuration.providers.mappings.MappingConfiguration;
import net.fabricmc.loom.util.ExceptionUtil;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.LoomVersions;
import net.fabricmc.loom.util.PropertyUtil;
import net.fabricmc.loom.util.Version;
import net.fabricmc.loom.util.srg.ForgeMappingsMerger;
import net.fabricmc.loom.util.srg.RemapObjectHolderVisitor;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;

public class ForgeLibrariesProvider {
    private static final String FML_LOADER_GROUP = "net.minecraftforge";
    private static final String FML_LOADER_NAME = "fmlloader";
    private static final String FANCYML_LOADER_GROUP = "net.neoforged.fancymodloader";
    private static final String FANCYML_LOADER_NAME = "loader";
    private static final Version FANCYML_LOADER_UNPROTECT_BACKEND_VERSION = Version.parse("10.0.14");
    private static final String FORGE_OBJECT_HOLDER_FILE = "net/minecraftforge/fml/common/asm/ObjectHolderDefinalize.class";
    private static final String FORGE_MOD_DIR_TRANSFORMER_DISCOVERER_FILE = "net/minecraftforge/fml/loading/ModDirTransformerDiscoverer.class";
    private static final String NEOFORGE_OBJECT_HOLDER_FILE = "net/neoforged/fml/common/asm/ObjectHolderDefinalize.class";
    private static final String NEOFORGE_LAUNCH_HANDLER_FILE = "net/neoforged/fml/loading/targets/CommonUserdevLaunchHandler.class";

    public static void provide(MappingConfiguration mappingConfiguration, Project project) throws Exception {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (String lib : extension.getForgeUserdevProvider().getConfig().libraries()) {
            String version;
            Object dep = null;
            if (lib.startsWith("org.spongepowered:mixin:") && extension.isForge() && ((Boolean)PropertyUtil.getAndFinalize(extension.getForge().getUseCustomMixin())).booleanValue()) {
                if (lib.contains("0.8.2")) {
                    dep = "net.fabricmc:sponge-mixin:0.8.2+build.24";
                } else {
                    version = lib.substring(lib.lastIndexOf(":"));
                    int atIndex = version.indexOf(64);
                    if (atIndex >= 0) {
                        version = version.substring(0, atIndex);
                    }
                    dep = "dev.architectury:mixin-patched" + version + ".+";
                }
            }
            if (lib.startsWith("net.minecraftforge:bootstrap:") && extension.isForge() && extension.getForgeProvider().getVersion().getMajorVersion() >= 49) {
                version = lib.substring(lib.lastIndexOf(":"));
                dependencies.add(project.getDependencies().create((Object)("net.minecraftforge:bootstrap-dev" + version)));
            }
            if (dep == null) {
                dep = lib;
            }
            dependencies.add(project.getDependencies().create(dep));
        }
        ResolvedConfiguration config = project.getConfigurations().detachedConfiguration(dependencies.toArray(new Dependency[0])).getResolvedConfiguration();
        boolean isFancyModLoader10OrNewer = false;
        for (ResolvedArtifact artifact : config.getResolvedArtifacts()) {
            Object dep;
            boolean isFancyML;
            ModuleVersionIdentifier id = artifact.getModuleVersion().getId();
            boolean isFML = FML_LOADER_GROUP.equals(id.getGroup()) && FML_LOADER_NAME.equals(id.getName());
            boolean bl = isFancyML = FANCYML_LOADER_GROUP.equals(id.getGroup()) && FANCYML_LOADER_NAME.equals(id.getName());
            if (isFancyML && Version.parse(id.getVersion()).compareTo(FANCYML_LOADER_UNPROTECT_BACKEND_VERSION) >= 0) {
                isFancyModLoader10OrNewer = true;
            }
            if (isFML || isFancyML) {
                try {
                    if (isFML) {
                        project.getLogger().info(":remapping FML loader");
                    } else if (isFancyML) {
                        project.getLogger().info(":remapping FancyML loader");
                    }
                    dep = ForgeLibrariesProvider.remapFmlLoader(project, artifact, mappingConfiguration);
                }
                catch (IOException e) {
                    throw ExceptionUtil.createDescriptiveWrapper(RuntimeException::new, "Could not remap FML", e);
                }
            } else {
                dep = project.getDependencies().create((Object)ForgeLibrariesProvider.getDependencyNotation(artifact));
                if (dep instanceof ModuleDependency) {
                    ModuleDependency md = (ModuleDependency)dep;
                    md.setTransitive(false);
                }
            }
            DependencyProvider.addDependency(project, dep, "forgeDependencies");
        }
        LoomVersions unprotect = isFancyModLoader10OrNewer ? LoomVersions.UNPROTECT_FANCYMODLOADER10 : LoomVersions.UNPROTECT_MODLAUNCHER;
        DependencyProvider.addDependency(project, unprotect.mavenNotation(), "forgeExtra");
    }

    private static Object remapFmlLoader(Project project, ResolvedArtifact artifact, MappingConfiguration mappingConfiguration) throws IOException {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        String mappingHash = Hashing.sha256().hashString((CharSequence)mappingConfiguration.mappingsIdentifier(), StandardCharsets.UTF_8).toString();
        ModuleVersionIdentifier id = artifact.getModuleVersion().getId();
        LocalMavenHelper mavenHelper = new LocalMavenHelper(id.getGroup() + "." + mappingHash, id.getName(), id.getVersion(), artifact.getClassifier(), extension.getFiles().getForgeDependencyRepo().toPath());
        Path inputJar = artifact.getFile().toPath();
        Path outputJar = mavenHelper.getOutputFile(null);
        if (!Files.exists(outputJar, new LinkOption[0]) || extension.refreshDeps()) {
            Path sourcesJar;
            mavenHelper.copyToMaven(inputJar, null);
            try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(outputJar, false);){
                Path path = fs.get().getPath("META-INF/services/cpw.mods.modlauncher.api.INameMappingService", new String[0]);
                Files.deleteIfExists(path);
                if (Files.exists(fs.get().getPath(FORGE_OBJECT_HOLDER_FILE, new String[0]), new LinkOption[0])) {
                    ForgeLibrariesProvider.remapObjectHolder(project, outputJar, mappingConfiguration);
                }
                if (Files.exists(fs.getPath(FORGE_MOD_DIR_TRANSFORMER_DISCOVERER_FILE, new String[0]), new LinkOption[0])) {
                    ClassVisitorUtil.rewriteClassFile(fs.getPath(FORGE_MOD_DIR_TRANSFORMER_DISCOVERER_FILE, new String[0]), ModDirTransformerDiscovererPatch::new);
                }
                if (Files.exists(fs.getPath(NEOFORGE_OBJECT_HOLDER_FILE, new String[0]), new LinkOption[0])) {
                    ForgeLibrariesProvider.remapNeoForgeObjectHolder(project, outputJar, mappingConfiguration);
                }
                if (Files.exists(fs.getPath(NEOFORGE_LAUNCH_HANDLER_FILE, new String[0]), new LinkOption[0])) {
                    ClassVisitorUtil.rewriteClassFile(fs.getPath(NEOFORGE_LAUNCH_HANDLER_FILE, new String[0]), LaunchHandlerPatcher::new);
                }
            }
            if (!ModConfigurationRemapper.isCIBuild() && (sourcesJar = ModConfigurationRemapper.findSources(project, artifact)) != null) {
                mavenHelper.copyToMaven(sourcesJar, "sources");
            }
        }
        return mavenHelper.getNotation();
    }

    private static void remapObjectHolder(Project project, Path outputJar, MappingConfiguration mappingConfiguration) throws IOException {
        try {
            ForgeMappingsMerger.ExtraMappings extraMappings = ForgeMappingsMerger.ExtraMappings.ofMojmapTsrg(MappingConfiguration.getMojmapSrgFileIfPossible(project));
            MemoryMappingTree mappings = ForgeMappingsMerger.mergeSrg(MappingConfiguration.getRawSrgFile(project), mappingConfiguration.tinyMappings, extraMappings, true);
            RemapObjectHolderVisitor.remapObjectHolder(outputJar, "net.minecraftforge.fml.common.asm.ObjectHolderDefinalize", (MappingTree)mappings, MappingsNamespace.SRG.toString(), MappingsNamespace.NAMED.toString());
        }
        catch (IOException e) {
            throw new IOException("Could not remap object holders in " + String.valueOf(outputJar), e);
        }
    }

    private static void remapNeoForgeObjectHolder(Project project, Path outputJar, MappingConfiguration mappingConfiguration) throws IOException {
        try {
            GradleMappingContext context = new GradleMappingContext(project, "tmp-neoforge-libs");
            MemoryMappingTree mappings = ForgeMappingsMerger.mergeMojang(context, mappingConfiguration.tinyMappings, null, true);
            RemapObjectHolderVisitor.remapObjectHolder(outputJar, "net.neoforged.fml.common.asm.ObjectHolderDefinalize", (MappingTree)mappings, MappingsNamespace.MOJANG.toString(), MappingsNamespace.NAMED.toString());
        }
        catch (IOException e) {
            throw new IOException("Could not remap object holders in " + String.valueOf(outputJar), e);
        }
    }

    private static String getDependencyNotation(ResolvedArtifact artifact) {
        ModuleVersionIdentifier id = artifact.getModuleVersion().getId();
        Object notation = "%s:%s:%s".formatted(id.getGroup(), id.getName(), id.getVersion());
        if (artifact.getClassifier() != null) {
            notation = (String)notation + ":" + artifact.getClassifier();
        }
        return notation;
    }
}

