/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.fabricmc.loom.util.FileSystemUtil;

public interface AsyncZipProcessor {
    public static void processEntries(Path inputZip, Path outputZip, final AsyncZipProcessor processor) throws IOException {
        try (FileSystemUtil.Delegate inFs = FileSystemUtil.getJarFileSystem(inputZip, false);
             FileSystemUtil.Delegate outFs = FileSystemUtil.getJarFileSystem(outputZip, true);){
            final Path inRoot = inFs.get().getPath("/", new String[0]);
            final Path outRoot = outFs.get().getPath("/", new String[0]);
            final ArrayList futures = new ArrayList();
            final ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            Files.walkFileTree(inRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path inputFile, BasicFileAttributes attrs) throws IOException {
                    CompletableFuture<Void> future = CompletableFuture.supplyAsync(() -> {
                        try {
                            String rel = inRoot.relativize(inputFile).toString();
                            Path outputFile = outRoot.resolve(rel);
                            processor.processEntryAsync(inputFile, outputFile);
                        }
                        catch (IOException e) {
                            throw new CompletionException(e);
                        }
                        return null;
                    }, executor);
                    futures.add(future);
                    return FileVisitResult.CONTINUE;
                }
            });
            for (CompletableFuture future : futures) {
                try {
                    future.join();
                }
                catch (CompletionException e) {
                    Throwable throwable = e.getCause();
                    if (throwable instanceof IOException) {
                        IOException ioe = (IOException)throwable;
                        throw ioe;
                    }
                    throw new RuntimeException("Failed to process zip", e.getCause());
                }
            }
            executor.shutdown();
        }
    }

    public void processEntryAsync(Path var1, Path var2) throws IOException;
}

