/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.srg;

import com.google.common.collect.HashBiMap;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.tinyremapper.IMappingProvider;

public class InnerClassRemapper {
    public static IMappingProvider of(Set<String> fromClassNames, MappingTree mappingsWithSrg, String from, String to) throws IOException {
        return sink -> InnerClassRemapper.remapInnerClass(fromClassNames, mappingsWithSrg, from, to, (arg_0, arg_1) -> ((IMappingProvider.MappingAcceptor)sink).acceptClass(arg_0, arg_1));
    }

    public static Set<String> readClassNames(Path jar) {
        HashSet<String> set = new HashSet<String>();
        try (FileSystemUtil.Delegate system = FileSystemUtil.getJarFileSystem(jar, false);){
            Iterator iterator = Files.walk(system.get().getPath("/", new String[0]), new FileVisitOption[0]).iterator();
            while (iterator.hasNext()) {
                Path path = (Path)iterator.next();
                String name = path.toString();
                if (name.startsWith("/")) {
                    name = name.substring(1);
                }
                if (Files.isDirectory(path, new LinkOption[0]) || !name.contains("$") || !name.endsWith(".class")) continue;
                String className = name.substring(0, name.length() - 6);
                set.add(className);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return set;
    }

    private static void remapInnerClass(Set<String> classNames, MappingTree mappingsWithSrg, String from, String to, BiConsumer<String, String> action) {
        HashBiMap availableClasses = HashBiMap.create(mappingsWithSrg.getClasses().stream().collect(Collectors.groupingBy(classDef -> classDef.getName(from), Collectors.reducing(null, classDef -> classDef.getName(to), (first, last) -> last))));
        for (String className : classNames) {
            if (availableClasses.containsKey((Object)className)) continue;
            String parentName = className.substring(0, className.indexOf(36));
            String childName = className.substring(className.indexOf(36) + 1);
            String remappedParentName = (String)availableClasses.getOrDefault((Object)parentName, (Object)parentName);
            String remappedName = remappedParentName + "$" + childName;
            if (className.equals(remappedName)) continue;
            if (availableClasses.containsValue((Object)remappedName)) {
                action.accept(className, remappedName + "_UNBREAK");
                continue;
            }
            action.accept(className, remappedName);
        }
    }
}

