/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.forge.mcpconfig;

import com.google.common.base.Stopwatch;
import com.google.common.hash.Hashing;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.loom.forge.tool.ForgeToolExecutor;
import dev.architectury.loom.forge.tool.ForgeToolValueSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.providers.forge.ConfigValue;
import net.fabricmc.loom.configuration.providers.forge.ForgeProvider;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.DependencySet;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.McpConfigFunction;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.McpConfigProvider;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.McpConfigStep;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.ConstantLogic;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.DownloadManifestFileLogic;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.FunctionLogic;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.InjectLogic;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.ListLibrariesLogic;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.NoOpLogic;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.PatchLogic;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.StepLogic;
import net.fabricmc.loom.configuration.providers.forge.mcpconfig.steplogic.StripLogic;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.util.ModPlatform;
import net.fabricmc.loom.util.download.DownloadBuilder;
import net.fabricmc.loom.util.function.CollectionUtil;
import net.fabricmc.loom.util.gradle.GradleUtils;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.Nullable;

public final class McpExecutor {
    private static final LogLevel STEP_LOG_LEVEL = LogLevel.LIFECYCLE;
    private final Project project;
    private final MinecraftProvider minecraftProvider;
    private final Path cache;
    private final List<McpConfigStep> steps;
    private final DependencySet dependencySet;
    private final Map<String, McpConfigFunction> functions;
    private final Map<String, String> config = new HashMap<String, String>();
    private final Map<String, String> extraConfig = new HashMap<String, String>();
    @Nullable
    private StepLogic.Provider stepLogicProvider = null;

    public McpExecutor(Project project, MinecraftProvider minecraftProvider, Path cache, McpConfigProvider provider, String environment) {
        this.project = project;
        this.minecraftProvider = minecraftProvider;
        this.cache = cache;
        this.steps = provider.getData().steps().get(environment);
        this.functions = provider.getData().functions();
        this.dependencySet = new DependencySet(this.steps);
        this.dependencySet.skip(step -> this.getStepLogic(step.name(), step.type()) instanceof NoOpLogic);
        this.dependencySet.setIgnoreDependenciesFilter(step -> this.getStepLogic(step.name(), step.type()).hasNoContext());
        this.checkMinecraftVersion(provider);
        this.addDefaultFiles(provider, environment);
    }

    private void checkMinecraftVersion(McpConfigProvider provider) {
        String actual;
        String expected = provider.getData().version();
        if (!expected.equals(actual = this.minecraftProvider.minecraftVersion())) {
            LoomGradleExtension extension = LoomGradleExtension.get(this.project);
            ForgeProvider forgeProvider = extension.getForgeProvider();
            String message = "%s %s is not for Minecraft %s (expected: %s).".formatted(((ModPlatform)((Object)extension.getPlatform().get())).displayName(), forgeProvider.getVersion().getCombined(), actual, expected);
            if (GradleUtils.getBooleanProperty(this.project, "loom.allowMismatchedPlatformVersion")) {
                this.project.getLogger().warn(message);
            } else {
                String fullMessage = "%s\nYou can suppress this error by adding '%s = true' to gradle.properties.".formatted(message, "loom.allowMismatchedPlatformVersion");
                throw new UnsupportedOperationException(fullMessage);
            }
        }
    }

    private void addDefaultFiles(McpConfigProvider provider, String environment) {
        for (Map.Entry entry : provider.getData().data().entrySet()) {
            JsonObject json;
            if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                this.addDefaultFile(provider, (String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            if (!((JsonElement)entry.getValue()).isJsonObject() || !(json = ((JsonElement)entry.getValue()).getAsJsonObject()).has(environment) || !json.get(environment).isJsonPrimitive()) continue;
            this.addDefaultFile(provider, (String)entry.getKey(), json.getAsJsonPrimitive(environment).getAsString());
        }
    }

    private void addDefaultFile(McpConfigProvider provider, String key, String value) {
        Path path = provider.getUnpackedZip().resolve(value).toAbsolutePath();
        if (!path.startsWith(provider.getUnpackedZip().toAbsolutePath())) {
            return;
        }
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        this.addConfig(key, path.toString());
    }

    public void addConfig(String key, String value) {
        this.config.put(key, value);
    }

    private Path getDownloadCache() throws IOException {
        Path downloadCache = this.cache.resolve("downloads");
        Files.createDirectories(downloadCache, new FileAttribute[0]);
        return downloadCache;
    }

    private Path getStepCache(String step) {
        return this.cache.resolve(step);
    }

    private Path createStepCache(String step) throws IOException {
        Path stepCache = this.getStepCache(step);
        Files.createDirectories(stepCache, new FileAttribute[0]);
        return stepCache;
    }

    private String resolve(McpConfigStep step, ConfigValue value) {
        return value.resolve(variable -> {
            String name = variable.name();
            @Nullable ConfigValue valueFromStep = step.config().get(name);
            if (valueFromStep != null && !valueFromStep.equals(variable)) {
                return this.resolve(step, valueFromStep);
            }
            if (this.config.containsKey(name)) {
                return this.config.get(name);
            }
            if (this.extraConfig.containsKey(name)) {
                return this.extraConfig.get(name);
            }
            if (name.equals("log")) {
                return this.cache.resolve("log.log").toAbsolutePath().toString();
            }
            throw new IllegalArgumentException("Unknown MCP config variable: " + name);
        });
    }

    public McpExecutor enqueue(String step) {
        this.dependencySet.add(step);
        return this;
    }

    public Path execute() throws IOException {
        SortedSet<String> stepNames = this.dependencySet.buildExecutionSet();
        this.dependencySet.clear();
        ArrayList<McpConfigStep> toExecute = new ArrayList<McpConfigStep>();
        for (String stepName : stepNames) {
            McpConfigStep step = CollectionUtil.find(this.steps, s -> s.name().equals(stepName)).orElseThrow(() -> new NoSuchElementException("Step '" + stepName + "' not found in MCP config"));
            toExecute.add(step);
        }
        return this.executeSteps(toExecute);
    }

    public Path executeSteps(List<McpConfigStep> steps) throws IOException {
        this.extraConfig.clear();
        int totalSteps = steps.size();
        int currentStepIndex = 0;
        this.project.getLogger().log(STEP_LOG_LEVEL, ":executing {} MCP steps", new Object[]{totalSteps});
        for (McpConfigStep currentStep : steps) {
            StepLogic stepLogic = this.getStepLogic(currentStep.name(), currentStep.type());
            this.project.getLogger().log(STEP_LOG_LEVEL, ":step {}/{} - {}", new Object[]{++currentStepIndex, totalSteps, stepLogic.getDisplayName(currentStep.name())});
            Stopwatch stopwatch = Stopwatch.createStarted();
            stepLogic.execute(new ExecutionContextImpl(currentStep));
            this.project.getLogger().log(STEP_LOG_LEVEL, ":{} done in {}", new Object[]{currentStep.name(), stopwatch.stop()});
        }
        return Path.of(this.extraConfig.get("output"), new String[0]);
    }

    public void setStepLogicProvider(@Nullable StepLogic.Provider stepLogicProvider) {
        this.stepLogicProvider = stepLogicProvider;
    }

    private StepLogic getStepLogic(String name, String type) {
        StepLogic custom;
        if (this.stepLogicProvider != null && (custom = (StepLogic)this.stepLogicProvider.getStepLogic(name, type).orElse(null)) != null) {
            return custom;
        }
        return switch (type) {
            case "downloadManifest", "downloadJson" -> new NoOpLogic();
            case "downloadClient" -> new ConstantLogic(() -> this.minecraftProvider.getMinecraftClientJar().toPath());
            case "downloadServer" -> new ConstantLogic(() -> this.minecraftProvider.getMinecraftServerJar().toPath());
            case "strip" -> new StripLogic();
            case "listLibraries" -> new ListLibrariesLogic();
            case "downloadClientMappings" -> new DownloadManifestFileLogic(this.minecraftProvider.getVersionInfo().download("client_mappings"));
            case "downloadServerMappings" -> new DownloadManifestFileLogic(this.minecraftProvider.getVersionInfo().download("server_mappings"));
            case "inject" -> new InjectLogic();
            case "patch" -> new PatchLogic();
            default -> {
                if (this.functions.containsKey(type)) {
                    yield new FunctionLogic(this.functions.get(type));
                }
                throw new UnsupportedOperationException("MCP config step type: " + type);
            }
        };
    }

    private class ExecutionContextImpl
    implements StepLogic.ExecutionContext {
        private final McpConfigStep step;

        ExecutionContextImpl(McpConfigStep step) {
            this.step = step;
        }

        @Override
        public Logger logger() {
            return McpExecutor.this.project.getLogger();
        }

        @Override
        public Path setOutput(String fileName) throws IOException {
            return this.setOutput(this.cache().resolve(fileName));
        }

        @Override
        public Path setOutput(Path output) {
            String absolutePath = output.toAbsolutePath().toString();
            McpExecutor.this.extraConfig.put("output", absolutePath);
            McpExecutor.this.extraConfig.put(this.step.name() + "Output", absolutePath);
            return output;
        }

        @Override
        public Path cache() throws IOException {
            return McpExecutor.this.createStepCache(this.step.name());
        }

        @Override
        public Path mappings() {
            return LoomGradleExtension.get(McpExecutor.this.project).getMcpConfigProvider().getMappings();
        }

        @Override
        public String resolve(ConfigValue value) {
            return McpExecutor.this.resolve(this.step, value);
        }

        @Override
        public Path downloadFile(String url) throws IOException {
            Path path = McpExecutor.this.getDownloadCache().resolve(Hashing.sha256().hashString((CharSequence)url, StandardCharsets.UTF_8).toString().substring(0, 24));
            ExecutionContextImpl.redirectAwareDownload(url, path);
            return path;
        }

        @Override
        public Path downloadDependency(String notation) {
            Dependency dependency = McpExecutor.this.project.getDependencies().create((Object)notation);
            Configuration configuration = McpExecutor.this.project.getConfigurations().detachedConfiguration(new Dependency[]{dependency});
            configuration.setTransitive(false);
            return configuration.getSingleFile().toPath();
        }

        @Override
        public DownloadBuilder downloadBuilder(String url) {
            return LoomGradleExtension.get(McpExecutor.this.project).download(url);
        }

        private static void redirectAwareDownload(String urlString, Path path) throws IOException {
            URL url = new URL(urlString);
            if (url.getProtocol().equals("http")) {
                url = new URL("https", url.getHost(), url.getPort(), url.getFile());
            }
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            if (connection.getResponseCode() == 301 || connection.getResponseCode() == 302) {
                ExecutionContextImpl.redirectAwareDownload(connection.getHeaderField("Location"), path);
            } else {
                try (InputStream in = connection.getInputStream();){
                    Files.copy(in, path, new CopyOption[0]);
                }
            }
        }

        @Override
        public void javaexec(Action<? super ForgeToolExecutor.Settings> configurator) {
            ForgeToolValueSource.exec(McpExecutor.this.project, configurator);
        }

        @Override
        public Set<File> getMinecraftLibraries() {
            return McpExecutor.this.project.getConfigurations().getByName("minecraftRuntimeLibraries").resolve();
        }
    }
}

