/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.sources;

import dev.architectury.loom.forge.tool.ForgeToolExecutor;
import dev.architectury.loom.util.MappingOption;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.build.IntermediaryNamespaces;
import net.fabricmc.loom.configuration.providers.mappings.TinyMappingsService;
import net.fabricmc.loom.task.GenerateSourcesTask;
import net.fabricmc.loom.util.DeletingFileVisitor;
import net.fabricmc.loom.util.DependencyDownloader;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.LoomVersions;
import net.fabricmc.loom.util.SourceRemapper;
import net.fabricmc.loom.util.ThreadingUtils;
import net.fabricmc.loom.util.TinyRemapperHelper;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.lorenztiny.TinyMappingsReader;
import net.fabricmc.mappingio.tree.MappingTree;
import org.apache.commons.io.output.NullOutputStream;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.mercury.Mercury;
import org.cadixdev.mercury.remapper.MercuryRemapper;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.jetbrains.annotations.Nullable;

public class ForgeSourcesRemapper {
    public static void addBaseForgeSources(Project project, ServiceFactory serviceFactory) throws IOException {
        List<Path> minecraftJars = LoomGradleExtension.get(project).getMinecraftJars(MappingsNamespace.NAMED);
        if (minecraftJars.isEmpty()) {
            throw new IllegalStateException("Could not find Minecraft jar for Forge sources");
        }
        if (minecraftJars.size() > 1) {
            return;
        }
        Path minecraftJar = minecraftJars.get(0);
        Path sourcesJar = GenerateSourcesTask.getJarFileWithSuffix("-sources.jar", minecraftJar).toPath();
        if (!Files.exists(sourcesJar, new LinkOption[0])) {
            ForgeSourcesRemapper.addForgeSources(project, serviceFactory, minecraftJar, sourcesJar);
        }
    }

    public static void addForgeSources(Project project, ServiceFactory serviceFactory, @Nullable Path inputJar, Path sourcesJar) throws IOException {
        try (FileSystemUtil.Delegate inputFs = inputJar == null ? null : FileSystemUtil.getJarFileSystem(inputJar, true);
             FileSystemUtil.Delegate outputFs = FileSystemUtil.getJarFileSystem(sourcesJar, true);){
            ThreadingUtils.TaskCompleter taskCompleter = ThreadingUtils.taskCompleter();
            ForgeSourcesRemapper.provideForgeSources(project, serviceFactory, path -> {
                Path inputPath;
                Path path2 = inputPath = inputFs == null ? null : inputFs.get().getPath(path.replace(".java", ".class"), new String[0]);
                if (inputPath != null && Files.notExists(inputPath, new LinkOption[0])) {
                    project.getLogger().info("Discarding forge source file {} as it does not exist in the input jar", path);
                    return false;
                }
                return !path.contains("$");
            }, (path, bytes) -> {
                Path fsPath = outputFs.get().getPath((String)path, new String[0]);
                if (fsPath.getParent() != null) {
                    try {
                        Files.createDirectories(fsPath.getParent(), new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                taskCompleter.add(() -> {
                    project.getLogger().info("Added forge source file {}", path);
                    Files.write(fsPath, bytes, StandardOpenOption.CREATE);
                });
            });
            taskCompleter.complete();
        }
    }

    public static void provideForgeSources(Project project, ServiceFactory serviceFactory, Predicate<String> classFilter, BiConsumer<String, byte[]> consumer) throws IOException {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        String sourceDependency = extension.getForgeUserdevProvider().getConfig().sources();
        ArrayList<Path> forgeInstallerSources = new ArrayList<Path>();
        for (File file : DependencyDownloader.download(project, sourceDependency)) {
            forgeInstallerSources.add(file.toPath());
            project.getLogger().info("Found forge source jar: {}", (Object)file);
        }
        project.getLogger().lifecycle(":found {} forge source jars", new Object[]{forgeInstallerSources.size()});
        Map<String, byte[]> forgeSources = ForgeSourcesRemapper.extractSources(forgeInstallerSources);
        forgeSources.keySet().removeIf(classFilter.negate());
        project.getLogger().lifecycle(":extracted {} forge source classes", new Object[]{forgeSources.size()});
        ForgeSourcesRemapper.remapSources(project, serviceFactory, forgeSources);
        forgeSources.forEach(consumer);
    }

    private static void remapSources(Project project, ServiceFactory serviceFactory, Map<String, byte[]> sources) throws IOException {
        File tmpInput = File.createTempFile("tmpInputForgeSources", null);
        tmpInput.delete();
        tmpInput.deleteOnExit();
        File tmpOutput = File.createTempFile("tmpOutputForgeSources", null);
        tmpOutput.delete();
        tmpOutput.deleteOnExit();
        try (FileSystemUtil.Delegate delegate = FileSystemUtil.getJarFileSystem(tmpInput, true);){
            ThreadingUtils.TaskCompleter taskCompleter = ThreadingUtils.taskCompleter();
            for (Map.Entry<String, byte[]> entry : sources.entrySet()) {
                Path path = delegate.get().getPath(entry.getKey(), new String[0]);
                if (path.getParent() != null) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                }
                taskCompleter.add(() -> Files.write(path, (byte[])entry.getValue(), StandardOpenOption.CREATE));
            }
            taskCompleter.complete();
        }
        PrintStream out = System.out;
        PrintStream err = System.err;
        if (!ForgeToolExecutor.shouldShowVerboseStderr(project)) {
            System.setOut(new PrintStream((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM));
            System.setErr(new PrintStream((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM));
        }
        ForgeSourcesRemapper.remapForgeSourcesInner(project, serviceFactory, tmpInput.toPath(), tmpOutput.toPath());
        if (!ForgeToolExecutor.shouldShowVerboseStderr(project)) {
            System.setOut(out);
            System.setErr(err);
        }
        tmpInput.delete();
        int[] failedToRemap = new int[]{0};
        try (FileSystemUtil.Delegate delegate = FileSystemUtil.getJarFileSystem(tmpOutput, false);){
            ThreadingUtils.TaskCompleter taskCompleter = ThreadingUtils.taskCompleter();
            for (Map.Entry<String, byte[]> entry : new HashSet<Map.Entry<String, byte[]>>(sources.entrySet())) {
                taskCompleter.add(() -> {
                    Path path = delegate.get().getPath((String)entry.getKey(), new String[0]);
                    if (Files.exists(path, new LinkOption[0])) {
                        sources.put((String)entry.getKey(), Files.readAllBytes(path));
                    } else {
                        sources.remove(entry.getKey());
                        project.getLogger().error("Failed to remap sources for " + (String)entry.getKey());
                        failedToRemap[0] = failedToRemap[0] + 1;
                    }
                });
            }
            taskCompleter.complete();
        }
        tmpOutput.delete();
        if (failedToRemap[0] > 0) {
            project.getLogger().error("Failed to remap {} forge sources", (Object)failedToRemap[0]);
        }
    }

    private static void remapForgeSourcesInner(Project project, ServiceFactory serviceFactory, Path tmpInput, Path tmpOutput) throws IOException {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        Mercury mercury = SourceRemapper.createMercuryWithClassPath(project, false);
        MappingOption mappingOption = MappingOption.forPlatform(extension);
        String sourceNamespace = IntermediaryNamespaces.intermediary(project);
        TinyMappingsService mappingsService = extension.getMappingConfiguration().getMappingsService(project, serviceFactory, mappingOption);
        MappingSet mappings = new TinyMappingsReader((MappingTree)mappingsService.getMappingTree(), sourceNamespace, "named").read();
        for (Map.Entry<String, String> entry : TinyRemapperHelper.JSR_TO_JETBRAINS.entrySet()) {
            mappings.getOrCreateClassMapping(entry.getKey()).setDeobfuscatedName(entry.getValue());
        }
        Set files = project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencies().create((Object)LoomVersions.JETBRAINS_ANNOTATIONS.mavenNotation())}).resolve();
        for (File file : files) {
            mercury.getClassPath().add(file.toPath());
        }
        MappingsNamespace mappingsNamespace = extension.isNeoForge() ? MappingsNamespace.MOJANG : MappingsNamespace.SRG;
        mercury.getClassPath().addAll(0, extension.getMinecraftJars(mappingsNamespace));
        List newClassPath = mercury.getClassPath().stream().distinct().filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        mercury.getClassPath().clear();
        mercury.getClassPath().addAll(newClassPath);
        mercury.getProcessors().add(MercuryRemapper.create((MappingSet)mappings));
        boolean isSrcTmp = false;
        if (!Files.isDirectory(tmpInput, new LinkOption[0])) {
            Path tmpInput1 = tmpInput;
            isSrcTmp = true;
            tmpInput = Files.createTempDirectory("fabric-loom-src", new FileAttribute[0]);
            ZipUtils.unpackAll(tmpInput1, tmpInput);
        }
        try (FileSystemUtil.Delegate outputFs = FileSystemUtil.getJarFileSystem(tmpOutput, true);){
            Path outputFsRoot = outputFs.get().getPath("/", new String[0]);
            mercury.rewrite(tmpInput, outputFsRoot);
        }
        catch (Exception e) {
            project.getLogger().warn("Could not remap " + String.valueOf(tmpInput) + " fully!", (Throwable)e);
        }
        if (isSrcTmp) {
            Files.walkFileTree(tmpInput, new DeletingFileVisitor());
        }
    }

    private static Map<String, byte[]> extractSources(List<Path> forgeInstallerSources) throws IOException {
        ConcurrentHashMap<String, byte[]> sources = new ConcurrentHashMap<String, byte[]>();
        ThreadingUtils.TaskCompleter taskCompleter = ThreadingUtils.taskCompleter();
        for (Path path : forgeInstallerSources) {
            FileSystemUtil.Delegate system = FileSystemUtil.getJarFileSystem(path, false);
            taskCompleter.onComplete(stopwatch -> system.close());
            for (Path filePath : Files.walk(system.get().getPath("/", new String[0]), new FileVisitOption[0])::iterator) {
                if (!Files.isRegularFile(filePath, new LinkOption[0]) || !filePath.getFileName().toString().endsWith(".java")) continue;
                taskCompleter.add(() -> sources.put(filePath.toString(), Files.readAllBytes(filePath)));
            }
        }
        taskCompleter.complete();
        return sources;
    }
}

